
<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="page box box-primary">
        <div class="container-fluid">
            <div class="top-content box-header with-border">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="pull-left">
                            <h3><?php echo e(__('administrator.report_stock_item')); ?></h3>
                        </div>
                        <div class="pull-right">
                            <a href="<?php echo e(route('transfer-stock.create')); ?>" class=" btn btn-primary"><span  class="fa fa-plus"></span> <?php echo e(__('administrator.add_new')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            <br>
            <div class="wrapper-table table-responsive">
                <table id="print_table" class="table ​​">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(__('administrator.date')); ?></th>
                        <th><?php echo e(__('administrator.invoice_number')); ?></th>
                        <th><?php echo e(__('administrator.user')); ?></th>
                        <th><?php echo e(__('administrator.transfer_to')); ?></th>
                        <th><?php echo e(__('administrator.confirm_received')); ?></th>
                        <th><?php echo e(__('administrator.action')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        let table = $('#print_table');
        $(document).ready(function () {
            getTable();
            $('.select2').on('change', function () {
                let supplier = $('select[name=supplier]').val();
                let type = $('select[name=type]').val();
                getTable(supplier, type);
            });
            $(document).on('click', ' .show_request', function () {
                let id = $(this).data('id');
                let confirm_status = $(this).data('confirm_status');
                $.ajax({
                    url: $(this).data('href'),
                    method: 'get',
                    dataType: 'html',
                    success: function (data) {
                        $.confirm({
                            title: '',
                            theme: 'modern',
                            useBootstrap: false,
                            boxWidth: '50%',
                            content: data,
                            buttons: {
                                close: {
                                    text: '<?php echo e(__('administrator.close')); ?>',
                                    btnClass: 'btn-warning',
                                },
                                print: {
                                    text: '<?php echo e(__('administrator.print')); ?>',
                                    btnClass: 'btn-info',
                                    keys: ['enter'],
                                    action: function () {
                                        $('.page-purchases').printThis({
                                            loadCSS: "<?php echo e(asset('assets/css/pos-invoice.css')); ?>",
                                            afterPrint: function () {
                                                window.location.reload();
                                            }
                                        });
                                        return false;
                                    },
                                },
                                confirm_received: {
                                text: '<?php echo e(__('administrator.confirm_received')); ?>',
                                btnClass: 'btn-success confirm_status',
                                keys: ['enter'],
                                action: function () {
                                    confirmForm('<?php echo route("transfer-stock-confirm",1); ?>?id='+id, '<?php echo e(__('administrator.confirm_received')); ?>','', 'success', '600px', 'fa fa-check', 'green')
                                    return false
                                }
                            },
                                seller_reject: {
                                text: '<?php echo e(__('administrator.reject')); ?>',
                                btnClass: 'btn-danger confirm_status',
                                keys: ['enter'],
                                action: function () {
                                    confirmForm('<?php echo route("transfer-stock-confirm",2); ?>?id='+id, '<?php echo e(__('administrator.reject')); ?>','', 'danger', '600px', 'fa fa-times', 'red')
                                    return false
                                }
                            }
                            },
                        });
                        setTimeout(function () {
                            if (confirm_status === 0) {
                                $('.confirm_status').remove();
                            }
                        },10);

                    }
                });
            });
        });
        function getTable() {
            let from_date = $('thead').find('input[name=from_date]').val();
            let to_date = $('thead').find('input[name=to_date]').val();
            let branch_id = $('thead').find('select[name=branch_id]').val();
            let product_unit_id = $('thead').find('select[name=product_unit_id]').val();
            let shelf_id = $('thead').find('select[name=shelf_id]').val();
            table.DataTable().destroy();
            let column = [
                {data: 'DT_RowIndex'},
                {data: 'date'},
                {data: 'invoice_number'},
                {data: 'user_id'},
                {data: 'to_branch'},
                {data: 'confirm_status'},
                {data: 'action'},
            ];
            table.DataTable({
                serverSide: true,
                ordering: false,
                searching: false,
                lengthMenu: tbLength,
                ajax: {
                    url: "<?php echo e(route('transfer-stock.index')); ?>",
                    data:{
                        from_date:from_date,
                        to_date:to_date,
                        branch_id:branch_id,
                        product_unit_id:product_unit_id,
                        shelf_id:shelf_id,
                    },
                },
                columns: column,
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/transfer-stock/index.blade.php ENDPATH**/ ?>