
<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><?php echo e(__('administrator.report_stock_item')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group padding-0">
                        <div>
                            <div class="col-sm-3 col-md-3">
                                <div class="col-sm-3 col-md-3" style="margin-top: 5px">
                                    <?php echo e(__('administrator.warehouse')); ?>

                                </div>
                                <div class="form-group col-sm-9 col-md-9">
                                    <?php echo Form::select('warehouse', $warehouses, null, array('class' => 'form-control select2', 'placeholder' =>  __('administrator.please_select_warehouse'))); ?>

                                </div>
                            </div>
                            <div class="col-sm-offset-6 col-sm-6">
                                <button class=" button_success pull-right print_button" type="button" data-text="<?php echo e(__('administrator.report_stock')); ?>"><i class="fa fa-print" ></i> <?php echo e(__('administrator.print')); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="print_table" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(__('administrator.warehouse')); ?></th>
                        <th><?php echo e(__('administrator.barcode')); ?></th>
                        <th><?php echo e(__('administrator.item_name')); ?></th>
                        <th><?php echo e(__('administrator.import_qty')); ?></th>
                        <th><?php echo e(__('administrator.production_qty')); ?></th>
                        <th><?php echo e(__('administrator.export_qty')); ?></th>
                        <th><?php echo e(__('administrator.balance_qty')); ?></th>
                    </tr>
                    </thead>
                    <tbody class="tbody">
                    </tbody>
                </table>
            </div>
        </div>
        <?php $__env->stopSection(); ?>
        <?php $__env->startSection('script'); ?>
            <script type="text/javascript">
                function getTable(warehouse=''){
                    $('#print_table').DataTable({
                        "oLanguage": {
                            "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                            "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                            "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                            "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                            "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                            "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                            "oPaginate": {
                                "sFirst": "<?php echo e(__('administrator.first')); ?>",
                                "sLast": "<?php echo e(__('administrator.last')); ?>",
                                "sNext": "<?php echo e(__('administrator.next')); ?>",
                                "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                            },
                        },
                        ordering: false,
                        serverSide: true,
                        lengthMenu: tbLength,
                        ajax: {
                            url:'<?php echo e(route('report.stock-item')); ?>',
                            data:{
                                warehouse:warehouse,
                            },
                        },
                        columns:
                            [
                                {data: 'DT_RowIndex','searchable': false},
                                {data: 'warehouse', 'searchable': true},
                                {data: 'barcode', 'name': 'nso007_stocks.barcode'},
                                {data: 'product_name', 'name': 'nso007_products.product_name'},
                                {data: 'in_qty'},
                                {data: 'production_qty'},
                                {data: 'out_qty'},
                                {data: 'stock_qty'},
                            ],
                        "footerCallback": function (row, data, start, end, display) {

                        },
                    });
                }
                $(document).ready(function () {
                    getTable();
                    $('select').on('change',function () {
                        $('#print_table').DataTable().destroy();
                        let warehouse = $('select[name=warehouse]').val();
                        getTable(warehouse);
                    });
                });
            </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/report-stock/stock-item.blade.php ENDPATH**/ ?>