 <?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <fieldset>
            <legend><?php echo e(__('administrator.adjustment')); ?></legend>
            <?php echo Form::open(array('route' => 'adjustment.store','method'=>'POST','class'=>'jform')); ?>

            <div class="col-sm-12 col-xs-12">
            <div class="col-md-offset-2 col-lg-offset-2 col-sm-12 col-xs-12 col-md-6 col-lg-6">
                <div class="col-sm-12 col-xs-12 col-lg-12 col-md-12 form-group">
                    <div class="col-sm-4 col-xs-12 col-lg-3 col-md-3">
                        <?php echo e(__('administrator.date')); ?>

                    </div>
                    <div class="col-sm-8 col-xs-12 col-lg-9 col-md-9">
                        <?php echo Form::text('adjustment_date',date('d-m-Y'), ['class' => 'form-control date_picker']); ?>

                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 col-lg-12 col-md-12 form-group">
                    <div class="col-sm-4 col-xs-12 col-lg-3 col-md-3">
                        <?php echo e(__('administrator.user')); ?>

                    </div>
                    <div class="col-sm-8 col-xs-12 col-lg-9 col-md-9">
                        <?php echo Form::text('user',Auth::user()->name, ['class' => 'form-control','readonly']); ?>

                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 col-lg-12 col-md-12 form-group">
                    <div class="col-sm-4 col-xs-12 col-lg-3 col-md-3">
                        <?php echo e(__('administrator.note')); ?>

                    </div>
                    <div class="col-sm-8 col-xs-12 col-lg-9 col-md-9">
                        <?php echo Form::textarea('note',null, ['class' => 'form-control','rows'=>'3']); ?>

                    </div>
                </div>
            </div>
            </div>
            <div class="col-sm-12 col-xs-12">
                <table class="table-responsive table table-striped">
                    <thead>
                    <th>#</th>
                    <th width="20%"><?php echo e(__('administrator.item')); ?> *</th>
                    <th><?php echo e(__('administrator.shelf')); ?></th>
                    <th><?php echo e(__('administrator.stock')); ?></th>
                    <th><?php echo e(__('administrator.operator')); ?></th>
                    <th><?php echo e(__('administrator.qty')); ?> *</th>
                    <th><?php echo e(__('administrator.balance')); ?></th>
                    <th><span class="btn btn-info fa fa-plus" onclick="addRow()"></span></th>
                    </thead>
                    <tbody class="tbody"></tbody>
                </table>
            </div>
            <div class="col-sm-12 text-right">
                <?php echo $__env->make('component.form-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <?php echo Form::close(); ?>

        </fieldset>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        let count = 1;
        $(document).ready(function () {
            addRow();
            $(document).on('change', '.search_product,.shelf', function () {
                changeProUnit($(this));
            });

            $(document).on('change', 'select[name="operator[]"], .stock_qty', function () {
                operator($(this));
            });
            $(document).on('keyup', 'input[name="qty[]"]', function () {
                let _this = $(this);
                operator(_this);
            });
        });

        function operator(_this) {
            let qty = _this.closest('tr').find('input[name="qty[]"]').val();
            let stock_qty = _this.closest('tr').find('.stock_qty').val();
            let operator = _this.closest('tr').find('select[name="operator[]"]').val();
            qty = qty ? parseFloat(qty) : 0;
            stock_qty = stock_qty ? parseFloat(stock_qty) : 0;
            let balance = eval(stock_qty + operator + qty);
            if (balance < 0) {
                balance = stock_qty;
                _this.closest('tr').find('input[name="qty[]"]').val(stock_qty);
            }
            _this.closest('tr').find('input[name="balance[]"]').val(balance)
        }

        function changeProUnit(_this) {
            let product_unit_id = _this.closest('tr').find('.search_product').val();
            let shelf = _this.closest('tr').find('.shelf').val();
            $.ajax({
                url: '<?php echo e(route('adjustment.create')); ?>',
                dataType: 'json',
                method: 'get',
                data: {
                    product_unit_id, shelf
                },
                success: function (data) {
                    _this.closest('tr').find('.stock_qty').val(data.qty);
                },
                error(xhr) {
                    alertErrorFormController(xhr);
                }
            });
        }

        function addRow() {
            let html = `
                <tr>
                <td>${count++}</td>
                <td>
                        <?php echo Form::select('product_unit_id[]',[],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_product']); ?>

                </td>
                <td>
                    <?php echo Form::select('shelf[]',getProductShelf(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control shelf select2']); ?>

                </td>
                <td>
                    <?php echo Form::text('stock[]',0, ['placeholder'=>__('administrator.stock'),'class' => 'form-control stock_qty','readonly']); ?>

                </td>
                <td>
                    <?php echo Form::select('operator[]',['+'=>__('administrator.+'),'-'=>__('administrator.-')],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']); ?>

                </td>
                <td>
                    <?php echo Form::text('qty[]',null, ['placeholder'=>__('administrator.qty'),'class' => 'form-control number-only']); ?>

                </td>
                <td>
                    <?php echo Form::text('balance[]',0, ['placeholder'=>__('administrator.balance'),'class' => 'form-control','readonly']); ?>

                </td>
                <td>
                <span class="btn btn-danger fa fa-times" onclick="$(this).closest('tr').remove()"></span>
                </td>
                </tr>
`;
            $('.tbody').append(html).find('tr:last .select2').select2();
            search_product();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/stock-inventory/adjustment/create.blade.php ENDPATH**/ ?>