<!doctype html>
<?php Fun::lang()?>
<html>
<head>
    <meta charset="utf-8">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/pos-invoice.css')); ?>">
    <?php
    $hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
    ?>
    <style>
        .inv-tfoot {
            text-align: right;
        }
    </style>
</head>
<body>
<?php
if ($master->sale_type === 'wholesale') {
    $customer = findUser($master->member_id);
    $member_type = getMemberTypes($master->member_type_id);
    $customer_phone = $customer ? $customer->phone : '';
    $customer_name = $customer ? ($customer->name.' ('.$member_type.')') : '';
    $customer_address = findProvince($customer->province_id)->name_kh ?? '';
} else {
    $customer = findCustomer($master->customer_id);
    $customer_phone = $customer->customer_phone ?? '';
    $customer_name = $customer->customer_name ?? '';
    $customer_address = $customer->customer_address ?? '';
}

$seller = findUser($master->user_id);
$seller = $seller ? $seller->name : '';
$status = $master->status;
$payment_status = $master->payment_status;
$branch = mainBranch();
?>

<div class="print_this_form" style="font-size: 12px">
    <table class="table-borderless" width="100%">
        <thead>
        <tr>
            <td class="text-center">
                <img src="<?php echo e(findImg($branch->logo)); ?>" style="width: 100px">
                <br>
                <h3><?php echo e($master->payment_status==='paid'?__('administrator.receipt'):__('administrator.invoice')); ?></h3>
            </td>
        </tr>
        </thead>
    </table>
    <hr>
    <table class="table-borderless">
        <thead>
        <tr>
            <td class="text-left">កាលបរិច្ឆេទ</td>
            <td class="text-left">: <?php echo e(date('d-m-Y h:i',strtotime($master->sale_date))); ?></td>
        </tr>
        <tr>
            <td class="text-left"><?php echo e($master->payment_status==='paid'?"យោងតាម":""); ?>វិក័យប័ត្រ</td>
            <td class="text-left">: <?php echo e($master->reference_number??$master->invoice_number); ?></td>
        </tr>
        <tr>
            <td class="text-left">អតិថិជន</td>
            <td class="text-left">: <?php echo e($customer_name); ?></td>
        </tr>
        <tr>
            <td class="text-left">ទូរស័ព្ទ</td>
            <td class="text-left">: <?php echo e($customer_phone); ?></td>
        </tr>
        <tr>
            <td class="text-left">ទីតាំង</td>
            <td class="text-left"><p>:<?php echo e($customer_address); ?></p></td>
        </tr>
        <?php if($master->method): ?>
            <tr>
                <td class="text-left">ការបង់ប្រាក់</td>
                <td class="text-left">: <?php echo e(\App\Model\Accounting\AccountChartModel::find($master->method)->acc_name??''); ?></td>
            </tr>
        <?php endif; ?>
        <tr>
            <td class="text-left">ស្ថានភាពបង់ប្រាក់</td>
            <td class="text-left">: <?php echo e(__('administrator.'.$master->payment_status)); ?></td>
        </tr>
        </thead>
    </table>
    <hr>
    <table class="table-borderless" width="100%">
        <thead>
        <tr>
            <th class="text-left">ឈ្មោះ</th>
            <th class="text-left">បរិមាណ</th>
            <th class="text-left">តំលៃ</th>
            <th>តម្លៃសរុប</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $product_unit = \App\Model\ProductUnitModel::find($row->product_unit_id);
               $qty_text = $row->qty;
                $total = $row->total;
                $unit = findUnit($product_unit->unit_id)
            ?>
            <tr>
                <td><?php echo e($product_unit->product->product_name??''); ?> | <?php echo e($product_unit->item_code); ?></td>
                <td><?php echo e($row->type==='in'?'-':''); ?><?php echo e($qty_text); ?> <?php echo e($unit->unit??''); ?></td>
                <td><?php echo e($row->sale_price?($row->sale_price.' $'):''); ?></td>
                <td>$<?php echo e($total); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php
        ?>
        </tbody>
    </table>
    <hr>
    <?php
    $g_kh = currencyExchange() * $master->grand_total;
    ?>
    <table class="text-right inv-tfoot">
        <thead>
        <?php if($master->discount): ?>
            <tr style="color: darkgreen">
                <td>បញ្ចុះតម្លៃ / Discount:</td>
                <td> <?php echo e($master->discount); ?>% ($<?php echo e(number_format(($master->discount*$master->subtotal/100),2)); ?>)</td>
            </tr>
        <?php endif; ?>
        <tr style="color: #337ab7">
            <td>សរុបរួម / Grant Total:</td>
            <td>៛<?php echo e(number_format($g_kh,2)); ?></td>
        </tr>
        <tr style="color: #337ab7">
            <td>សរុបរួម / Grant Total:</td>
            <td>$<?php echo e(number_format($master->grand_total,2)); ?></td>
        </tr>
        <?php if($master->paid_amount_usd): ?>
            <tr style="color: darkgreen">
                <td>ប្រាក់បានបង់ / Paid:</td>
                <td> $<?php echo e(number_format($master->paid_amount_usd,2)); ?></td>
            </tr>
        <?php endif; ?>
        <?php if($master->remain>0): ?>
            <tr style="color: #a94442;">
                <td>លុយជំពាក់ / Remain Amount:</td>
                <td>$<?php echo e(number_format($master->remain,2)); ?></td>
            </tr>
        <?php endif; ?>
        </thead>
    </table>
    <table class="table-borderless" width="100%" style="margin-top: 70px;font-size: 12px">
        <thead>
        <tr>
            <td class="text-center">
                <label>
                    <?php if($branch->quote): ?>
                        <?php echo $branch->quote??''; ?>

                    <?php else: ?>
                        អរគុណសម្រាប់ការសហការដ៏ល្អ <br>
                        សូមបង់ប្រាក់អោយបានមុនរយៈពេល ៧ថ្ងៃ ក្រោយទទួលផលិតផល។
                    <?php endif; ?>
                </label>
            </td>
        </tr>
        <?php if($master->delete_reason): ?>
            <tr>
                <td class="text-center"><br><b class="text-red"
                                               style="font-size: 20px"><?php echo e($master->delete_reason); ?></b></td>
            </tr>
        <?php endif; ?>
        </thead>
    </table>

</div>
</body>
</html>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/invoice/maho-invoice.blade.php ENDPATH**/ ?>