
<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3><?php echo e(__('administrator.warehouses')); ?></h3>
                                </div>
                                <div class="pull-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Warehouse Create')): ?>
                                        <a class="btn bg-olive btn-flat margin"><span
                                                class="fa fa-plus"></span> <?php echo e(__('administrator.new_record')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-body" style="overflow-x:auto;">
                    <form class="form_data">
                        <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                            <thead>
                            <tr>
                                <th>N°</th>
                                <th><?php echo e(__('administrator.branch')); ?></th>
                                <th><?php echo e(__('administrator.warehouse_name')); ?></th>
                                <th><?php echo e(__('administrator.address')); ?></th>
                                <th><?php echo e(__('administrator.description')); ?></th>
                                <th><?php echo e(__('administrator.created_at')); ?></th>
                                <th width="15%"><?php echo e(__('administrator.action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        //  start datatable
        var record = 20;
        var page = 1;
        $(document).ready(function () {
            dataTable();
        });
        $(document).on('change', '.data_table_length', function () {
            record = $(this).val();
            page = 1;
            dataTable();
        });


        $(document).on('click', '.page-item', function () {
            page = $('.page-item.active .page-link').text();
            dataTable();
        });

        function dataTable() {
            $('#data_table').DataTable().destroy();
            $('#data_table').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.previous')); ?>"
                    },
                },
                serverSide: true,
                ordering: false,
                searching: false,
                pageLength: record,
                lengthMenu: tbLength,
                ajax: {
                    url: "<?php echo e(route('warehouse.index')); ?>?",
                    data: {
                        record,
                        page
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'branch'},
                        {data: 'name'},
                        {data: 'location_name'},
                        {data: 'description'},
                        {data: 'created_at'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                    $('select[name="data_table_length"]').val(json.records);
                    $('.dataTables_paginate').empty();
                    $('#data_table_paginate').twbsPagination('destroy');
                    $('#data_table_paginate').twbsPagination({
                        totalPages: json.totalPage,
                        visiblePages: 5,
                        startPage: parseInt(json.activePage),
                        next: 'Next',
                        prev: 'Prev',
                        onPageClick: function (event, pageD) {
                        }
                    });
                }
            });
        }

        // end

        //  set mainwarehouse
        $(document).on('click', 'tbody .btn-default', function () {
            var id = $(this).data('id');
            $.confirm({
                title: '<strong style="color:darkcyan;"><?php echo e(__('administrator.change_status')); ?></strong>',
                content: "<b><?php echo e(__('administrator.Change_Main_Warehouse')); ?> ? ",
                buttons: {
                    '<?php echo e(__('administrator.ok')); ?>': {
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                type: "GET",
                                dataType: "json",
                                url: '<?php echo e(route("warehouse_changeStatus")); ?>',
                                data: {'id': id},
                                success: function (data) {
                                    showSuccessToast('Warehouse updated successfully!');
                                    $('.jconfirm-buttons .btn-default').trigger('click');
                                    $('#data_table').DataTable().destroy();
                                    dataTable();
                                }
                            });
                            return false;
                        }
                    },
                    '<?php echo e(__('administrator.cancel')); ?>': function () {
                    },
                }
            });
        });
        // end

        $(document).on('click', '.btn.bg-olive.btn-flat', function () {
            getHtmlForm('<?php echo e(route('warehouse.create')); ?>', '<?php echo e(__('administrator.create')); ?> <?php echo e(__('administrator.warehouse')); ?>');
        });
        $(document).on('click', '.fa.fa-pencil.btn.btn-sm.btn-warning', function () {
            $href = $(this).data('url');
            getHtmlForm($href, '<?php echo e(__('administrator.edit')); ?> <?php echo e(__('administrator.warehouse')); ?>');
        });

        // delete category
        $(document).on('click', '.fa.fa-trash.btn.btn-sm.btn-danger', function () {
            var url = $(this).data('url');
            $.confirm({
                icon: 'flaticon-danger',
                title: '<?php echo e(__('administrator.confirm')); ?> ',
                content: '<?php echo e(__('administrator.are_you_sure')); ?> ',
                type: 'red',
                typeAnimated: true,
                closeIcon: true,
                closeIconClass: 'flaticon-close',
                buttons: {
            <?php echo e(__('administrator.submit')); ?>:
            {
                btnClass: 'btn-red',
                    action
            :

                function () {
                    $.ajax({
                        type: 'DELETE',
                        url: url,
                        data: {
                            '_token': '<?php echo e(csrf_token()); ?>'
                        },
                        dataType: 'json',
                        success: function (data) {
                            if (data[1] == 401) {
                                showWarningToast(data[0]);
                            } else {
                                showSuccessToast('Warehouse deleted successfully!');
                                $('.jconfirm-buttons .btn-default').trigger('click');
                                $('#data_table').DataTable().destroy();
                                dataTable();
                            }
                        }
                    });
                    return false;
                }
            }
        ,
            <?php echo e(__('administrator.cancel')); ?>:
            {
                action: function () {
                }
            }
        }
        })
            ;
        });
        // end
    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/warehouse/index.blade.php ENDPATH**/ ?>