<!doctype html>
<?php Fun::lang()?>
<html>
<head>
    <meta charset="utf-8">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/pos-invoice.css')); ?>">
    <?php
    $hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
    ?>
    <style>
        .print_this_form .table td {
            padding: 10px;
        }

        .print_this_form .table td:nth-child(2) {
            text-align: left;
        }
    </style>
</head>
<body>
<?php
$customer = findCustomer($master->customer_id);
$customer_info = \App\Model\CustomerInfoModel::where('model_id',$master->id)->first();

$illness_status = $customer_info->illness_status??$customer->illness_status;
$customer_phone = $customer_info->phone ?? $customer->customer_phone;
if($customer_info){
    $sex =  $customer_info->gender?__('administrator.' . $customer_info->gender):'';
}else{
    $sex =  $customer->sex?__('administrator.' . $customer->sex):'';
}
$customer_name = $customer_info->customer_name ?? $customer->customer_name;
$customer_address = $customer_info->address ?? $customer->customer_address;
$branch = findBranch($master->request_to);
$branch = $branch ? $branch->name : '';
$grand_total = 0;
$source = '';
$customer_type = '';
$contact_by = '';
if($customer_info){
    $illness = json_decode($customer_info->type_of_illness);
    if($customer_info->known_product_from){
        $source = leadSource($customer_info->known_product_from);
    }
    if($customer_info->customer_type){
        $customer_type = customerType($customer_info->customer_type??0);
    }
    $seller_email = $customer_info->user_email;
    if($customer_info->contact_by){
        $contact_by = leadSource($customer_info->contact_by);
    }
    $province = \App\Model\ProvinceModel::where('province_id',$customer_info->province)->first();
}else{
    $customer_type = customerType($master->customer_type??0);
    $illness = json_decode($customer->type_illness);
    if($customer->known_this_from){
        $source = leadSource($customer->known_this_from);
    }
    $seller = findUser($master->user_id);
    $seller_email = $seller ? $seller->email : '';
    if($customer->contact_by){
        $contact_by = leadSource($customer->contact_by);
    }
    $province = \App\Model\ProvinceModel::where('province_id',$customer->province)->first();
}
$province = if_kh()?($province->province_km??''):($province->province_en??'');

if ($illness) {
    $illness = \App\Models\TypeOfIllness::whereIn('id', $illness)->pluck(if_kh() ? 'name_km' : 'name_en');
    $illness = $illness->implode(', ');
    $illness = rtrim($illness, ',');
} else {
    $illness = '';
}
$acc  = \App\Model\Accounting\AccountChartModel::find($master->payment_type);
$payment_type = $acc->acc_name??'';

?>
<div class="print_this_form" style="font-size: 12px">
    <h3><?php echo e(__('administrator.customerinfo')); ?></h3>
    <table class="table table-bordered table-striped">
        <tr>
            <td width="50%">អ្នកសម្របសម្រួលការបញ្ជាទិញ</td>
            <td><?php echo e($seller_email); ?></td>
        </tr>
        <tr>
            <td width="50%">អ្នកបិទការលក់</td>
            <td><?php echo e($master->close_sale_by); ?></td>
        </tr>
        <tr>
            <td>ឈ្នោះអ្នកបញ្ជាទិញ</td>
            <td><?php echo e($customer_name); ?></td>
        </tr>
        <tr>
            <td>ភេទ (ប្រុស ឫ ស្រី)</td>
            <td><?php echo e($sex); ?></td>
        </tr>
        <tr>
            <td>អាយុ</td>
            <td><?php echo e($customer->age); ?></td>
        </tr>
        <tr>
            <td>បញ្ជាកថាអតិជន ចាស់ ឫ ថ្មី</td>
            <td><?php echo e($customer_type); ?></td>
        </tr>
        <tr>
            <td>ប្រភេទជម្ងឺ</td>
            <td><?php echo e($illness); ?></td>
        </tr>
        <tr>
            <td>ស្ថានភាពជម្ងឺ</td>
            <td><textarea rows="3" class="no-bg form-control no-border" readonly><?php echo e($illness_status); ?></textarea></td>
        </tr>
        <tr>
            <td>ខេត្តអ្នកបញ្ជាទិញ</td>
            <td><?php echo e($province); ?></td>
        </tr>
        <tr>
            <td>អាស័យដ្ឋាន</td>
            <td><textarea rows="3" class="no-bg form-control no-border" readonly><?php echo e($master->comment); ?></textarea></td>
        </tr>
        <tr>
            <td>អាស័យដ្ឋានអ្នកបញ្ជាទិញ</td>
            <td><?php echo e($customer_address); ?></td>
        </tr>
        <tr>
            <td>សាខាមួយណា</td>
            <td><?php echo e($branch); ?></td>
        </tr>
        <tr>
            <td>លេខទូរស័ព្ទអ្នបញ្ជាទិញ</td>
            <td><textarea rows="2" class="no-bg form-control no-border" readonly><?php echo e($customer_phone); ?></textarea></td>
        </tr>
        <?php $__currentLoopData = $detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $punit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = getProductById($punit->product_id);
                $product = $product?$product->product_name:'';
                $grand_total+=$row->total;
            ?>
            <tr>
                <td>បញ្ជាទិញ (<?php echo e($product); ?>) ចំនួន (សូមបញ្ជាក់ ប្រអប់ ឫ កញ្ចប់)</td>
                <td><?php echo e($row->qty); ?><?php echo e(findUnit($row->unit_id)->unit); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php
            $grand_total-=$master->using_point/2;
        ?>
        <tr>
            <td>ប្រភេទនៃការទូទាត់</td>
            <td><?php echo e($payment_type); ?></td>
        </tr>
        <tr>
            <td>សរុបតម្លៃ</td>
            <td><?php echo e(number_format($grand_total,2)); ?></td>
        </tr>

        <tr>
            <td>ផ្សេងៗ (អតិថិជន)</td>
            <td><textarea rows="3" class="no-bg form-control no-border" readonly><?php echo e($master->customer_note); ?></textarea></td>
        </tr>
        <tr>
            <td>មកជាវនៅហាង ឫផ្ញើរផលិតទៅ</td>
            <td>
                <?php if($master->delivery_type): ?>
                    <?php echo e(__('administrator.'.$master->delivery_type)); ?>

                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>ស្គាល់ផលិតផលតាមរយៈអ្វី?</td>
            <td><?php echo e($source); ?></td>
        </tr>
        <tr>
            <td>ទាក់ទងមកតាមរយៈ</td>
            <td><?php echo e($contact_by); ?></td>
        </tr>
    </table>
</div>
<br>
</body>
</html>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/invoice/maho-pos-request-customer-info.blade.php ENDPATH**/ ?>