<table id="data_table" class="table table-striped table-hover table-bordered">
    <thead>
    <tr>
        <th>N°</th>
        <th style="white-space: nowrap"><?php echo e(__('administrator.sale_date')); ?></th>

        <th><?php echo e(__('administrator.reference_number')); ?></th>
        <th><?php echo e(__('administrator.user')); ?></th>
        <th><?php echo e(__('administrator.customer')); ?></th>
        <th><?php echo e(__('administrator.customer_phone')); ?></th>
        <th><?php echo e(__('administrator.type_of_illness')); ?></th>
        <th><?php echo e(__('administrator.payment_methods')); ?></th>
        <th><?php echo e(__('administrator.total')); ?></th>
        <th><?php echo e(__('administrator.paid')); ?></th>
        <th><?php echo e(__('administrator.remain_amount')); ?></th>
        <th><?php echo e(__('administrator.payment_status')); ?></th>
        <th><?php echo e(__('administrator.total_qty')); ?></th>
    </tr>
    </thead>
    <tbody class="tbody">

    </tbody>
    <tfoot>
    <tr>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th class="text-right"><?php echo e(__('administrator.total')); ?></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
    </tr>
    </tfoot>
</table>

<script type="text/javascript">
    var table_ = $('#data_table');
    $(document).ready(function () {
        getTable();
        $('.hide_wholesale').show();
    });

    function getTable() {
        table_.DataTable().destroy();
        let url  = '<?php echo $url; ?>'+ '?' + $('.form_data').serialize();
        let column = [
            {data: 'DT_RowIndex'},
            {data: 'sale_date'},
            {data: 'reference_number'},
            {data: 'user_name'},
            {data: 'customer_name'},
            {data: 'customer_phone'},
            {data: 'type_of_illness'},
            {data: 'payment_method'},
            {data: 'payment_amount'},
            {data: 'paid_amount'},
            {data: 'remain'},
            {data: 'payment_status'},
            {data: 'total_qty'},
        ];

        table_.DataTable({
            searching: false,
            dom: 'lBfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    autoFilter: true,
                    className: 'btn btn-info pull-right',
                    filename: menu_name,
                    title: menu_name,
                    sheetName: menu_name,
                    footer:true,
                    header: true,
                    text: 'Save as Excel',
                },
            ],
            serverSide: true,
            ordering: false,
            lengthMenu: tbLength,
            ajax: {
                url: url,
                data: {
                    isAjax:1,
                }
            },
            columns: column,
            "initComplete": function (settings, json) {
                let total_row = $('#data_table .sum_data');
                let tfoot = $('#data_table tfoot tr:first-child');
                let total = 0;
                let paid = 0;
                let remain = 0;
                $.each(total_row,function (ii,vv) {
                    let sub_total = $(this).data('payment_amount');
                    let sub_paid = $(this).data('paid');
                    let sub_remain = $(this).data('remain');
                    let delete_at = $(this).data('delete_at');
                    console.log(sub_total);
                    sub_remain = sub_remain?parseFloat(sub_remain):0;
                    sub_total = sub_total?parseFloat(sub_total):0;
                    sub_paid = sub_paid?parseFloat(sub_paid):0;
                    delete_at = delete_at?parseFloat(delete_at):0;
                    if(!delete_at){
                        total+=sub_total;
                        paid+=sub_paid;
                        remain+=sub_remain;
                        console.log(sub_total);

                    }

                });
                total = total.toFixed(2);
                paid = paid.toFixed(2);
                remain = remain.toFixed(2);
                tfoot.find('th:nth-child(9)').text('$'+total);
                tfoot.find('th:nth-child(10)').text('$'+paid);
                tfoot.find('th:nth-child(11)').text('$'+remain);
            },
            "createdRow": function (row, data, dataIndex) {
                if (data.delete_at) {
                    $(row).addClass('text-danger');
                    $(row).addClass('bg-danger');
                }
            },
        });
    }
</script>



<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/report-sales/retail.blade.php ENDPATH**/ ?>