<?php Fun::lang()?>
        <!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/pos-invoice.css')); ?>">
</head>
<body>
<div class="print_invoice_wholesale">
    <table class="tb-header">
        <tr>
            <td><img src="<?php echo e(nsoLogo()); ?>" style="height: 60px;margin: 5px"></td>
        </tr>
        <tr>
            <td>
                <span>
                     <b><?php echo e(getBranch()->company_name); ?></b><br>
                    <i style="font-size: 11px"><?php echo e(getBranch()->address); ?><br><?php echo e(getBranch()->phone); ?></i>
                </span>
            </td>
        </tr>
    </table>
    <hr width="40%">
    <table>
        <tr>
            <td>
                <table>
                    <tr>
                        <td width="20%"><?php echo e(__('administrator.date')); ?></td>
                        <td>: <?php echo e(date('d-m-Y',strtotime($master->purchase_date))); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(__('administrator.invoice')); ?></td>
                        <td>: <?php echo e($master->invoice_number); ?></td>
                    </tr>
                    <tr>
                        <?php if($master->user_id): ?>
                            <td><?php echo e(__('administrator.request_by')); ?></td>
                            <td>: <?php echo e(findUser($master->user_id)->name); ?></td>
                        <?php endif; ?>
                    </tr>
                </table>
            </td>
            <td>
                <?php if($master->customer_id): ?>
                    <table class="table-right-side">
                        <tr>
                            <td><?php echo e(__('administrator.customer')); ?></td>
                            <td width="40%">: <?php echo e(findCustomer($master->customer_id)->customer_name); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('administrator.phone')); ?></td>
                            <td>: <?php echo e(findCustomer($master->customer_id)->customer_phone); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('administrator.email')); ?></td>
                            <td>: <?php echo e(findCustomer($master->customer_id)->customer_email); ?></td>
                        </tr>
                    </table>
                <?php endif; ?>
                <?php if($master->delivery_status): ?>
                    <table class="table-right-side">
                        <tr>
                            <td><?php echo e(__('administrator.delivery_number')); ?></td>
                            <td>: <?php echo e($master->delivery_phone); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('administrator.delivery_fee')); ?></td>
                            <td>: <?php echo e($master->delivery_fee); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('administrator.note')); ?></td>
                            <td>: <?php echo e($master->delivery_note); ?></td>
                        </tr>
                    </table>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <table class="table" style="margin-top: 30px">
        <thead>
        <tr>
            <th width="6%">#</th>
            <th col><?php echo e(__('administrator.code')); ?></th>
            <th col><?php echo e(__('administrator.products')); ?></th>
            <th col><?php echo e(__('administrator.qty')); ?></th>
            <th col><?php echo e(__('administrator.price')); ?></th>
            <th col><?php echo e(__('administrator.discount')); ?>(%)</th>
            <th width="10%"><?php echo e(__('administrator.total')); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php  $subtotal = 0; ?>
        <?php if($detail): ?>
            <?php $__currentLoopData = $detail; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $product = getProductById($row->product_id);
                $total = $row->sale_price * $row->qty;
                $total = $total - ($total * $row->dis / 100);

                if ($product->currency == '1') {
                    $currency = '៛';
                    $subtotal += $total / $master->rate;
                } else {
                    $currency = '$';
                    $subtotal += $total;
                }

                $unit = (findUnit($row->unit_id));
                if (\App\Fun\Fun::lang() == 'km') {
                    $unit = $unit->unit_name_km;
                } else {
                    $unit = $unit->unit_name_en;
                }
                ?>
                <tr role="row">
                    <td><?php echo e($key+1); ?></td>
                    <td><?php echo e($product->barcode); ?></td>
                    <td><?php echo e($product->product_name); ?></td>
                    <td><?php echo e($row->qty.' '.$unit); ?></td>
                    <td><?php echo e($currency.' '.number_format($row->sale_price, 2)); ?></td>
                    <td><?php echo e(number_format($row->dis)); ?>%</td>
                    <td><?php echo e($currency.' '.number_format($total, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        </tbody>
        <tfoot>
        <tr>
            <td colspan="6" class="text-right"><b><?php echo e(__('administrator.subtotal')); ?>($):</b></td>
            <td> <?php echo e(number_format($subtotal, 2)); ?></td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b><?php echo e(__('administrator.discount')); ?>:</b></td>
            <td><?php echo e(number_format($master->discount, 0)); ?>%</td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b><?php echo e(__('administrator.grand_total')); ?>(៛):</b></td>
            <td> <?php echo e(number_format(($subtotal-($subtotal*$master->discount/100))*$master->rate, 2)); ?></td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b><?php echo e(__('administrator.grand_total')); ?>($):</b></td>
            <td> <?php echo e(number_format(($subtotal-($subtotal*$master->discount/100)), 2)); ?></td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b><?php echo e(__('administrator.paid')); ?>(៛):</b></td>
            <td> <?php echo e(number_format($master->paid_amount_kh, 2)); ?></td>
        </tr>
        <tr>
            <td colspan="6" class="text-right"><b><?php echo e(__('administrator.paid')); ?>($):</b></td>
            <td><?php echo e(number_format($master->paid_amount_usd  , 2)); ?></td>
        </tr>
        </tfoot>
    </table>
    <hr width="40%">
    <table>
        <tr>
            <td style="text-align: center"><b><?php echo e(__('administrator.thank_your_for_shopping_with_us')); ?></b></td>
        </tr>
    </table>

</div>
</body>
</html>
<?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/pos/invoice/purchase-order-invoice.blade.php ENDPATH**/ ?>