
<?php $__env->startSection('content'); ?>
<?php Fun::lang()?>
<style>
    .padding-5 .fa-pencil-alt{
        position: relative;
        top: 38px;
        left: 27px;
        background: white;
        border-radius: 50%;
        font-size: 20px;
        cursor: pointer;
    }

    .previewImage{
        width: 100px;
        height: 98px;
        background-repeat: no-repeat;
        background-size: 100px 100px;
        background-color: #cccccc !important;
        border-radius: 50%;
        cursor: pointer;
    }

    .padding-5{
        padding: 5px !important;
    }

    .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content{
        overflow: hidden;
    }

    .ui-timepicker-container{
        z-index: 99999999 !important;
    }

    .fa-minus-circle, .fa-plus-circle{
        cursor: pointer !important;
    }

    thead>tr>th:first-child, tbody>tr>td:first-child, thead>tr>th:last-child, thead>tr>td:last-child{
        text-align: center !important;
    }
</style>
<div class="row">
    <div class="col-xs-12">
        <div class="box box-primary">
            <div class="box-header with-border">
              <h3 class="box-title">New Promotion!</h3>
            </div>
            <?php echo Form::open(array('route' => ['promotion.update', $promotion->id], 'method'=>'PATCH', 'enctype'=>'multipart/form-data', 'class'=>'form-horizontal')); ?>

                <div class="box-body">
                    <div class="col-xs-offset-1 col-xs-10">
                        <div class="row">
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"><?php echo e(__('administrator.image')); ?></label>
                                <div class="col-sm-9">
                                     <input type="file" class="image form-control" name="image">
                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"><?php echo e(__('administrator.branch')); ?>

                                <span class="text-danger">*</span></label>
                                <div class="col-sm-9">
                                    <?php echo Form::select('branch', getBranch(), $promotion->branch, ['class' => 'branch form-control select2', 'placeholder' => __('administrator.branch'), 'required']); ?>

                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"><?php echo e(__('administrator.Promotion_Code')); ?>

                                <span class="text-danger">*</span></label>
                                <div class="col-sm-9">
                                    <input name="code" type="text" class="form-control" placeholder="<?php echo e(__('administrator.Promotion_Code')); ?>" maxlength="25" autocomplete="off" required value="<?php echo e($promotion->code); ?>"/>
                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"><?php echo e(__('administrator.promotion_name')); ?>

                                <span class="text-danger">*</span></label>
                                <div class="col-sm-9">
                                    <input name="name" type="text" class="form-control" placeholder="<?php echo e(__('administrator.promotion_name')); ?>" maxlength="25" autocomplete="off" required value="<?php echo e($promotion->name); ?>"/>
                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"><?php echo e(__('administrator.promotion_start')); ?></label>
                                <div class="col-sm-9">
                                    <input name="start_date" type="text" class="form-control datepicker" placeholder="<?php echo e(__('administrator.promotion_start')); ?>" maxlength="25" autocomplete="off" value="<?php echo e(Carbon\Carbon::parse($promotion->start_date)->format('d-m-Y')); ?>"/>
                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"><?php echo e(__('administrator.promotion_end')); ?></label>
                                <div class="col-sm-9">
                                    <input name="end_date" type="text" class="form-control datepicker" placeholder="<?php echo e(__('administrator.promotion_end')); ?>" maxlength="25" autocomplete="off" value="<?php echo e(Carbon\Carbon::parse($promotion->end_date)->format('d-m-Y')); ?>"/>
                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"> <?php echo e(__('administrator.Promotion_Type')); ?>

                                <span class="text-danger">*</span></label>
                                <div class="col-sm-9">
                                    <?php echo Form::select('promotion_type', ['Product Promotion' =>  __('administrator.Promotion_Type') , 'Package Promotion' => 'Package Promotion'], $promotion->type, ['class' => 'product_type form-control select2', 'placeholder' => 'Promotion Type', 'required']); ?>

                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label"><?php echo e(__('administrator.note')); ?></label>
                                <div class="col-sm-9">
                                    <textarea class="form-control" rows="5" placeholder="<?php echo e(__('administrator.note')); ?>" name="note"><?php echo e($promotion->note); ?></textarea>
                                </div>
                            </div>
                            <div class="form-group col-xs-12" id="new_form">
                                <?php if($promotion->type == 'Package Promotion'): ?>
                                    <div class="form-group col-xs-6" style="padding-right: 0px;">
                                        <label class="col-sm-3 control-label"> <?php echo e(__('administrator.price')); ?>(ដុល្លា)</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="price_us" class="form-control numeric" placeholder=" <?php echo e(__('administrator.price')); ?>($)" maxlength="25" autocomplete="off" value="<?php echo e($promotion->us_price); ?>"/>
                                        </div>
                                    </div>
                                    <div class="form-group col-xs-6" style="padding-right: 0px;">
                                        <label class="col-sm-3 control-label"> <?php echo e(__('administrator.price')); ?>(រៀល)</label>
                                        <div class="col-sm-9"  style="padding-right: 0px;">
                                            <input type="text" name="price_kh" class="form-control numeric" placeholder=" <?php echo e(__('administrator.price')); ?>(៛)" maxlength="25" autocomplete="off" value="<?php echo e($promotion->riel_price); ?>"/>
                                        </div>
                                    </div>
                                    <div class="col-xs-offset-1 col-xs-11">
                                        <table class="table table-bordered">
                                            <thead style="background: #3c8dbc; color: white;">
                                                <tr>
                                                    <th width="5%">#</th>
                                                    <th>Product Buy</th>
                                                    <th width="35%">Qty</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody1">
                                                <?php $__currentLoopData = $promotion->promotion_detail()->where('type', 'paid'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td style="vertical-align: middle;">1</td>
                                                        <td>
                                                            <?php echo Form::select('product[]', productUnitName(), $item->product_id, ['class' => 'product form-control select2', 'placeholder' => 'Product']); ?>

                                                        </td>
                                                        <td>
                                                            <input class="form-control qty number-only" name="qty[]" autocomplete="off" placeholder="Qty" value="<?php echo e($item->qty); ?>"/>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="col-xs-offset-1 col-xs-11">
                                        <table class="table table-bordered">
                                            <thead style="background: #3c8dbc; color: white;">
                                                <tr>
                                                    <th width="5%">#</th>
                                                    <th<?php echo e(__('administrator.qty')); ?> >Product Free</th>
                                                    <th width="35%"><?php echo e(__('administrator.qty')); ?> </th>
                                                    <th width="5%"><i class="fa fa-plus-circle" id="productFree"></i></th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody">
                                                <?php $__currentLoopData = $promotion->promotion_detail()->where('type', '!=', 'paid'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td style="vertical-align: middle;">1</td>
                                                        <td>
                                                            <?php echo Form::select('product[]', productUnitName(), $item1->product_id, ['class' => 'product form-control select2', 'placeholder' => 'Product']); ?>

                                                        </td>
                                                        <td>
                                                            <input class="form-control qty number-only" name="qty[]" autocomplete="off" placeholder="Qty" value="<?php echo e($item1->qty); ?>"/>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="col-xs-offset-1 col-xs-11">
                                        <table class="table table-bordered">
                                            <thead style="background: #3c8dbc; color: white;">
                                                <tr>
                                                    <th width="5%">#</th>
                                                    <th>Product</th>
                                                    <th width="20%">Discount(%)</th>
                                                    <th width="5%"><i class="fa fa-plus-circle" id="addPromotion"></i></th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody">
                                                <?php $__currentLoopData = $promotion->promotion_detail(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td style="vertical-align: middle;">1</td>
                                                        <td>
                                                            <?php echo Form::select('product[]', productUnitName(), $item->product_id, ['class' => 'product form-control select2', 'placeholder' => 'Product', 'required']); ?>

                                                        </td>
                                                        <td>
                                                            <input class="form-control discount numeric" name="discount[]" autocomplete="off" placeholder="Discount" required value="<?php echo e($item->discount); ?>"/>
                                                        </td>
                                                        <td style="vertical-align: middle;"><i class="fa fa-minus-circle text-red"></i></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-footer text-right">
                    <button type="submit" class="btn btn-info btn-sm submit">Submit</button>
                    <a href="<?php echo e(route('purchases-item.index')); ?>" class="btn btn-danger btn-sm"> Cancel</a>
                </div>
            <?php echo Form::close(); ?>

          </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script type="text/javascript">

    $(document).ready(function(){
        $('.datepicker').datepicker({
            dateFormat: 'dd-mm-yy',
            autoclose: true
        });
    });

    $(document).on('click', '.padding-5 .fa-pencil-alt, .previewImage', function(){
        $('.image').trigger('click');
    });

    $(document).on('change', '.image', function(e){
        file = $('.image').get(0).files[0];
        reader = new FileReader();
        if(file){
            reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function(){
                $(".previewImage").css("background-image", "url(" + reader.result + ")");
            }
        }
    });

   $(document).on('change', "select[name='promotion_type']", function(){
        $('#new_form').empty();
        if($(this).val() == 'Product Promotion'){
            $('#new_form').append(`
                <div class="col-xs-offset-1 col-xs-11">
                    <table class="table table-bordered">
                        <thead style="background: #3c8dbc; color: white;">
                            <tr>
                                <th width="5%">#</th>
                                <th><?php echo e(__('administrator.product')); ?></th>
                                <th width="20%"><?php echo e(__('administrator.discount')); ?>(%)</th>
                                <th width="5%"><i class="fa fa-plus-circle" id="addPromotion"></i></th>
                            </tr>
                        </thead>
                        <tbody id="tbody">
                            <tr>
                                <td style="vertical-align: middle;">1</td>
                                <td>
                                    <?php echo Form::select('product[]', productUnitName(), null, ['class' => 'product form-control select2', 'placeholder' => __('administrator.product'), 'required']); ?>

                                </td>
                                <td>
                                    <input class="form-control discount numeric" name="discount[]" autocomplete="off" placeholder="<?php echo e(__('administrator.discount')); ?>" required/>
                                </td>
                                <td style="vertical-align: middle;"><i class="fa fa-minus-circle text-red"></i></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            `);
            $('.select2').select2();
        }else if($(this).val() == 'Package Promotion'){
            $('#new_form').append(`
                <div class="form-group col-xs-6" style="padding-right: 0px;">
                    <label class="col-sm-3 control-label">Price(ដុល្លា)</label>
                    <div class="col-sm-9">
                        <input type="text" name="price_us" class="form-control numeric" placeholder="Price($)" maxlength="25" autocomplete="off"/>
                    </div>
                </div>
                <div class="form-group col-xs-6" style="padding-right: 0px;">
                    <label class="col-sm-3 control-label">Price(រៀល)</label>
                    <div class="col-sm-9"  style="padding-right: 0px;">
                        <input type="text" name="price_kh" class="form-control numeric" placeholder="Price(៛)" maxlength="25" autocomplete="off"/>
                    </div>
                </div>
                <div class="col-xs-offset-1 col-xs-11">
                    <table class="table table-bordered">
                        <thead style="background: #3c8dbc; color: white;">
                            <tr>
                                <th width="5%">#</th>
                                <th><?php echo e(__('administrator.Product_Buy')); ?></th>
                                <th width="35%"><?php echo e(__('administrator.qty')); ?></th>
                            </tr>
                        </thead>
                        <tbody id="tbody1">
                            <tr>
                                <td style="vertical-align: middle;">1</td>
                                <td>
                                    <?php echo Form::select('product[]', productUnitName(), null, ['class' => 'product form-control select2', 'placeholder' => __('administrator.product')]); ?>

                                </td>
                                <td>
                                    <input class="form-control qty number-only" name="qty[]" autocomplete="off" placeholder="<?php echo e(__('administrator.qty')); ?>"/>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-xs-offset-1 col-xs-11">
                    <table class="table table-bordered">
                        <thead style="background: #3c8dbc; color: white;">
                            <tr>
                                <th width="5%">#</th>
                                <th><?php echo e(__('administrator.Product_free')); ?></th>
                                <th width="35%"><?php echo e(__('administrator.qty')); ?></th>
                                <th width="5%"><i class="fa fa-plus-circle" id="productFree"></i></th>
                            </tr>
                        </thead>
                        <tbody id="tbody">
                            <tr>
                                <td style="vertical-align: middle;">1</td>
                                <td>
                                    <?php echo Form::select('productfree[]', productUnitName(), null, ['class' => 'productfree form-control select2', 'placeholder' => __('administrator.product')]); ?>

                                </td>
                                <td colspan="2">
                                    <input class="form-control qtyfree number-only" name="qtyfree[]" autocomplete="off" placeholder="<?php echo e(__('administrator.qty')); ?>"/>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            `);
            $('.select2').select2();

        }
    });

    $(document).on('click', '#addPromotion', function(){
        tbody();
    });

    $(document).on('click', '.fa.fa-minus-circle.text-red', function(){
        if($('#tbody tr').length > 1){
            (this).closest('tr').remove();
            loopTr();
        }
    });

    function tbody(){
        $('#tbody').append(`<tr>
                                <td style="vertical-align: middle;">1</td>
                                <td>
                                    <?php echo Form::select('product[]', productUnitName(), null, ['class' => 'product form-control select2', 'placeholder' => __('administrator.product'), 'required']); ?>

                                </td>
                                <td>
                                    <input class="form-control discount numeric" name="discount[]" autocomplete="off" placeholder="<?php echo e(__('administrator.discount')); ?>" required/>
                                </td>
                                <td style="vertical-align: middle;"><i class="fa fa-minus-circle text-red"></i></td>
                            </tr>`);
        $('.select2').select2();
        loopTr();
    }

    function loopTr(){
        var i = 0;
        $('#tbody tr td:first-child').each(function(){
            i += 1;
            $(this).text(i);
        })
    }

    $(document).on('click', '#productFree', function(){
        // alert();
        $('#tbody').append(`<tr>
                                <td style="vertical-align: middle;">1</td>
                                <td>
                                    <?php echo Form::select('productfree[]', productUnitName(), null, ['class' => 'productfree form-control select2', 'placeholder' =>  __('administrator.product')]); ?>

                                </td>
                                <td>
                                    <input class="form-control qtyfree numeric" name="qtyfree[]" autocomplete="off" placeholder="<?php echo e(__('administrator.qty')); ?>"/>
                                </td>
                                <td style="vertical-align: middle;"><i class="fa fa-minus-circle text-red"></i></td>
                            </tr>`);
        $('.select2').select2();
        loopTr();
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(branchMenu(), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/vitadermo/resources/views/administrator/promotion/edit.blade.php ENDPATH**/ ?>