<?php
Route::group(['middleware' => 'pos', ['auth'], 'namespace' => 'Administrator'], function () {
    Route::resource('point_setting', 'PointSettingController');
    Route::resource('seller-request-product', 'SellerRequestProductController');
    Route::get('get-request-order-list', 'SellerRequestProductController@getTable')->name('get-request-order-list');
    Route::get('request-order-list', 'SellerRequestProductController@order_list')->name('request-order-list.index');
    Route::get('seller-request-product-add-product/{id?}', 'SellerRequestProductController@addProduct');
    Route::get('seller-request-product-add-product/{id?}', 'SellerRequestProductController@addProduct');
    Route::get('seller-request-product-get-product', 'SellerRequestProductController@getProduct');
    Route::get('seller-request-product-delete-product/{id?}', 'SellerRequestProductController@deleteProduct');
    Route::get('seller-request-product-update-product/{id?}', 'SellerRequestProductController@updateProduct');
    Route::match(['get','post'],'seller-request-product-update-type/{id}', 'SellerRequestProductController@updateType')->name('seller-request-product-update-type');

    Route::get('select2-search-customer', 'CustomerController@search_customer')->name('select2-search-customer');

});
//=========================================Payment=====================================================
Route::group(['middleware' => 'pos', ['auth'], 'namespace' => 'Administrator\payment'], function () {

    Route::resource('payment', 'PaymentController');
    Route::get('get-payments', 'PaymentController@getpayment')->name('get-payments');
    Route::get('get-payment/{id}', 'PaymentController@get_payment')->name('get-payment');
    Route::post('add-payment', 'PaymentController@add_payment')->name('add-payment');

    Route::resource('payment-sale-request', 'SaleRequestPaymentController');
    Route::get('get-payment-sale-request/{id}', 'SaleRequestPaymentController@get_payment')->name('get-payment-sale-request');
    Route::get('get-payments-sale-request-table', 'SaleRequestPaymentController@index')->name('get-payments-sale-request-table');
    Route::post('add-payment-sale-request', 'SaleRequestPaymentController@add_payment')->name('add-payment-sale-request');

    Route::resource('payment-purchase-order', 'PurchaseOrderPaymentController');
    Route::get('get-payment-purchase-order/{id}', 'PurchaseOrderPaymentController@get_payment')->name('get-payment-purchase-order');
    Route::get('get-payments-purchase-order-table', 'PurchaseOrderPaymentController@getpayment')->name('get-payments-purchase-order-table');
    Route::post('add-payment-purchase-order', 'PurchaseOrderPaymentController@add_payment')->name('add-payment-purchase-order');


});
Route::group(['middleware' => 'pos', ['auth'], 'namespace' => 'Branch'], function () {

    //-------------------------------------------POS Wholesale-------------------------------------------------
    Route::resource('wholesale', 'POSWholesaleController');
    Route::get('delete-whole-sale/{id}', 'POSWholesaleController@destroy')->name('delete-whole-sale');
    Route::get('wholesale-datatables', 'POSWholesaleController@datatables')->name('wholesale.datatables');
    Route::get('wholesale-reciept','POSWholesaleController@reciept')->name('wholesale.reciept');
    Route::get('wholesale-history','POSWholesaleController@history')->name('wholesale.history');


//-------------------------------------------Sale Return-------------------------------------------------
    Route::resource('sale-return-to-stock', 'SaleReturnController');
    Route::GET('get-sale-return-stock-invoice/{id}', 'SaleReturnController@get_salereturninvoice')->name('get-sale-return-stock-invoice');
});

Route::group(['middleware' => 'pos', ['auth'], 'namespace' => 'pos'], function () {

    //-------------------------------------------RETAIL-------------------------------------------------

    Route::match(['GET', 'POST'],'pos-retail-create/{id?}', 'PosRetailController@create')->name('pos-retail-create');
    Route::resource('pos-retail', 'PosRetailController');
    Route::get('delete-sale/{id}', 'PosRetailController@destroy')->name('delete-sale');

    //-------------------------------------------Wholesale-------------------------------------------------

    Route::resource('seller-request', 'SaleController');
    Route::GET('seller-request-scan-code', 'SaleController@seller_request_scad_code')->name('seller-request-scan-code');
    Route::GET('invoice-seller-request/{id}', 'SaleController@invoice')->name('invoice-seller-request');
    Route::DELETE('destroy-pos-sale-detail/{detail_id}', 'SaleController@destroy_puchase_detail')->name('destroy-pos-sale-detail');
    Route::POST('/pos-sale-update-all', 'SaleController@update_sale_all')->name('update-all-pos-sale.cart-session');
    //-------------------------------------------Receipt-------------------------------------------------

    Route::get('pos-invoice/{id}', 'PosInvoiceController@posinvoice')->name('pos-invoice');
    Route::get('get-maho-invoice/{id}', 'PosInvoiceController@maho_invoice')->name('get-maho-invoice');
    Route::get('get-maho-request-invoice/{id}', 'PosInvoiceController@maho_request_invoice')->name('get-maho-request-invoice');
    Route::get('get-invoice/{id}', 'PosInvoiceController@get_posInvoice')->name('get-pos-invoice');
    Route::get('get-purchase-invoice/{id}', 'PosInvoiceController@get_purchase_order')->name('get-purchase-invoice'); // Purchase Order
    Route::get('get-wholesale-invoice/{id}', 'PosInvoiceController@get_wholesaleinvoice')->name('get-wholesale-invoice');
    Route::get('find-sale-type/{id}', 'PosInvoiceController@find_sale_type')->name('find-sale-type');


    //-------------------------------------------purchase order-------------------------------------------------

    Route::resource('purchase-order', 'PurchaseOrderController');
    Route::get('pagination/purchase-order/fetch_data', 'PurchaseOrderController@fetch_data');
    Route::post('purchase-order-update-total-discount-product', 'PurchaseOrderController@updateProductDiscount');
    Route::get('draft-select-purchase-order-product/{id}', 'PurchaseOrderController@selectDraftProduct');
    Route::get('purchase-order-add-product/{id}', 'PurchaseOrderController@addProduct');
    Route::get('purchase-order-remove-all-product', 'PurchaseOrderController@removeAllProduct');
    Route::post('purchase-order-update-product/{id}', 'PurchaseOrderController@updateProduct');
    Route::get('purchase-order-unit-price/{val}/{id}', 'PurchaseOrderController@getUnitPrice');
    Route::get('purchase-order-remove-product/{id}', 'PurchaseOrderController@removeProduct');
    Route::post('purchase-order-draft-product', 'PurchaseOrderController@draftProduct');
    Route::get('purchase-order-get-product', 'PurchaseOrderController@getProduct');

    Route::get('update-status-purchase-order/{status}', 'PurchaseOrderController@update_status');
    Route::get('update-seen-purchase-order', 'PurchaseOrderController@update_seen')->name('update-seen-purchase-order');



});

//-------------------------------------------All Sale List-------------------------------------------------

Route::group(['middleware' => 'pos', ['auth'], 'namespace' => 'pos'], function () {
    Route::resource('cash-in-cash-out', 'CashInOutController');
    Route::resource('product-return', 'ProductReturnController');
    Route::get('product-return-delete/{id}', 'ProductReturnController@destroy')->name('product-return-delete');
    Route::get('get-stock-and-price-by-shelf-id', 'ProductReturnController@get_stock_qty')->name('get-stock-and-price-by-shelf-id');
});
