@extends(branchMenu())
@section('content')

<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.receipt')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <form class="form_data">
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.reference_invoice')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('reference_invoice',null, ['placeholder'=>__('administrator.reference_invoice'),'class' => 'form-control ']) !!}
                                </div>
                            </div>

                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.sale_by')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('user_id',getUsers(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.payment_methods')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('payment_type',getPaymentType(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.from_date')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']) !!}
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.to_date')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']) !!}
                                </div>
                            </div>

                            <div class="col-sm-12 col-md-12 form-group text-right">
                                <button class="btn btn-md btn-warning btn-clear"
                                        type="button">{{ __('administrator.clear') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th>{{__('administrator.date')}}</th>
                        <th>{{__('administrator.receipt_invoice')}}</th>
                        <th>{{__('administrator.sale_by')}}</th>
                        <th>{{__('administrator.member')}}</th>
                        <th>{{__('administrator.grand_total')}}</th>
                        <th>{{__('administrator.paid')}}</th>
                        <th>{{__('administrator.remain_amount')}}</th>
                        <th>{{__('administrator.payment_method')}}</th>
                        <th>{{__('administrator.payment_status')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    let table = $('#data_table');
    $(document).ready(function() {
        dataTable();
        $('.form_data').on('change','input,select',function () {
            page = 1;
            dataTable();
        });
        $('.btn-clear').on('click',function () {
            $('.form_data').find('select,input').val('').change();
            page = 1;
            dataTable();
        });
    });

$('.form_data').on('change', '.form-control.input-sm', function() {
        record = $(this).val();
        page = 1;
        dataTable();
    });

    $(document).on('click', '.page-item', function() {
        page = $('.page-item.active .page-link').text();
        dataTable();
    });

    function dataTable() {
        table.DataTable().destroy();
        table.DataTable({
            serverSide: true,
            ordering: false,
            searching: false,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('wholesale.datatables') }}?"+$('.form_data').serialize(),
                data: {
                    type: 'paid',
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'sale_date'},
                    {data: 'reference_number'},
                    {data: 'seller'},
                    {data: 'member'},
                    {data: 'grand_total'},
                    {data: 'paid_amount_usd'},
                    {data: 'remain'},
                    {data: 'payment_method'},
                    {data: 'payment_status'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {
                // $('select[name="data_table_length"]').val(json.records);
               // $('.dataTables_paginate').empty();
                // $('#data_table_paginate').twbsPagination('destroy');
                // $('#data_table_paginate').twbsPagination({
                //     totalPages: json.totalPage,
                //     visiblePages: 5,
                //     startPage: parseInt(json.activePage),
                //     next: 'Next',
                //     prev: 'Prev',
                //     onPageClick: function (event, pageD) {
                //     }
                // });
            }
        });
    }
// end

    $(document).on('click', '.showDetail', function(){
      getHtmlFormShow($(this).data('href'),'700px');
    });
</script>
@endsection
