<?php Fun::lang();
$if_req = request('poreq');
$if_req = $if_req ? decrypt($if_req) : $if_req;
$master = @$master;
$if_admin = !ifMember();
?>
<style>
    .form-group > label, .form-group > div:first-child {
        padding-top: 8px;
        text-align: right;
    }
</style>
<div class="row">
    <div class="col-xs-12">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">{{__('administrator.wholesale')}}</h3>
            </div>
            <div class="box-body">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="row">
                        <div class="col-xs-12 col-sm-4 col-md-4">
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                {!! Form::text('search', null, array('placeholder' => __('administrator.search') ,'class' => 'form-control')) !!}
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-12"><br></div>
                            <div class="col-xs-12 col-sm-12 col-md-12 image-list"
                                 style="height: 70vh;overflow-y: scroll;">
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-8 col-md-8" style="background: #8080801a;">
                            <div class="check-bill">
                                <div class="row" style="height:400px; overflow-x:auto;">
                                    <div class="check-bill-table">
                                        <div class="product-view-table">
                                            <div class="parent-box-pos">
                                                <table class="table table-hover item-list-tb">
                                                    <thead class="text-center"
                                                           style="background: #3c8dbc; color: white;">
                                                    <tr style="height: 47px;">
                                                        <th>#</th>
                                                        <th>{{__('administrator.item_name')}}</th>
                                                        <th class="required">{{__('administrator.item_code')}}</th>
                                                        @if($if_admin)
                                                            <th class="required">{{__('administrator.shelf')}}</th>
                                                        @endif
                                                        <th class="required">{{__('administrator.qty')}}</th>
                                                        <th class="required">{{__('administrator.price')}}</th>
                                                        <th>{{__('administrator.total')}}</th>
                                                        @if($if_admin)
                                                            <th>{{__('administrator.deliver_qty')}}</th>
                                                            <th>{{__('administrator.store_qty')}}</th>
                                                        @endif
                                                        <th class="text-center">
                                                            <button type="button" class="btn btn-danger btn-sm pos_clothes_remove_session fa fa-trash"></button>
                                                        </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody id="append_product">
                                                    @if($master)
                                                        @foreach($master->detail as $key=>$item)
                                                            <?php
                                                            $product_unit = \App\Model\ProductUnitModel::find($item->product_unit_id);
                                                            $item_code = \App\Model\ProductUnitModel::where('product_id', $product_unit->product_id)
                                                                ->pluck('item_code', 'id');
                                                            if ($if_admin) {
                                                                $shelf = \App\Model\StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                                                                    ->join('nso007_shelf', 'nso007_shelf.id', 'nso007_stocks.shelf')
                                                                    ->join('nso007_unit', 'nso007_unit.id', 'nso007_product_unit.unit_id')
                                                                    ->selectRaw('CONCAT(nso007_shelf.name," | ",nso007_stocks.stock_qty,nso007_unit.unit) as text,nso007_shelf.id,nso007_stocks.stock_qty')
                                                                    ->where(['nso007_stocks.product_unit_id' => $item->product_unit_id])
                                                                    ->where(function ($q) {
                                                                        $q->where('nso007_stocks.branch_id', FindBranchID());
                                                                        $q->where('nso007_stocks.type', 'admin');
                                                                    })
                                                                    ->groupBy('shelf')
                                                                    ->get();
                                                                $shelf_html = '<option value="">' . __('administrator.please_select') . '</option>';
                                                                foreach ($shelf as $val) {
                                                                    $shelf_html .= '<option value="' . $val->id . '" data-stock="' . $val->stock_qty . '" ' . ($product_unit->product->shelf == $val->id ? 'selected' : '') . ' >' . $val->text . '</option>';
                                                                }
                                                                $stock_member=0;
                                                            }else{
                                                                $stock_member = \App\Model\StockModel::where(['type'=> 'member','member_id'=>Auth::id()])->first();
                                                                $stock_member = $stock_member->stock_qty??0;
                                                            }
                                                            ?>
                                                            <tr>
                                                                <td style="vertical-align: middle;">
                                                                    <input type="hidden" name="id[]" value="{{$item->id}}">
                                                                    {{$key+1}}
                                                                </td>
                                                                <td style="vertical-align: middle;">{{$product_unit->product->product_name}}</td>
                                                                <td>{!! Form::select('product_unit_id[]',$item_code,$item->product_unit_id,['placeholder'=>__('administrator.please_select'),'class'=>'form-control select2 product_unit_id']); !!}</td>
                                                                @if($if_admin)
                                                                    <td>
                                                                        <select name="shelf[]" class="form-control select2 shelf">{!! $shelf_html !!}</select>
                                                                    </td>
                                                                @endif
                                                                <td><input name="qty[]" type="text" class="form-control numeric qty" value="{{$item->qty}}" autocomplete="off" data-stock="{{$stock_member}}"></td>
                                                                <td><input name="price[]" type="text" class="form-control numeric price" value="{{$item->sale_price}}"></td>
                                                                <td>
                                                                    <div class="input-group">
                                                                        {!! Form::text('total_price[]',0, ['placeholder'=>__('administrator.total'),'class' => 'form-control total_price','readonly']) !!}
                                                                        <span class="input-group-addon">$</span>
                                                                    </div>
                                                                </td>
                                                                @if($if_admin)
                                                                    <td><input name="deliver_qty[]" type="number" class="form-control numeric" value="{{$item->deliver_qty}}" max="{{$item->qty}}"></td>
                                                                    <td><input name="store_qty[]" type="text" class="form-control" value="{{$item->store_qty}}" readonly></td>
                                                                @endif
                                                                <td><i class="btn btn-default fa fa-times text-red"></i></td>
                                                            </tr>
                                                        @endforeach
                                                    @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr style="border-top: 1px solid #337ab73d;">
                                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label class="required">{{__('administrator.member')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            {!! Form::hidden('purchase_id', $if_req)  !!}
                                            <div class="input-group">
                                                <?php
                                                $member = findUser($master->member_id ?? 0);
                                                $member = $member ? [$member->id => $member->name] : [];
                                                ?>
                                                {!! Form::select('member_id',$member,null, ['class' => ' form-control search_member', 'placeholder' => __("administrator.please_select")])  !!}
                                                <span class=" input-group-addon getHtmlForm cursor"
                                                      data-href="{{route('users.create')}}?input_name=member_id&type=member&input_name_one=member_type_id"
                                                      data-full_name="បង្កើតសមាជិក"><i class="fa fa-plus text-success"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label class="required">{{__('administrator.member_type')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            {!! Form::select('member_type_id',getMemberTypes(),null, ['class' => ' form-control', 'placeholder' => __("administrator.please_select")])  !!}
                                            {!! Form::hidden('discount',0)  !!}
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label class="required">{{__('administrator.date')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            <input type="text"
                                                   value="{{$master?myDate($master->sale_date??$master->purchase_date):date('d-m-Y')}}"
                                                   class="date_picker form-control " name="date">
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label>{{__('administrator.note')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            <textarea name="note" class="form-control " rows="4"
                                                      placeholder="Note">{{$master->description??''}}</textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label class="required">{{__('administrator.payment_type')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            {!!  Form::select('payment_type', getPaymentType(null,'account_receivable'), $purchase->payment_type??null, ['class' => ' payment_method form-control select2', 'placeholder' => __('administrator.please_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label class="required">{{__('administrator.payment_method')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            {!!  Form::select('payment_method', $acc_chart, $purchase->payment_method??null, ['class' => ' payment_method form-control select2', 'placeholder' => __('administrator.please_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label>{{__('administrator.bank_name')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            {!!  Form::select('sub_payment_method', [], null, ['class' => 'payment_type form-control select2 ', 'placeholder' => __('administrator.please_select')]) !!}
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label>{{__('administrator.subtotal')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            <div class="input-group">
                                                {!! Form::text('subtotal', 0, ['class' => 'form-control ', 'readonly']) !!}
                                                <span class="input-group-addon">$</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label>{{__('administrator.grand_total')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            <div class="input-group">
                                                {!! Form::text('grand_total', 0, ['class' => 'form-control ', 'readonly']) !!}
                                                <span class="input-group-addon">$</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label>{{__('administrator.paid_amount')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            <div class="input-group">
                                                {!! Form::text('paid_usd', 0, ['class' => 'form-control ']) !!}
                                                <span class="input-group-addon">$</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 form-group">
                                        <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">
                                            <label class="owe_label">{{__('administrator.owed_amount')}}</label>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
                                            <div class="input-group">
                                                {!! Form::text('owed_amount', 0, ['class' => 'form-control ', 'readonly']) !!}
                                                <span class="input-group-addon">$</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-right">
                                    @include('component.form-btn')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@section('script')
    <script type="text/javascript">
        exchange = '{!! currencyExchange() !!}';
        let tb = $('#append_product');
        let count_ = 1;
        $(document).ready(function () {
            getStock();
            @if($master->member_id??0)
            setTimeout(function () {
                $('select[name=member_id]').val('{{$master->member_id}}').change();
            }, 200);
            @endif
            $('body').addClass('sidebar-collapse');
            $('.image-list').on('click', '.product_unit', function () {
                let this_ = $(this);
                let select_product = this_.data('product_id');
                $.get('{{route('wholesale.create')}}', {select_product}, function (res) {
                    add_row(res);
                    count_++;
                });
            });
            tb.on('change', '.product_unit_id', function () {
                let t = $(this);
                let product_unit_id = t.val();
                $.get('{{route('wholesale.create')}}', {product_unit_id}, function (res) {
                    let shelf = res.shelf;
                    let shelf_html = '<option value="">{{__('administrator.please_select')}}</option>';
                    $.each(shelf, function (i, v) {
                        shelf_html += `<option value="${v.id}" data-stock="${v.stock_qty}">${v.name}</option>`;
                    });
                    let row = t.closest('tr');
                    row.find('.shelf').html(shelf_html).val(res.default_shelf).change();
                    row.find('.price').val(res.price);
                    grandTotal();
                });
            });
            $(document).on('click', 'a.page-link', function (e) {
                e.preventDefault();
                let url = $(this).attr('href');
                $.get(url, function (data) {
                    $('.image-list').html(data.html);
                });
            });
            $(document).on('click', '.fa.fa-times.text-red', function () {
                $(this).closest('tr').remove();
            });
            $(document).on('click', '.pos_clothes_remove_session', function () {
                if ($('#append_product tr').length > 0) {
                    $.confirm({
                        title: '{{__('administrator.confirm')}}',
                        content: '{{__('administrator.are_you_sure')}}?',
                        buttons: {
                            '{{__('administrator.confirm')}}':
                                {
                                    btnClass: 'btn-red',
                                    action:
                                        function () {
                                            tb.html("");
                                        }
                                }
                            ,
                            '{{__('administrator.cancel')}}': function () {
                            }
                        }
                    })
                    ;
                }
            });
            $(document).on('keyup', 'input[name="search"]', function () {
                getStock($(this).val());
            });

            $('select[name=member_id],select[name=member_type_id]').on('change', function () {
                let member = $('select[name=member_id]').val();
                let member_type = $('select[name=member_type_id]').val();
                if ($(this).attr('name') === 'member_id') {
                    member_type = '';
                }
                $.get('{{route('wholesale.create')}}', {member, member_type, getDis: 1}, function (res) {
                    if (res.member_type_id) {
                        $('select[name=member_type_id]').val(res.member_type_id).change();
                    }
                    if (res.discount) {
                        $('input[name=discount]').val(res.discount);
                    }
                    grandTotal();
                });
            });
            $('input[name=paid_usd]').on('keyup', function () {
                changeAmount();
            });
            tb.on('keyup', '.qty,.price,.shelf', function () {
                grandTotal();
            });
            tb.on('keyup', '.qty', function () {
                let row = $(this).closest('tr');
                let stock = row.find('.shelf option:selected').data('stock');
                let stock1 = $(this).data('stock');
                let stock2 = row.find('.product_unit_id option:selected').data('stock');
                let qty = $(this).val();
                stock = stock ? parseFloat(stock) : 0;
                stock1 = stock1 ? parseFloat(stock1) : 0;
                stock2 = stock2 ? parseFloat(stock2) : 0;
                stock = stock?stock:(stock1?stock1:stock2);
                qty = qty ? parseFloat(qty) : 0;
                if (qty > stock) {
                    showWarningToast('មិនមានស្តុកគ្រប់គ្រាន់ !!!');
                    qty = stock;
                    $(this).val(qty);
                }
                row.find('input[name="deliver_qty[]"]').attr('max', qty);
                row.find('input[name="store_qty[]"]').val(qty);
            });
            tb.on('keyup', 'input[name="deliver_qty[]"]', function () {
                let qty = $(this).attr('max');
                qty = qty ? qty : 0;
                let this_qty = $(this).val();
                this_qty = this_qty ? this_qty : 0;
                let total = qty - this_qty;
                $(this).closest('tr').find('input[name="store_qty[]"]').val(total > 0 ? total : 0);
            });
        });

        function grandTotal() {
            let sub_total = 0;
            let discount = $('input[name=discount]').val();
            discount = discount ? parseFloat(discount) : 0;
            $.each(tb.find('tr'), function (i, v) {
                let t_row = $(this);
                let qty = t_row.find('.qty').val();
                let price = t_row.find('.price').val();
                price = price ? parseFloat(price) : 0;
                qty = qty ? parseFloat(qty) : 0;
                let total = qty * price;
                sub_total += total;
                t_row.find('.total_price').val(total);
            });
            let grand_total = sub_total - (sub_total * discount / 100);
            $('input[name=subtotal]').val(sub_total);
            $('input[name=grand_total]').val(grand_total);
            changeAmount();
        }

        function changeAmount() {
            let grand_total = $('input[name=grand_total]').val();
            let paid_usd = $('input[name=paid_usd]').val();
            grand_total = grand_total ? parseFloat(grand_total) : 0;
            paid_usd = paid_usd ? parseFloat(paid_usd) : 0;
            let owe = grand_total - paid_usd;
            if (owe < 0) {
                $('.owe_label').text('{{__('administrator.change_amount')}}');
            } else {
                $('.owe_label').text('{{__('administrator.owed_amount')}}');
            }
            $('input[name=owed_amount]').val(Math.abs(owe));
        }

        function getStock(search = '') {
            $.get('{{route('wholesale.create')}}', {search}, function (data) {
                $('.image-list').html(data.html);
            });
        }

        function add_row(data) {
            let item_code = data.item_code;
            let item_code_html = '';
            $.each(item_code, function (i, v) {
                item_code_html += `<option value="${v.product_unit_id}" data-stock="${v.stock_qty}">${v.text}</option>`;
            });
            let select_code = `<select name="product_unit_id[]" class="form-control select2 product_unit_id"><option value="">{{__('administrator.please_select')}}</option>${item_code_html}</select>`;
            let $row = `
            <tr>
                <td style="vertical-align: middle;">
                    <input type="hidden" name="id[]" value="0">
                    ${count_}
            </td>
            <td style="vertical-align: middle;">${data.product_name}</td>
            <td>${select_code}</td>
            @if($if_admin)
            <td>
            {!! Form::select('shelf[]',[], null, array('placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 shelf')) !!}
            </td>
            @endif
            <td><input name="qty[]" type="number" class="form-control numeric qty" value="1" autocomplete="off"></td>
            <td><input name="price[]" type="text" class="form-control numeric price" value="0"></td>
            <td><div class="input-group">
                {!! Form::text('total_price[]',0, ['placeholder'=>__('administrator.total'),'class' => 'form-control total_price','readonly']) !!}
            <span class="input-group-addon">$</span>
            </div>
            </td>
            @if($if_admin)
            <td><input name="deliver_qty[]" type="number" class="form-control numeric" value="0"></td>
            <td><input name="store_qty[]" type="text" class="form-control" value="1" readonly></td>
            @endif
            <td><i class="btn btn-default fa fa-times text-red"></i></td>
            </tr>`;
            tb.append($row).find('tr:last .select2').select2();
        }
    </script>
    @include('js-function.payment-method')
@endsection
