@extends(branchMenu())
@section('content')
<?php Fun::lang()?>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.invoice')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <form class="form_data">
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.reference_invoice')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('reference_invoice',null, ['placeholder'=>__('administrator.reference_invoice'),'class' => 'form-control ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.payment_methods')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('payment_type',getPaymentType(null,'account_receivable'),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.from_date')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('from_date',null, ['placeholder'=>__('administrator.from_date'),'class' => 'form-control date_picker']) !!}
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.to_date')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::text('to_date',null, ['placeholder'=>__('administrator.to_date'),'class' => 'form-control date_picker']) !!}
                                </div>
                            </div>
                            <div class="col-sm-4 col-md-4 ">
                                <div class="col-sm-4 col-md-4">
                                    {{__('administrator.payment_status')}} :
                                </div>
                                <div class="form-group col-sm-8 col-md-8">
                                    {!! Form::select('payment_status',getPaymentStatus(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2 ']) !!}
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-12 form-group text-right">
                                <button class="btn btn-md btn-warning btn-clear"
                                        type="button">{{ __('administrator.clear') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th>{{__('administrator.date')}}</th>
                        <th>{{__('administrator.reference_invoice')}}</th>
                        <th>{{__('administrator.sale_by')}}</th>
                        <th>{{__('administrator.customer')}}</th>
                        <th>{{__('administrator.grand_total')}}</th>
                        <th>{{__('administrator.paid')}}</th>
                        <th>{{__('administrator.remain_amount')}}</th>
                        <th>{{__('administrator.payment_type')}}</th>
                        <th>{{__('administrator.payment_status')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    let thistable = $('#data_table');
    $(document).ready(function() {
        getTable();
        $('.form_data').on('change','input,select',function () {
            getTable();
        });
        $('.btn-clear').on('click',function () {
            $('.form_data').find('select,input').val('').change();
            getTable();
        });
        $(document).on('click', '.btn_delete', function () {
            let inv = $(this).closest('tr').find('td:nth-child(4)').text();
            let customer = $(this).closest('tr').find('td:nth-child(8)').text();
            let phone = $(this).closest('tr').find('td:nth-child(10)').text();
            let form = `<b>{{__('administrator.invoice_number')}}</b> : ${inv}<br><b>{{__('administrator.customer')}}</b> : ${customer}<br><b>{{__('administrator.phone')}}</b> : ${phone}<br><br>
                        <b class="required">{{__('administrator.reason')}}</b> <form class="form_data"><textarea class="form-control" name="reason" rows=4></textarea></form>`;
            confirmForm($(this).data('href'), '{{__('administrator.are_you_sure')}}', form , 'danger', '500px', 'fa fa-trash', 'red');
        });
    });
    function getTable() {
        let data = $('.form_data').serialize();
        thistable.DataTable().destroy();
        thistable.DataTable({
            serverSide: true,
            ordering: false,
            searching: false,
            lengthMenu: tbLength,
            ajax: {
                url:"{{ route('pos-retail.index') }}?"+data,
                data:{
                    invoice:'{{request('invoice')}}',
                    receipt:'{{request('receipt')}}',
                    pos_history:'{{request('pos_history')}}',
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'sale_date'},
                    {data: 'reference_number'},
                    {data: 'seller'},
                    {data: 'customer_name'},
                    {data: 'grand_total'},
                    {data: 'paid_amount'},
                    {data: 'remain'},
                    {data: 'payment_method'},
                    {data: 'payment_status'},
                    {data: 'action'},
                ],
            "initComplete": function (settings, json) {

            },
            "createdRow": function (row, data, dataIndex) {
                if (data.delete_at) {
                    $(row).addClass('text-danger');
                    $(row).addClass('bg-danger');
                }
            },
        });
    }
// end

    $(document).on('click', '.showDetail', function(){
        let _this = $(this);
        var status = _this.data('status');
        var payment_url = _this.data('payment_url');
        var get_payment_url = _this.data('get_payment_url');
        var payment_id = _this.data('payment_id');
        $.ajax({
            url: _this.data('href'),
            dataType: 'html',
            method: 'get',
            success: function (data) {
                $.confirm({
                    title: '',
                    theme: 'modern',
                    useBootstrap: false,
                    boxWidth: '500px',
                    closeAnimation: 'zoom',
                    content: data,
                    buttons: {
                        hidden: {
                            btnClass: 'btn btn-warning click_close_form',
                            text: '{{__('administrator.close')}}',
                            keys: ['esc'],
                            action: function () {

                            }
                        },
                        enter: {
                            btnClass: 'btn btn-info',
                            text: '{{__('administrator.print')}}',
                            keys: ['enter'],
                            action: function () {
                                let this_ = this.$content.find('.print_this_form');
                                this_.printThis({
                                    //loadCSS: "{{asset('assets/css/pos-invoice.css')}}",
                                    beforePrint: function () {
                                        $(document).find('button').hide();
                                    },
                                    afterPrint: function () {
                                        $(document).find('button').show();
                                    },
                                });
                                return false;
                            }
                        },
                        payment: {
                            isHidden: status=== 'paid',
                            btnClass: 'btn-blue',
                            action: function(){
                                getHtmlForm(get_payment_url,'{{__('administrator.add_payment')}}','500px');
                                return false;
                            }
                        },
                    },
                });
            },
            error(xhr) {
                alertErrorFormController(xhr);
            }
        });
    });

</script>
@endsection
