<!doctype html>
<?php Fun::lang()?>
<html>
<head>
    <meta charset="utf-8">
    <title>NSO POS</title>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/css/pos-invoice.css')}}">
    <?php
    $hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
    ?>
</head>
<body>
<div class="invoice-box">
    <table class="tb-header">
        <tr>
            <td><img src="{{nsoLogo()}}" style="height: 50px;margin: 5px"></td>
        </tr>
        <tr>
            <td>
                <span>
                     <b class="name_logo">{{getBranch()->name}}</b><br>
                    <i style="font-size: 11px">{{getBranch()->address}}<br>{{getBranch()->phone}}</i>
                </span>
            </td>
        </tr>
    </table>
    {!! $hr !!}
    <table class="tb-inv-info text-left fl-left" style="font-style: italic">
        <tr>
            <td>{{__('administrator.invoice')}}</td>
            <td>&nbsp;:&nbsp;{{$master->invoice_number }}</td>
        </tr>
        <tr>
            <td>{{__('administrator.date')}}</td>
            <td>&nbsp;:&nbsp; <b
                        style="font-size: 12px">{{date('d-m-Y H:i:s',strtotime($master->created_at)) }} {{$master->daily_order_number?'('.$master->daily_order_number.')':''}}</b>
            </td>
        </tr>
        @if($master->customer_id)
            <tr>
                <td>
                    {{__('administrator.customer')}}
                </td>
                <td style="">
                    &nbsp;:&nbsp;{{findCustomer($master->customer_id)->customer_name }}
                </td>
            </tr>
        @endif
        @if($master->user_id)
            <tr>
                <td>{{__('administrator.cashier')}}</td>
                <td>&nbsp;:&nbsp;{{findUser($master->user_id)->name }}</td>
            </tr>
        @endif
    </table>
    {!! $hr !!}
    @php
        $hide=0;
            foreach($detail as $key => $row){
                if($row->dis==0){
                    $hide ++;
                }
            }
    @endphp
    <table class="tb-list-item small-font">
        <thead>
        <tr>
            <th>{{__('administrator.products')}}</th>
            <th>{{__('administrator.price')}}</th>
            <th class="{{$hide>0?'display-none':''}}">{{__('administrator.discount')}}</th>
            <th>{{__('administrator.total')}}</th>
        </tr>
        </thead>
        <tbody>
        @php $total_qty = 0; @endphp
        @foreach($detail as $key => $row)
            @php $total_qty+=$row->qty; @endphp
            <tr>
                <td>{{getProductById($row->product_id)->product_name}} ( {{findSize($row->size_id)->size}} )</td>
                <td>{{$row->qty.findUnit($row->unit_id)->unit}}
                    <small> x&nbsp;</small>{{user_currency()->symbol.number_format(convert_sale_detail_to_user_currency($row),2)}}</td>
                <td class="{{$hide>0?'display-none':''}}">{{$row->dis}}%</td>
                <td>{{user_currency()->symbol.number_format(generateTotal($row),2)}}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
    {!! $hr !!}
    <?php
    $sub_total = generateSubTotal($master);
    $g_total = 0;
    if ($master->delivery_fee || $master->discount) {
        $g_total = generateGrandTotal($master);
    }
    ?>
    <table class="tb-list-foot">
        <tr>
            <td colspan="3">{{__('administrator.total_item')}}</td>
            <td class="text-left">{{$total_qty}}</td>
        </tr>
        <tr>
            <td colspan="3">{{__('administrator.total')}}</td>
            <td class="text-left">{{user_currency()->symbol}}{{number_format(($sub_total),2)}}</td>
        </tr>
        @if($master->discount)
            <tr>
                <td colspan="3">{{__('administrator.discount')}}</td>
                <td class="text-left">{{$master->discount}}%
                    ({{user_currency()->symbol}}{{($sub_total * $master->discount) / 100}})
                </td>
            </tr>
        @endif
        @php $fee = 0; @endphp
        @if($master->delivery_fee>0)
            @php
                $fee = covert_delivery_fee($master);
            @endphp
            <tr>
                <td colspan="3">{{__('administrator.delivery_fee')}}</td>
                <td class="text-left">{{user_currency()->symbol}}{{ $fee}}</td>
            </tr>
        @endif
        @if($master->delivery_fee || $master->discount)
            <tr>
                <td colspan="3">{{__('administrator.grand_total')}}</td>
                <td class="text-left">{{user_currency()->symbol}}{{number_format(($g_total+$fee),2)}}</td>
            </tr>
        @endif
    </table>
    {!! $hr !!}
    @if($master->delivery_status)
        <h4 class="text-left"><u>{{__('administrator.delivery_info')}}</u></h4>
    @endif
    <table class="text-left " style="font-size: 12px;margin-top: 10px">
        @if($master->delivery_status)
            @if($master->customer_id)
                @php $customer = findCustomer($master->customer_id); @endphp
                <tr>
                    <td width="32%">
                        {{__('administrator.customer_name')}}
                    </td>
                    <td style="">: {{$customer->customer_name }}</td>
                </tr>
                @if($customer->customer_phone)
                    <tr>
                        <td>{{__('administrator.customer_phone')}}</td>
                        <td>: {{$customer->customer_phone }}<br></td>
                    </tr>
                @endif
            @endif
            @if($master->driver_id)
                @php $driver = findDriver($master->driver_id); @endphp
                <tr>
                    <td>{{__('administrator.driver_name')}}</td>
                    <td>: {{ $driver->name}}</td>
                </tr>
                @if($driver->phone)
                    <tr>
                        <td>{{__('administrator.driver_number')}}</td>
                        <td>: {{ $driver->phone}}</td>
                    </tr>
                @endif
            @endif
        @endif
        @if($master->note)
            <tr>
                <td class="text-left" width="32%">{{__('administrator.note')}}</td>
                <td>: {{ $master->note}}</td>
            </tr>
        @endif
    </table>
    @if($master->delivery_status || $master->note)
        {!! $hr !!}
    @endif
    <table>
        <tr>
            <td class="small-font"><b>{{getBranch()->invoice_footer}}</b></td>
        </tr>
    </table>
</div>
<script>

</script>
</body>
</html>
