@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <style>
        .padding-5 {
            padding: 5px !important;
        }

        .fa-pencil {
            cursor: pointer !important;
        }

        .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content {
            overflow: hidden;
        }

        .ui-timepicker-container {
            z-index: 99999999 !important;
        }

        legend {
            width: inherit;
            padding: 0 10px;
            border-bottom: none;
        }

        fieldset {
            padding: .35em .625em .75em !important;
            margin: 0 2px !important;
            border: 1px solid #00a65aa1 !important;
        }

        textarea {
            width: 100%;
        }
    </style>
    <?php

    $ill_text = '';
    $illness = \App\Model\CustomerIllnessModel::where('lead_id', $lead->id)->pluck('illness_id');
    foreach ($illness as $row) {
        $ill = findIllnessType($row);
        $ill_text .= $ill ? ($ill->name_km . ',') : '';
    }
    $ill_text = rtrim($ill_text, ',');
    $province = findProvince($lead->province);
    if ($province) {
        if (if_kh()) {
            $province = $province->name_kh;
        } else {
            $province = $province->name_en;
        }
    }
    ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-body">
                    <div class="pull-right">
                        <button onclick="window.history.back();" class="btn btn-warning"><i
                                class="fa fa-arrow-circle-left"
                                title="{{__('administrator.back')}}"> {{__('administrator.back')}}</i></button>
                        @if($lead->agent_id ===Auth::user()->id || Auth::user()->can('CRM Leader'))
                            @if ($lead->convert_status !== 1)
                                <a class="btn btn-success add_task"><i
                                        class="fa fa-tasks"
                                        title="{{__('administrator.task')}}"> {{__('administrator.task')}}</i></a>
                            @endif
                            @if($lead->convert_status !== 1 || Auth::user()->can('CRM Leader'))
                                <a href="javascript:;" data-url="{{ route('lead.close_deal', $lead->id) }}"
                                   class="btn btn-primary close_deal"><i class="fa fa-paper-plane" title="{{__('administrator.close_deal')}}"> {{__('administrator.grade')}}</i></a>
                            @endif
                        @endif
                        @if($lead->convert_status === 1)
                            @php
                                $customer = \App\Model\CustomerModel::where('lead_id', $lead->id)->first();
                                $customer = $customer ? $customer->id : '';
                            @endphp
                            <button type="button" class="btn btn-info"
                                    onclick="window.location.replace('{{route("pos-retail.create")}}?hellowajitnomotocambo=hibbbyerequestbyeloveyou&customer={{(Crypt::encrypt($customer))}}')">
                                <i href="javascript:;" class="fa fa-shopping-cart " title="View"></i></button>
                        @endif
                    </div>
                    <h4><label>{{__('administrator.lead_info')}} </label></h4>
                    <hr>
                    <div class="col-xs-offset-1 col-xs-10">
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label>{{__('administrator.date')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{ Carbon\Carbon::parse($lead->date)->format('d-m-y') }}</div>
                        </div>

                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.lead')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{ $lead->name }}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.gender')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{ ucfirst($lead->sex) }}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.contact')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{ $lead->contact }}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.age')}} :</label>
                            </div>
                            <div class="col-xs-9">{{ $lead->age?($lead->age.' '.__('administrator.year')):'' }}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.address')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{ $lead->address }}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.lead_source')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{ $lead->source() }}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.agent')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{ $lead->agent_name() }}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.province')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$province?$province:''}}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.status')}} :</label>
                            </div>
                            <div class="col-xs-9" ><?php
                                if ($lead->convert_status != 0)
                                    echo bgDealStatus($lead->convert_status);
                                ?>
                            </div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.page_name')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$lead->note}}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.customer_note')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$lead->customer_note}}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.result_note')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$lead->close_deal_note}}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.type_of_illness')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$ill_text}}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.illness_status')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$lead->illness_status}}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.advice_product')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$lead->advice_product}}</div>
                        </div>
                        <div class="form-group col-xs-6">
                            <div class="col-xs-3" style="text-align: right;">
                                <label> {{__('administrator.other')}} :</label>
                            </div>
                            <div class="col-xs-9" >{{$lead->other}}</div>
                        </div>

                    </div>
                    <div class="clearfix"></div>
                    <h4><label> {{__('administrator.appointment_log')}}</label></h4>
                    <hr>
                    <div class="col-xs-12 table-responsive">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th style="background: #2c3e50; color: white;"> #</th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.date')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.subject')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.place')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.status')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.task_note')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.out_come')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.result_percentage')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.result_note')}} </th>
                                <th width="10%"
                                    style="background: #2c3e50; color: white;"> {{__('administrator.action')}} </th>
                            </tr>
                            </thead>
                            <tbody>
                            @if (count($task->where('task_type', 'appointment')))
                                @php
                                    $i = 1;
                                @endphp
                                @foreach ($task->where('task_type', 'appointment') as $appointment)
                                    <tr>
                                        <td>{{ $i ++ }}</td>
                                        <td>{{ Carbon\Carbon::parse($appointment->date)->format('d-m-Y') }}</td>
                                        <td>{{ $appointment->subject }}</td>
                                        <td>{{ $appointment->where }}</td>
                                        <td>{!! $appointment->complete_status == 0 ?'<span class="label label-warning">Padding</span>':'<span class="label label-success">Complete</span>' !!}</td>
                                        <td>{!! Form::textarea('body', $appointment->note, ['class' => ' no-resize no-bg no-border','readonly','rows'=>3]) !!}</td>
                                        <td>{{ $appointment->out_come }}</td>
                                        <td>{{ $appointment->result_percentage?($appointment->result_percentage.'%'):'' }}</td>
                                        <td>{{ $appointment->result }}</td>
                                        <td>
                                            @if ($appointment->complete_status == 0 &&$lead->convert_status !=1)
                                                <i data-href="{{route('task.edit',$appointment->id)}}"
                                                   class="fa fa-pencil-square-o btn btn-sm btn-warning btn_edit"
                                                   title="Edit"></i>
                                                <i data-url="{{ route('task.complete', $appointment->id) }}"
                                                   class="fa fa-check btn btn-sm btn-success" title="Complete"></i>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                    <h4><label>{{__('administrator.meeting_log')}} </label></h4>
                    <hr>
                    <div class="col-xs-12 table-responsive">
                        <table class="table table-bordered " width="100%">
                            <thead>
                            <tr>
                                <th style="background: #2c3e50; color: white;"> #</th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.date')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.subject')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.place')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.status')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.task_note')}} </th>
                                <th style="background: #2c3e50; color: white;">{{__('administrator.out_come')}}   </th>
                                <th style="background: #2c3e50; color: white;">{{__('administrator.result_percentage')}}  </th>
                                <th style="background: #2c3e50; color: white;">{{__('administrator.result_note')}}   </th>
                                <th width="10%"
                                    style="background: #2c3e50; color: white;">{{__('administrator.action')}} </th>
                            </tr>
                            </thead>
                            <tbody>
                            @if (count($task->where('task_type', 'meeting')))
                                @php
                                    $i = 1;
                                @endphp
                                @foreach ($task->where('task_type', 'meeting') as $meeting)

                                    <tr class="no-bg">
                                        <td>{{ $i ++ }}</td>
                                        <td>{{ Carbon\Carbon::parse($meeting->date)->format('d-m-Y') }}</td>
                                        <td>{{ $meeting->subject }}</td>
                                        <td>{{ $meeting->where }}</td>
                                        <td>{!! $meeting->complete_status == 0 ?'<span class="label label-warning">Padding</span>':'<span class="label label-success">Complete</span>' !!}</td>
                                        <td>{!! Form::textarea('body', $meeting->note, ['class' => ' no-resize no-bg no-border','readonly','rows'=>3]) !!}</td>
                                        <td>{{ $meeting->out_come }}</td>
                                        <td>{{ $meeting->result_percentage?($meeting->result_percentage.'%'):'' }}</td>
                                        <td>{{ $meeting->result }}</td>
                                        <td>
                                            @if ($meeting->complete_status == 0  && $lead->convert_status !=1)
                                                <i data-href="{{route('task.edit',$meeting->id)}}"
                                                   class="fa fa-pencil-square-o btn btn-sm btn-warning btn_edit"
                                                   title="Edit"></i>
                                                <i data-url="{{ route('task.complete', $meeting->id) }}"
                                                   class="fa fa-check btn btn-sm btn-success" title="Complete"></i>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            @endif


                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                    <h4><label>{{__('administrator.total_call_log')}} </label></h4>
                    <hr>
                    <div class="col-xs-12 table-responsive">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th style="background: #2c3e50; color: white;"> #</th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.date')}} </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.subject')}} </th>
                                <th style="background: #2c3e50; color: white;">  {{__('administrator.status')}}  </th>
                                <th style="background: #2c3e50; color: white;">  {{__('administrator.call_type')}}  </th>
                                <th style="background: #2c3e50; color: white;">  {{__('administrator.call_duration')}}  </th>
                                <th style="background: #2c3e50; color: white;"> {{__('administrator.task_note')}} </th>
                                <th style="background: #2c3e50; color: white;">  {{__('administrator.out_come')}}  </th>
                                <th style="background: #2c3e50; color: white;">  {{__('administrator.result_percentage')}}  </th>
                                <th style="background: #2c3e50; color: white;">  {{__('administrator.result_note')}}  </th>
                                <th width="10%"
                                    style="background: #2c3e50; color: white;">  {{__('administrator.action')}}  </th>
                            </tr>
                            </thead>
                            <tbody>

                            @if (count($task->where('task_type', 'call_log')))
                                @foreach ($task->where('task_type', 'call_log') as $key => $call_log)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ Carbon\Carbon::parse($call_log->date)->format('d-m-Y')  }}</td>
                                        <td>{!! Form::textarea('body', $call_log->subject, ['class' => ' no-resize no-bg no-border','readonly','rows'=>3]) !!}</td>
                                        <td>{!! $call_log->complete_status == 0 ?'<span class="label label-warning">Padding</span>':'<span class="label label-success">Complete</span>' !!}</td>
                                        <td>{{ $call_log->call_type }}</td>
                                        <td>N/A</td>
                                        <td>{!! Form::textarea('body', $call_log->note, ['class' => ' no-resize no-bg no-border','readonly','rows'=>3]) !!}</td>
                                        <td>{{ $call_log->out_come }}</td>
                                        <td>{{ $call_log->result_percentage?($call_log->result_percentage.'%'):'' }}</td>
                                        <td>{{ $call_log->result }}</td>
                                        <td>
                                            @if ($call_log->complete_status == 0 && $lead->convert_status !=1)
                                                <i data-href="{{route('task.edit',$call_log->id)}}"
                                                   class="fa fa-pencil-square-o btn btn-sm btn-warning btn_edit"
                                                   title="Edit"></i>
                                                <i data-url="{{ route('task.complete', $call_log->id) }}"
                                                   class="fa fa-check btn btn-sm btn-success" title="Complete"></i>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        // new task

        $(document).ready(function () {
            $('.add_task').on('click', function () {
                getHtmlForm('{{route('task.create')}}?lead_id={{$lead->id}}', '{{__('administrator.create').' '.__('administrator.task')}}');
            });
            $('.btn_edit').on('click', function () {
                getHtmlForm($(this).data('href'), '{{__('administrator.edit').' '.__('administrator.task')}}');
            });

        });

        // new complete
        $(document).on('click', '.fa-check', function () {
            var url = $(this).data('url');
            $.confirm({
                type: 'blue',
                title: '{{__('administrator.complete_task')}}!',
                columnClass: 'col-md-8 col-md-offset-2',
                width: '100%',
                content: `
                <div class="col-md-6 padding-5">
                    <label>{{__('administrator.outcome')}}
                <span class="text-danger">*</span></label>
{!! Form::select('outcome', getOutCome(), null, ['class' => 'outcome form-control select2', 'placeholder' => __('administrator.outcome')])  !!}
                </div>
                <div class="col-md-6 padding-5">
                    <label> {{__('administrator.result_percentage')}}
                <span class="text-danger">*</span></label>
                <input type="text" class="form-control numeric" placeholder="{{ __('administrator.result_percentage') }}" maxlength="25"/>
                </div>
                <div class="col-md-12 padding-5">
                    <label>{{ __('administrator.note') }}</label>
                    <textarea class="form-control note" rows="5"></textarea>
                </div>
            `,
                typeAnimated: true,
                closeIcon: true,
                closeIconClass: 'flaticon-close',
                buttons: {
                    '{{__('administrator.update')}}': {
                        btnClass: 'btn-blue',
                        keys: ['enter'],
                        action: function () {
                            var outcome = this.$content.find('.outcome').val();
                            var percentage = this.$content.find('.numeric').val();
                            var note = this.$content.find('.note').val();

                            if (!outcome) {
                                this.$content.find('.outcome').closest('.col-md-6').find('span.select2-selection').addClass('formError');
                                return false;
                            } else {
                                this.$content.find('.outcome').closest('.col-md-6').find('span.select2-selection').removeClass('formError');
                            }

                            if (!percentage) {
                                this.$content.find('.numeric').addClass('formError');
                                return false;
                            } else {
                                this.$content.find('.numeric').removeClass('formError');
                            }

                            $.ajax({
                                url: url,
                                data: {
                                    '_token': '{{ csrf_token() }}',
                                    outcome,
                                    percentage,
                                    note
                                },
                                type: 'PATCH',
                                async: false,
                                success: function (data) {
                                    if (data[1] == 401) {
                                        showWarningToast(data[0]);
                                    } else {
                                        page = 1;
                                        showSuccessToast('Task updated successfully!');
                                        $('.jconfirm-buttons .btn-default').trigger('click');
                                        location.reload();
                                    }
                                }
                            });
                            return false;
                        }
                    },
                    '{{__('administrator.cancel')}}': function () {
                    }
                },
                onContentReady: function () {
                    $('.outcome').select2();
                }
            });
        });
        {{--
            $(document).on('change', '.result',  function(){
                if($(this).val() == 1){
                    $('.custome_type_div').show();
                }else{
                    $('.custome_type_div').hide();
                }
            }); --}}

        // close deal
        $(document).on('click', '.close_deal', function () {
            var url = $(this).data('url');
            $.confirm({
                type: 'blue',
                title: '{{ __('administrator.close_deal') }}',
                columnClass: 'col-md-8 col-md-offset-2',
                width: '100%',
                content: `
                <div class="col-md-12 padding-5">
                    <label> {{ __('administrator.result') }}
                <span class="text-danger">*</span></label>
{!! Form::select('result',
                getDealResult(), null, ['class' => 'result form-control select2', 'placeholder' => __('administrator.please_select')])  !!}
                </div>
                <div class="col-md-12 padding-5 custome_type_div" style="display: none;" >
                    <label> {{ __('administrator.customer_type') }}
                <span class="text-danger">*</span></label>
{!! Form::select('custome_type', ['seller' => 'Dealer', 'Branch' => 'Branch', 'member' => 'Member','custome'=>'customer'], null, ['class' => 'custome_type form-control select2', 'placeholder' => 'Custome Type'])  !!}
                </div>
                <div class="col-md-12  padding-5">
                    <label>{{ __('administrator.note') }}</label>
                    <textarea class="form-control note" rows="5"></textarea>
                </div>
            `,
                typeAnimated: true,
                closeIcon: true,
                closeIconClass: 'flaticon-close',
                buttons: {
                    '{{__('administrator.update')}}': {
                        btnClass: 'btn-blue',
                        keys: ['enter'],
                        action: function () {
                            var result = this.$content.find('.result').val();
                            var custome_type = this.$content.find('.custome_type').val();
                            var note = this.$content.find('.note').val();

                            if (!result) {
                                this.$content.find('.result').closest('.col-md-12').find('span.select2-selection').addClass('formError');
                                return false;
                            } else {
                                this.$content.find('.result').closest('.col-md-12').find('span.select2-selection').removeClass('formError');
                            }
                            $.ajax({
                                url: url,
                                data: {
                                    '_token': '{{ csrf_token() }}',
                                    result,
                                    custome_type,
                                    note
                                },
                                type: 'PATCH',
                                async: false,
                                success: function (data) {
                                    if (data[1] == 401) {
                                        showWarningToast(data[0]);
                                    } else {
                                        page = 1;
                                        showSuccessToast('Lead updated successfully!');
                                        $('.jconfirm-buttons .btn-default').trigger('click');
                                        location.reload();
                                    }
                                }
                            });
                            return false;
                        }
                    },
                    '{{__('administrator.cancel')}}': function () {
                    }
                },
                onContentReady: function () {
                    $('.result').select2();
                }
            });
        });

    </script>
@endsection
