@extends(branchMenu())
@section('content')
<?php Fun::lang()?>
<style>
    .padding-5{
        padding: 5px !important;
    }
    .fa-pencil{
        cursor: pointer !important;
    }
    .jconfirm .jconfirm-box div.jconfirm-content-pane .jconfirm-content{
        overflow: hidden;
    }
    .ui-timepicker-container{
        z-index: 99999999 !important;
    }
    .select2-container--open{
        z-index: 99999999 !important;

    }
</style>
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header">
                <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.pospect')}}</h3>
                        </div>
                        <div class="pull-right">
                            <a href="{{ url("lead-report?type=meeting") }}">
                                <button class="btn btn-success btn-xs {{ request()->type == 'meeting' ? 'bg-aqua-active':'' }}">{{ __('administrator.meeting_log') }}</button>
                            </a>
                            <a href="{{ url("lead-report?type=appointmentasd") }}">
                                <button class="btn btn-success btn-xs {{ request()->type == 'appointment' ? 'bg-aqua-active':'' }}">{{ __('administrator.appointment_log') }}</button>
                            </a>
                            <a href="{{ url("lead-report?type=call_log") }}">
                                <button class="btn btn-success btn-xs {{ request()->type == 'call_log' ? 'bg-aqua-active':'' }}">{{ __('administrator.call_log') }}</button>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            </div>
            <div class="box-body table-responsive">
                <table id="data_table" width="100%" class="table table-bordered table-striped dataTable table-responsive">
                <thead>
                    <tr>
                        <th>N°</th>
                        <th >{{ __('administrator.register_date') }}</th>
                        <th >{{__('administrator.agent')}}</th>
                        <th >{{__('administrator.name')}}</th>
                        <th >{{ __('administrator.sex') }}</th>
                        <th>{{ __('administrator.contact') }}</th>
                        <th>{{ __('administrator.address') }}</th>
                        <th>{{ __('administrator.status') }}</th>
                    </tr>
                    <tr>
                        <td></td>
                        <td>
                            <input type="text" name="datepicker" class="form-control datepicker" placeholder="{{__('administrator.date')}}" autocomplete="off">
                        </td>
                        <td>
                            @if((\Auth::user()->is_role == 'Administrator'))
                                {!! Form::select('agent', getAgent(), null, ['class' => 'agent form-control select2', 'placeholder' => __('administrator.agent')])  !!}
                            @endif
                        </td>
                        {{-- <td>
                            <input type="text" name="first_name" class="form-control first_name" placeholder="{{__('administrator.family_name')}}" autocomplete="off">
                        </td> --}}
                        <td>
                            <input type="text" name="last_name" class="form-control last_name" placeholder="{{__('administrator.name')}}" autocomplete="off">
                        </td>
                        <td></td>
                        <td>
                            <input type="text" name="contact" class="form-control" placeholder="{{__('administrator.contact')}}" autocomplete="off">
                        </td>
                        <td>
                             <input type="text" name="address" class="form-control" placeholder="{{__('administrator.address')}}" autocomplete="off">
                        </td>
                        <td>
                            {!! Form::select('task', ['meeting' => 'Meeting', 'appointment' => 'Appointment', 'call_log' => 'Call_log'], null, ['class' => 'task form-control select2', 'placeholder' => __('administrator.task_type')])  !!}
                        </td>
                    </tr>
                </thead>
                <tbody>

                </tbody>
                </tfoot>
            </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
//  start datatable
    var record = 20;
    var page = 1;
    $(document).ready(function() {
        dataTable();
        $.fn.dataTable.ext.errMode = 'throw';
        $('.datepicker').datepicker({
            dateFormat: 'dd-mm-yy',
            autoclose: true,
            onSelect: function(dateText) {
                $('.form-control').trigger('blur');
            }
        });
    });

    $(document).on('blur', '.form-control.input-sm', function() {
        record = $(this).val();
        page = 1;
        $('#data_table').DataTable().destroy();
        dataTable();
    });

    $(document).on('blur', 'input[name="datepicker"], input[name="first_name"], input[name="last_name"], input[name="contact"], input[name="address"]', function(){
        page = 1;
        $('#data_table').DataTable().destroy();
        dataTable();
    });

    $(document).on('change', 'select[name="agent"], select[name="task"]', function(){
        page = 1;
        $('#data_table').DataTable().destroy();
        dataTable();
    });

    $(document).on('click', '.fa.fa-times', function(){
        page = 1;
        $('.form-control').val(null);
        $('select[name="agent"]').val('').trigger('change');
        $('select[name="task"]').val('').trigger('change');
        $('#data_table').DataTable().destroy();
        dataTable();
    });

    $(document).on('click', '.page-item', function() {
        page = $('.page-item.active .page-link').text();
        $('#data_table').DataTable().destroy();
        dataTable();

    });


    function dataTable() {
        var date = $('input[name="datepicker"]').val();
        var first_name = $('input[name="first_name"]').val();
        var last_name = $('input[name="last_name"]').val();
        var contact = $('input[name="contact"]').val();
        var address = $('input[name="address"]').val();
        var task = $('select[name="task"]').val();
        var agent = $('select[name="agent"]').val();
        var type = {!! json_encode(request()->type)!!};


        $('#data_table').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.previous')}}"
                },
            },
            serverSide: true,
            ordering: false,
            searching: false,
            pageLength: record,
            lengthMenu: tbLength,
            ajax: {
                url: '{!! url("prospect-report") !!}',
                data:{
                    date,
                    last_name,
                    contact,
                    address,
                    task,
                    agent,
                    record,
                    page
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex'},
                    {data: 'date'},
                    {data: 'agent_name'},
                    {data: 'name'},
                    {data: 'sex'},
                    {data: 'contact'},
                    {data: 'address'},
                    {data: 'convert_status'},
                ],
            "initComplete": function (settings, json) {
                $('select[name="data_table_length"]').val(json.records);
                $('.dataTables_paginate').empty();
                $('#data_table_paginate').twbsPagination('destroy');
                $('#data_table_paginate').twbsPagination({
                    totalPages: json.totalPage,
                    visiblePages: 5,
                    startPage: parseInt(json.activePage),
                    next: 'Next',
                    prev: 'Prev',
                    onPageClick: function (event, pageD) {
                    }
                });
            }
        });
    }
</script>
@endsection
