@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <style>
        .dataTable select {
            width: unset!important;
        }
        .dataTable td {
            white-space: nowrap;
        }
        .dataTable td:nth-child(6), .dataTable td:nth-child(10) {
            white-space: normal;
        }
    </style>
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="title-add">
                                <div class="pull-left">
                                    <h3>{{__('administrator.report_prospect')}}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <fieldset class="well the-fieldset">
                    <form class="form_data">
                        <div class="col-sm-12">
                            <div class="col-sm-3">
                                <label>{{__('administrator.register_date')}}</label>
                                {!! Form::text('r_start_date', null, ['class' => 'agent form-control date_picker', 'placeholder' => __('administrator.from_date')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.register_date')}}</label>
                                {!! Form::text('r_end_date', null, ['class' => 'agent form-control date_picker', 'placeholder' => __('administrator.to_date')])  !!}
                            </div>
                            @if((\Auth::user()->is_role == 'Administrator'))
                                <div class="col-sm-3">
                                    <label>{{__('administrator.agent')}}</label>
                                    {!! Form::select('agent_id', getAgent(), null, ['class' => 'agent form-control select2', 'placeholder' => __('administrator.agent')])  !!}
                                </div>
                            @endif
                            <div class="col-sm-3">
                                <label>{{__('administrator.name')}}</label>
                                {!! Form::select('lead_id',[], null, ['class' => ' form-control search_lead', 'placeholder' => __('administrator.name')])  !!}
                            </div>
                            <div class="col-sm-12">&nbsp;</div>

                            <div class="col-sm-3">
                                <label>{{__('administrator.sex')}}</label>
                                {!! Form::select('sex', getGender(), null, ['class' => ' select2 form-control', 'placeholder' => __('administrator.please_select')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.contact')}}</label>
                                {!! Form::text('search_contact', null, ['class' => ' form-control', 'placeholder' => __('administrator.contact')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.type_of_illness')}}</label>
                                {!! Form::select('illness', illness_type(), null, ['class' => '  select2 form-control', 'placeholder' => __('administrator.please_select')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.lead_source')}}</label>
                                {!! Form::select('lead_source', leadSource(), null, ['class' => 'form-control  select2', 'placeholder' => __('administrator.please_select')])  !!}
                            </div>
                            <div class="col-sm-12">&nbsp;</div>

                            <div class="col-sm-3">
                                <label>{{__('administrator.province')}}</label>
                                {!! Form::select('province', getProvince(), null, ['class' => 'form-control  select2', 'placeholder' => __('administrator.please_select')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.address')}}</label>
                                {!! Form::text('search_address', null, ['class' => 'form-control', 'placeholder' => __('administrator.address')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.date_follow_up')}}</label>
                                {!! Form::text('f_start_date', null, ['class' => 'agent form-control date_picker', 'placeholder' => __('administrator.from_date')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.date_follow_up')}}</label>
                                {!! Form::text('f_end_date', null, ['class' => 'agent form-control date_picker', 'placeholder' => __('administrator.to_date')])  !!}
                            </div>
                            <div class="col-sm-12">&nbsp;</div>

                            <div class="col-sm-3">
                                <label>{{__('administrator.task_type')}}</label>
                                {!! Form::select('type',getTaskType(), null, ['class' => 'form-control  select2', 'placeholder' => __('administrator.please_select')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.deal_status')}}</label>
                                {!! Form::select('convert_status',getDealResult(), null, ['class' => 'form-control  select2', 'placeholder' => __('administrator.please_select')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <label>{{__('administrator.page_name')}}</label>
                                {!! Form::text('note', null, ['class' => 'agent form-control ', 'placeholder' => __('administrator.page_name')])  !!}
                            </div>
                            <div class="col-sm-3">
                                <br>
                                <button type="button" class="btn btn-warning btn-clear">{{__('administrator.clear')}}</button>
                            </div>
                        </div>
                    </form>
                </fieldset>
                <div class="box-body table-responsive " >
                    <table id="data_table" class="table table-bordered table-striped" >
                        <thead >
                        <tr>
                            <th>N°</th>
                            <th>{{ __('administrator.register_date') }}</th>
                            <th>{{__('administrator.agent')}}</th>
                            <th>{{__('administrator.name')}}</th>
                            <th>{{ __('administrator.sex') }}</th>
                            <th>{{ __('administrator.contact') }}</th>
                            <th>{{ __('administrator.type_of_illness') }}</th>
                            <th>{{ __('administrator.lead_source') }}</th>
                            <th>{{ __('administrator.page_name') }}</th>
                            <th>{{ __('administrator.province') }}</th>
                            <th>{{ __('administrator.address') }}</th>
                            <th>{{ __('administrator.date_follow_up') }}</th>
                            <th>{{ __('administrator.task_type') }}</th>
                            <th>{{ __('administrator.deal_status') }}</th>
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        //  start datatable
        let table_ = $('#data_table');
        let form_data =  $('.form_data');
        $(document).ready(function () {
            dataTable();
            $('.form_data').on('change', 'select,input', function () {
                dataTable();
            });
            $(document).on('click', '.btn-clear', function () {
                $('.form-control').val(null);
                form_data.find('select,input').val('').change();
                dataTable();
            });
        });
        function dataTable() {
            table_.DataTable().destroy();
            let data = form_data.serialize();
            let url = '{!! url("lead-report") !!}?' + data;
            table_.DataTable({
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        className: 'btn btn-info pull-right',
                        filename: menu_name,
                        title: menu_name,
                        sheetName: menu_name,
                        header: true,
                        text: 'Save as Excel',
                    },
                ],
                serverSide: true,
                ordering: false,
                searching: false,
                lengthMenu: tbLength,
                ajax: {
                    url: url
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'register_date'},
                        {data: 'agent_name'},
                        {data: 'name'},
                        {data: 'sex'},
                        {data: 'contact'},
                        {data: 'illness'},
                        {data: 'lead_source'},
                        {data: 'note'},
                        {data: 'province'},
                        {data: 'address'},
                        {data: 'followup_date'},
                        {data: 'task_type'},
                        {data: 'convert_status'},
                    ],
            });
        }
    </script>
@endsection
