@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.request_'.request('type'))}}</h3>
                            </div>
                            <div class="pull-right">
                                @if(request('type')=='to')
                                    @if(Auth::user()->user_type==='member')
                                        <a href="{{route('request-stock.create')}}?if_approve={{encrypt(0)}}"
                                           class=" btn btn-primary"><span
                                                class="fa fa-plus"></span> {{__('administrator.add_new')}}</a>
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <br>&nbsp;
            <br>
            <div class="wrapper-table table-responsive">
                <table id="print_table" class="table table-striped table-hover">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.request_date')}}</th>
                        <th>{{__('administrator.reference_number')}}</th>
                        <th>{{__('administrator.request_by')}}</th>
                        <th>{{__('administrator.request_to')}}</th>
                        <th>{{__('administrator.status')}}</th>
                        <th>{{__('administrator.approve_by')}}</th>
                        <th>{{__('administrator.approve_date')}}</th>
                        <th>{{__('administrator.confirm_received')}}</th>
                        <th style="min-width: 10%">{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
@section('script')
    <script type="text/javascript">


        $(document).ready(function () {
            getTable();
            $(document).on('click', ' .show_request', function () {
                let show_receive = $(this).data('show_receive');
                let show_approve = $(this).data('show_approve');
                let get_update_status_url = $(this).data('get_update_status_url');
                let update_status_url = $(this).data('update_status_url');
                let confirm_url = $(this).data('confirm_url');
                $.ajax({
                    url: $(this).data('href'),
                    method: 'get',
                    dataType: 'json',
                    success: function (data) {
                        $.confirm({
                            title: '',
                            theme: 'modern',
                            useBootstrap: false,
                            boxWidth: '50%',
                            content: data.view,
                            buttons: {
                                close: {
                                    text: '{{__('administrator.close')}}',
                                    btnClass: 'btn btn-warning',
                                },
                                print: {
                                    text: '{{__('administrator.print')}}',
                                    btnClass: 'btn btn-info',
                                    keys: ['enter'],
                                    action: function () {
                                        $('.print_this_form').printThis({
                                            afterPrint: function () {
                                            }
                                        });
                                        return false;
                                    },
                                },
                                @if (uCan('Request Stock Approve'))
                                approve: {
                                    text: '{{__('administrator.approve')}}',
                                    btnClass: 'btn btn-success approve ',
                                    action: function () {
                                        window.location.replace(get_update_status_url);
                                    }
                                },
                                reject: {
                                    text: '{{__('administrator.reject')}}',
                                    btnClass: 'btn btn-danger approve',
                                    action: function () {
                                        $.confirm({
                                            title: '{{__('administrator.are_you_sure')}}',
                                            content: '',
                                            buttons: {
                                                submit: {
                                                    text: '{{__('administrator.reject')}}',
                                                    btnClass: 'btn-danger',
                                                    action: function () {
                                                        let self = this;
                                                        $.ajax({
                                                            url: update_status_url,
                                                            method: 'POST',
                                                            data: {
                                                                "_token": "{{ csrf_token() }}",
                                                            },
                                                            success: function (data) {
                                                                if (data.status) {
                                                                    window.location.reload();
                                                                }
                                                            },
                                                            error: function (xhr) {
                                                                self.buttons.submit.enable();
                                                                alertErrorFormController(xhr, self);
                                                            }
                                                        });
                                                        return false;
                                                    }
                                                },
                                                close: {
                                                    text: '{{__('administrator.close')}}',
                                                    btnClass: 'btn-warning',
                                                    action: function () {

                                                    }
                                                },
                                            }
                                        });
                                        return false;
                                    }
                                },
                                @endif
                                confirm_received: {
                                    text: '{{__('administrator.confirm_received')}}',
                                    btnClass: 'btn-success confirm_status',
                                    keys: ['enter'],
                                    action: function () {
                                        window.location.replace(confirm_url);
                                        return false
                                    }
                                },
                                seller_reject: {
                                    text: '{{__('administrator.reject')}}',
                                    btnClass: 'btn-danger confirm_status',
                                    keys: ['enter'],
                                    action: function () {
                                        $.confirm({
                                            title: '{{__('administrator.reject')}}',
                                            theme: 'modern',
                                            content: '{{__('administrator.are_you_sure')}}',
                                            buttons: {
                                                cancel: {
                                                    btnClass: 'btn-warning',
                                                    text: '{{__('administrator.cancel')}}',
                                                },
                                                reject: {
                                                    btnClass: 'btn-danger',
                                                    text: '{{__('administrator.reject')}}',
                                                    action: function () {
                                                        $.ajax({
                                                            url: confirm_url,
                                                            method: 'POST',
                                                            data: {
                                                                "_token": "{{ csrf_token() }}",
                                                                status: 2
                                                            },
                                                            async: false,
                                                            success: function (data) {
                                                                if (data.status) {
                                                                    window.location.reload();
                                                                }
                                                            }
                                                        });
                                                    }
                                                }
                                            },
                                        });
                                        return false
                                    }
                                }
                            },


                        });
                        setTimeout(function () {
                            if (show_receive === 0) {
                                $(document).find('.confirm_status').remove();
                            }
                            if (show_approve === 0) {
                                $(document).find('.approve').remove();
                            }

                        }, 10);

                    }
                });
            });
        });
        function getTable() {
            let type = '{{request()->type}}';
            $('#print_table').DataTable().destroy();
            $('#print_table').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: tbLength,
                ajax: {
                    url: "{{ route('request-stock.index') }}",
                    data: {type}
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'request_date', 'searchable': false},
                        {data: 'reference_number', 'name': 'nso007_item_request.reference_number'},
                        {data: 'member_id', 'searchable': false},
                        {data: 'request_to', 'searchable': false},
                        {data: 'status', 'searchable': false},
                        {data: 'approve_by', 'searchable': false},
                        {data: 'approve_date', 'searchable': false},
                        {data: 'confirm_status', 'searchable': false},
                        {data: 'action', 'searchable': false},

                    ],

                "initComplete": function (settings, json) {
                }
            });
        }
    </script>
@stop
