@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <?php $total = 0 ?>
    <?php $total_discount = 0 ?>
    <?php $g_total = 0 ?>
    <style>
        /*************************
        Pendding
        *************************/
        .pend-80 {
            padding: 0px 22px !important;
        }

        .bg-grey {
            background: rgba(1, 1, 1, 0.1);
        }

        .fl-left {
            float: left;
            width: 40%;
        }
    </style>
    <div class="page-purchases">
        <div class="container">
            <div class="container-fluid">
                <div class="top-content">
                    <div class="row text-right">
                        <div class="col-md-12">
                            <button class="button_info print_">Print</button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="fl-left">
                                <img src="{{findImg(mainBranch()->logo)}}" class="md-top">
                            </div>
                            <br>
                            <div class="pull-right">
                                <div class="title-add">
                                    <h2 class="text-green">{{__('administrator.stock_in')}}</h2><br>
                                    <table class="table table-striped table-hover ">
                                        <tr>
                                            <td class="pend-80"><b>{{__('administrator.invoice')}}:</b></td>
                                            <td>{{$purchases->invoice_number}}</td>
                                        </tr>
                                        <tr>
                                            <td class="pend-80"><b>{{__('administrator.stock_in_date')}}:</b></td>
                                            <td>{{date('d-m-Y',strtotime($purchases->purchase_date))}}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="summary-header">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="pull-left">
                                <?php
                                    if($purchases->request_to){
                                        $supplier = findBranch($purchases->request_to);
                                        $sup_name = $supplier->name;
                                        $sup_phone = $supplier->phone;
                                    }else{
                                        $supplier = findSupplier($purchases->supplier_id);
                                        $sup_name = $supplier->supplier_name;
                                        $sup_phone = $supplier->supplier_phone;
                                    }

                                ?>
                                    <div class="vender"><h4>{{__('administrator.suppliers')}}</h4></div>
                                    <p>{{__('administrator.from')}}
                                        : {{$sup_name}}</p>
                                    <p>{{__('administrator.supplier_phone')}}
                                        : {{$sup_phone}}</p>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="pull-right">
                                <div class="vender"><h4>{{__('administrator.ship_to')}}</h4></div>
                                <p>{{__('administrator.warehouse')}}
                                    : {{ findWarehouse($purchases->warehouse_id)->warehouse_name }}</p>
                                <p>{{__('administrator.address')}}
                                    : {{ findWarehouse($purchases->warehouse_id)->location_name }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div class="wrapper-table">
                    <table class="table table-striped table-hover ">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>{{__('administrator.product_code')}}</th>
                            <th>{{__('administrator.item_name')}}</th>
                            <th>{{__('administrator.qty')}}</th>
                            <th>{{__('administrator.cost')}}</th>
                            <th>{{__('administrator.discount')}} (%)</th>
                            <th>{{__('administrator.total')}}</th>
                        </tr>
                        </thead>
                        <tbody>
                        @php
                            $g_total= 0;
                            $total_kh = 0;
                            $total_usd = 0;
                        @endphp
                        @foreach($purchase_details as $key => $value)

                            <?php
                            if ($purchases->type == 'material') {
                                $unit = findUnit($value->unit_id);
                                $barcode = getProductById($value->product_id)->barcode;
                            } else {
                                if ($value->type == 'fabric') {
                                    $unit = findUnit(getProductById($value->product_id)->unit_id);
                                } else {
                                    $unit = findProductUnitByCode($value->barcode, $value->type);
                                    $unit = findUnit($unit->unit_id);
                                }
                                $barcode = $value->barcode;
                            }

                            $currency = findCurrency(getProductById($value->product_id)->currency);
                            $amount = $value->qty * $value->cost;
                            $total = $amount - ($value->dis * $amount / 100);

                            // $total_discount += ($currency == '$' ? ($amount * $value->dis / 100) : ($amount * $value->dis / 100));
                            ?>
                            <tr>
                                <td>{{$key+1}}</td>
                                <td>{{$barcode}}</td>
                                <td>{{getProductById($value->product_id)->product_name}}
                                    @if($value->size_id || $value->color_id)
                                        ({{findSize($value->size_id)?(__('administrator.size').' : '.findSize($value->size_id)->size.' , '):''}})
                                    @endif</td>
                                <td>{{$value->qty.' '.($unit?$unit->unit:'')}}</td>
                                <td>{{$currency->symbol.number_format($value->cost,2) }}</td>
                                <td>{{number_format($value->dis)}}%</td>
                                <td>{{$currency->symbol.number_format(floatval($total),2)}}</td>
                            </tr>
                        @endforeach
                        @php
                            $g_total = generatePurchaseGrandTotal($purchases);
                            $paid = $purchases->paid_usd + ($purchases->paid_kh>0?($purchases->paid_kh/$purchases->rate):0)+ ($purchases->paid_baht>0?($purchases->paid_baht/$purchases->rate_baht):0);
                        @endphp
                        </tbody>
                        <tfoot class="label-right">
                        <tr>
                            <td colspan="4" class="text-right">{{__('administrator.discount')}} :</td>
                            <td colspan="3" class="text-center">{{number_format($purchases->discount)}}%</td>

                        </tr>
                        <tr>
                            <td colspan="4"></td>
                            <td class="bg-grey">{{__('administrator.riel')}}</td>
                            <td class="bg-grey">{{__('administrator.usd')}}</td>
                            <td class="bg-grey">{{__('administrator.baht')}}</td>
                        </tr>
                        <tr>
                            <td colspan="4" class="text-right"><b>{{__('administrator.grand_total')}} :</b></td>

                            <td class=""> ៛​ {{number_format(($g_total*$purchases->rate),2)}}</td>
                            <td class="">${{number_format($g_total,2)}}</td>
                            <td class="">฿{{number_format($g_total*$purchases->rate_baht,2)}}</td>
                        </tr>
                        <tr>

                            <td colspan="4" class="text-right"><b>{{__('administrator.paid')}}:</b></td>
                            <td> ៛ {{$purchases->paid_kh}}</td>
                            <td>${{number_format($purchases->paid_usd,2)}}</td>
                            <td>฿{{number_format($purchases->paid_baht,2)}}</td>
                        </tr>
                        @if($paid >=$g_total)
                            <tr>
                                <td colspan="4" class="text-right"><b>{{__('administrator.change_amount')}} :</b></td>
                                <td>៛{{number_format(($paid-$g_total)*$purchases->rate,2)}}</td>
                                <td>${{number_format($paid-$g_total,2)}}</td>
                                <td>฿{{number_format(($paid-$g_total)*$purchases->rate_baht,2)}}</td>
                            </tr>
                        @else
                            <tr>
                                <td colspan="4" class="text-right"><b>{{__('administrator.owed_amount')}} :</b></td>
                                <td>៛ {{number_format(($g_total-$paid)*$purchases->rate,2)}}</td>
                                <td>${{(number_format($g_total-$paid,2))}}</td>
                                <td>฿ {{number_format(($g_total-$paid)*$purchases->rate_baht,2)}}</td>
                            </tr>
                        @endif
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="col-sm-6">
                            <div class="border-seller pull-left">
                                <p class="text-center"><b>{{__('administrator.suppliers')}}</b></p><br>
                                <p>..............................................................</p>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="border-seller pull-right">
                                <p class="text-center"><b>{{__('administrator.warehouse')}}</b></p><br>
                                <p>..............................................................</p>
                            </div>
                        </div>
                    </div>
                </div>
                <br><br><br><br><br>
                <div class="row">
                    <div class="col-sm-12">
                        <p class="text-center">
                            សម្រាប់សំណួរទាក់ទងនឹងការបញ្ជាទិញនេះសូមទាក់ទងមកកាន់<br><b>{{getBranch()->phone}}</b></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $('.print_').on('click', function () {
                $('.page-purchases').printThis({
                    loadCSS: "{{asset('css/styles.css')}}",
                    afterPrint: function () {
                        window.location.reload();
                    }
                });
            })

        });
    </script>
@stop









