<?php
$hr = '<div style="width: 100%;border-top: 1px dashed rgba(1,1,1,0.5);margin: 10px 0;"></div>';
$seller = findUser($master->user_id)->name ?? '';
$sub_total = 0;

if ($master->request_to_type === 'member') {
    $request_to = findUser($master->request_to)->name ?? '';
} else {
    $request_to = findBranch($master->request_to)->name ?? '';
}
?>
<div class="print_this_form">
    <table style="width: 100%">
        <tr>
            <td style="text-align: center"><img style="width: 150px" src="{{findImg(mainBranch()->logo)}}"></td>
        </tr>
        <tr>
            <td style="text-align: center;">
                 <span>
                     <b class="name_logo">សំណើរស្នើសុំស្តុក / Purchase Order</b><br>
                </span>
            </td>
        </tr>
    </table>

    <hr width="40%">
    <table>
        <tr style="text-align: left;">
            <td style="width: 70%;">
                <table>
                    <tr class="font_12">
                        <td>{{__('administrator.date')}} </td>
                        <td>:
                            <b>{{myDate($master->purchase_date)}}</b>
                        </td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20">{{__('administrator.reference_number')}}</td>
                        <td>: {{ $master->invoice_number}}</td>
                    </tr>
                    <tr class="font_12">
                        <td class="width-20">{{__('administrator.request_by')}}</td>
                        <td>: {{ $seller }}</td>
                    </tr>
                    @if($request_to)
                        <tr class="font_12">
                            <td class="width-20">{{__('administrator.request_to')}}</td>
                            <td>: {{ $request_to }}</td>
                        </tr>
                    @endif
                </table>
            </td>
            @if($master->payment_method)
                <td>
                    <table>
                        <tr class="font_12">
                            <td>{{__('administrator.payment_method')}}</td>
                            <td> :
                                {{\App\Model\Accounting\AccountChartModel::find($master->payment_method)->acc_namekh}}
                            </td>
                        </tr>
                    </table>
                </td>
            @endif
        </tr>
    </table>
    <table class="table m-top-30 " style="border-top: 1px solid #ddd;margin-top: 15px">
        <thead>
        <tr>
            <th class="text-left">#</th>
            <th class="text-left">ឈ្មោះ</th>
            <th class="text-left">តម្លៃ</th>
            <th class="text-left">បរិមាណ</th>
            @if($master->request_to)
                <th>ចំនួនទទួល</th>
                <th>ចំនួនផ្ញើរ</th>
            @endif
            <th>តម្លៃសរុប</th>
        </tr>
        </thead>
        <tbody>
        @foreach($master->detail as $key=>$row)
            @php
                $product_unit = \App\Model\ProductUnitModel::find($row->product_unit_id);
                $product = null;
                if($product_unit){
                     $product = getProductById($product_unit->product_id);
                      $product = $product?$product->product_name:'';
                }
                $total = $row->qty*$row->cost;
                $sub_total+=$total;
                $unit = $product_unit->unit->unit??'';
            @endphp
            <tr>
                <td>{{$key+1}}</td>
                <td>{{ $product}} | {{$product_unit->item_code}}</td>
                <td>{{$row->cost}}$</td>
                <td>{{$row->qty.' '.$unit}}</td>
                @if($master->request_to)
                    <td>{{$row->deliver_qty.' '.$unit}}</td>
                    <td>{{($row->store_qty?:0).' '.$unit}}</td>
                @endif
                <td>${{$total}}</td>
            </tr>
        @endforeach
        @php
            $total_row = 10;
            $total_data = $master->detail->count();
            $left_row = $total_row-$total_data;
        @endphp
        @if($total_row>$total_data)
            @for ($i=0;$i<$left_row; $i++)
                <tr>
                    <td>{{ $key += 1}}</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    @if($master->request_to)
                        <td></td>
                        <td></td>
                    @endif
                </tr>
            @endfor
        @endif
        </tbody>
        <?php
        $g_total = $master->grand_total;
        $col = 3;
        $grand_total = $master->grand_total;
        $g_kh = currencyExchange() * $grand_total;
        $paid = ($master->paid_kh / currencyExchange()) + ($master->paid_usd);
        $owe = $grand_total - $paid;
        $change = $paid - $grand_total;
        if ($master->request_to) {
            $col += 2;
        }
        ?>
        <tfoot>
        <tr class="">
            <td colspan="{{$col}}" rowspan="5" class="text-left" style="position: relative;border:none!important;">

                @if($master->delivery_to_member)
                    <h4 class="text-left"><u>{{__('administrator.delivery_info')}}</u></h4>
                    <table class="no-border" style="margin-top: 10px">
                        @php
                            $member = findUser($master->delivery_to_member);
                            $province = findProvince($member->province_id)->name_kh??'';
                            $district = findDistrict($member->district_id)->name_kh??'';
                            $commune = findCommune($member->commune_id)->name_kh??'';
                            $village = findCommune($member->village_id)->name_kh??'';
                            $address = $province.' '.$district.' '.$commune.' '.$village.' , '.$member->street.' , '.$member->house;
                        @endphp

                        @if($member)
                            <tr>
                                <td>
                                    {{__('administrator.receiver_name')}}
                                </td>
                                <td class="text-left">: {{$member->name }}</td>
                            </tr>
                            @if($member->phone)
                                <tr>
                                    <td>{{__('administrator.phone')}}</td>
                                    <td class="text-left">: {{$member->phone }}<br></td>
                                </tr>
                            @endif
                            <tr>
                                <td>{{__('administrator.address')}}</td>
                                <td class="text-left">: {{ $address}}<br></td>
                            </tr>
                        @endif
                        @if($master->description)
                            <tr>
                                <td class="text-left" width="20%">{{__('administrator.description')}}</td>
                                <td class="text-left">: {{ $master->description}}</td>
                            </tr>
                        @endif
                    </table>
                @endif

            </td>
            @if($master->discount)
                <td>{{__('administrator.subtotal')}}</td>
                <td class="text-left " style="position: relative;">{{number_format($sub_total,2)}}$</td>
            @endif
        </tr>
        @if($master->discount)
            <tr>
                <td>
                    {{__('administrator.discount')}}
                </td>
                <td class="text-left">{{$master->discount}}%
                    (${{($sub_total * $master->discount) / 100}})
                </td>
            </tr>
        @endif
        <tr>
            <td>
                {{__('administrator.grand_total')}}</td>
            <td class="text-left">${{number_format(($g_total),2)}}</td>
        </tr>
        @if($master->paid_usd)
            <tr>
                <td>{{__('administrator.paid')}}</td>
                <td class="text-left">${{number_format(($master->paid_usd),2)}}</td>
            </tr>
        @endif
        @if($master->paid_usd<$g_total)
            <tr>
                <td>{{__('administrator.owed')}}</td>
                <td class="text-left">${{number_format(($g_total-$master->paid_usd),2)}}</td>
            </tr>
        @endif
        </tfoot>
    </table>
    {{--    <hr width="40%">--}}
    {{--    <table>--}}
    {{--        <tr>--}}
    {{--            <td style="text-align: center"><b>{{mainBranch()->invoice_footer}}</b></td>--}}
    {{--        </tr>--}}
    {{--    </table>--}}
</div>
