<style>
    tbody tr td {
        vertical-align: middle !important;
    }

    .table thead {
        background: #337ab7 !important;
        color: white !important;
    }
</style>
<?php
Fun::lang();
$master = @$purchase;
$if_not_member = !ifMember();
?>
<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">{{$master?__('administrator.edit'):__('administrator.create')}} {{__('administrator.purchase')}}</h3>
            </div>
            <div class="box-body">
                <div class=" col-xs-12 col-sm-12 col-md-12">
                    <div class="row">
                        <div class="form-group col-xs-12 col-sm-12 col-md-6">
                            <label class="col-xs-12 col-sm-12 col-md-3 control-label">{{__('administrator.purchase_date')}}
                                <span class="text-danger">*</span></label>
                            <div class="col-xs-12 col-sm-12 col-md-9">
                                <input type="text" class="date_picker form-control" name="purchase_date"
                                       value="{{@$master->purchase_date?myDate($master->purchase_date):date('d-m-Y')}}">
                                {!! Form::hidden('member_po',@$member_po??$master->member_purchase_id); !!}

                            </div>
                        </div>
                        @if($if_not_member)
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label required">{{__('administrator.invoice')}}</label>
                                <div class="col-sm-9">
                                    {!! Form::text('invoice_number',null,['placeholder'=>__('administrator.invoice_number'),'class'=>'form-control']); !!}
                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label required">{{__('administrator.supplier')}}</label>
                                <div class="col-sm-9">
                                    <div class="input-group">
                                        {!! Form::select('supplier_id', $supplier ,null , ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                                        <span class="input-group-addon getHtmlForm"
                                              data-href="{{route('suppliers.create')}}?input_name=supplier_id"
                                              data-name="Create Supplier"><i
                                                    class="fa fa-plus-circle text-blue"></i></span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-xs-6">
                                <label class="col-sm-3 control-label">{{__('administrator.reference')}}</label>
                                <div class="col-sm-9">
                                    <input type="file" name="reference" class="form-control reference"
                                           placeholder="{{__('administrator.reference')}}" autocomplete="off">
                                </div>
                            </div>

                        @else
                            <div class="form-group col-xs-12 col-sm-12 col-md-6">
                                <label class="col-sm-3 control-label required">{{__('administrator.request_to')}}</label>
                                <div class="col-sm-9">
                                    {!! Form::text('supplier_name',myParent()->name ,['class' => 'form-control','readonly']) !!}
                                </div>
                            </div>
                        @endif
                        <div class="clearfix"></div>
                        <div class="form-group col-xs-6">
                            <label class="col-sm-3 control-label">{{__('administrator.description')}}</label>
                            <div class="col-sm-9">
                                    <textarea name="description" rows="2" class="form-control" placeholder="{{__('administrator.description')}}"></textarea>
                            </div>
                        </div>

                        <div class="col-xs-12 col-sm-12 col-md-12 table-responsive" style="overflow: hidden">
                            <table class="table table-hover">
                                <thead class="table-bordered">
                                <tr>
                                    <th>#</th>
                                    <th width="20%">{{__('administrator.item_name')}}
                                        <span class="text-danger">*</span></th>
                                    <th>{{__('administrator.qty')}}<span class="text-danger">*</span></th>
                                    <th>{{__('administrator.cost')}}<span class="text-danger">*</span></th>
                                    @if($if_not_member)
                                        <th width="10%">{{__('administrator.shelf')}}<span class="text-danger">*</span>
                                        </th>
                                    @endif
                                    <th>{{__('administrator.total')}}</th>
                                    <th class="text-center"><i class="fa fa-plus text-green btn btn-default"
                                                               title="Add"></i></th>
                                </tr>
                                </thead>
                                <tbody>
                                @if(@$purchase_detail)
                                    @foreach ($purchase_detail as $key=>$item)
                                        <?php
                                        $product_unit = \App\Model\ProductUnitModel::find($item->product_unit_id);
                                        $product = $product_unit->product->product_name ?? '';
                                        $product .= ' | ' . $product_unit->item_code;
                                        $units = [];

                                        if ($product_unit->unit_id)
                                            $units[$product_unit->unit->id] = $product_unit->unit->unit;

                                        if ($product_unit->sub_unit_id)
                                            $units[$product_unit->unit_child->id] = $product_unit->unit_child->unit;

                                        $total = $item->qty * $item->cost;
                                        $total -= ($total * $item->dis / 100);
                                        ?>
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td>
                                                {!! Form::select('product_unit_id[]', [$item->product_unit_id=>$product], $item->product_unit_id, ['class' => 'form-control search_product','placeholder'=>__('administrator.please_select')]) !!}
                                            </td>
                                            <td>
                                                {!! Form::text('qty[]',$item->qty, ['class' => 'form-control updateData','placeholder'=>__('administrator.qty')]) !!}
                                            </td>
                                            <td>
                                                {!! Form::text('cost[]',$item->cost, ['class' => 'form-control updateData number-only','placeholder'=>__('administrator.cost')]) !!}
                                            </td>
                                            @if($if_not_member)
                                                <td>
                                                    {!! Form::select('shelf[]', getProductShelf(), $item->shelf, ['class' => 'form-control select2','placeholder'=>__('administrator.please_select')]) !!}
                                                </td>
                                            @endif
                                            <td>
                                                {!! Form::hidden('total_hidden[]',$total) !!}
                                                <input name="total[]" value="{{$total}}" class="form-control" readonly
                                                       placeholder="{{ __('administrator.total') }}"/>
                                            </td>
                                            <td>
                                                <i class="fa fa-times text-white btn btn-danger" title="Remove"></i>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                                </tbody>
                                <tfoot>
                                @if(!$if_not_member)
                                    <tr>
                                        <td colspan="{{$if_not_member?5:4}}" class="text-right">
                                            <label>%{{__('administrator.discount')}} ({{myMemberType()->name}}):</label>
                                        </td>
                                        <td colspan="2" class="text-left">
                                            <input type="text" name="discount" readonly class="form-control"
                                                   value="{{@$master?$master->discount:myMemberType()->discount}}">
                                        </td>
                                    </tr>
                                @endif
                                <tr>
                                    <td colspan="{{$if_not_member?5:4}}" class="text-right">
                                        <label>{{__('administrator.grand_total')}}:</label>
                                    </td>
                                    <td colspan="2" class="text-left">
                                        <input name="grand_total" type="text" id="total_as_dollar" readonly
                                               class="form-control">
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php
                        $sub_method = [];
                        $bank_name = '';
                        $method = '';
                        if (@$master) {
                            if ($master->payment_method == '11001') { // if cash on hand
                                $method = $master->payment_method;
                            } else {
                                $method = '11002';
                                $bank_name = $master->payment_method;
                                $sub_method = \App\Model\Accounting\AccountChartModel::where('acctype', $method)
                                    ->where('branch_id', $master->branch_id)->pluck('acc_name', 'id');
                            }
                        }
                        ?>
                        @if($if_not_member)
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div class="form-group col-xs-6">
                                    <label class="col-sm-3 control-label required">{{__('administrator.payment_type')}}</label>
                                    <div class="col-sm-9">
                                        {!!  Form::select('payment_type', getPaymentType(), $purchase->payment_type??null, ['class' => 'payment_method form-control select2', 'placeholder' => __('administrator.please_select')]) !!}
                                    </div>
                                </div>
                                <div class="form-group col-xs-6 required_">
                                    <label class="col-sm-3 control-label ">{{__('administrator.payment_method')}}</label>
                                    <div class="col-sm-9">
                                        {!!  Form::select('payment_method', $acc_chart, $method??null, ['class' => 'payment_method form-control select2', 'placeholder' => __('administrator.please_select')]) !!}
                                    </div>
                                </div>
                                <div class="form-group col-xs-6">
                                    <label class="col-sm-3 control-label">{{__('administrator.bank_name')}}</label>
                                    <div class="col-sm-9">
                                        {!!  Form::select('sub_payment_method', $sub_method, $bank_name, ['class' => 'payment_type form-control select2', 'placeholder' => __('administrator.please_select')]) !!}
                                    </div>
                                </div>
                                <div class="form-group col-xs-6 required_">
                                    <label class="col-sm-3 control-label">{{__('administrator.paid_amount')}} ($)</label>
                                    <div class="col-sm-9">
                                        {!! Form::text('paid_usd',null,['placeholder'=>__('administrator.paid'),'class'=>'form-control']); !!}
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class=" col-xs-12  col-sm-12  col-md-12 text-right">
                            <a href="{{ route('purchases-item-approval') }}"
                               class="btn btn-warning btn-sm"> {{__('administrator.cancel')}}</a>
                            <button class="btn btn-primary btn-sm" type="submit">{{__('administrator.submit')}}</button>
                        </div>
                        <input type="hidden" name="total_as_dollar">
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            @if (!@$purchase_detail->count())
            appendData();
            @else
            totalPrice();
            @endif
        });
        $(document).on('click', '.fa-plus.text-green', function () {
            appendData();
        });
        $(document).on('click', '.fa-times', function () {
            if ($('tbody tr').length > 1) {
                $(this).closest('tr').remove();
            }
            looplength();
            totalPrice();
        });

        $(document).on('change', 'select[name="product_unit_id[]"]', function () {
            let input = $(this).closest('tr');
            let cost = input.find('input[name="cost[]"]');
            let default_shelf = input.find('select[name="shelf[]"]');
            let product_unit = $(this).val();
            if (product_unit) {
                $.get('{!! url("get-item-code-and-shelf-by-product-id") !!}', {product_unit}, function (data) {
                    cost.val(data.cost);
                    default_shelf.val(data.default_shelf).change();
                });
            }

        });
        $(document).on('keyup', '.updateData', function () {
            let e = $(this).closest('tr');

            function input(this_input, if_get_val = true) {
                let $input = e.find('input[name="' + this_input + '[]"]');
                if (if_get_val) {
                    return $input.val() ? parseFloat($input.val()) : 0;
                } else {
                    return $input;
                }
            }

            let qty = input('qty');
            let cost = input('cost');
            let dis = input('dis');
            let total = qty * cost;
            total = total - (total * (dis / 100));

            input('total', false).val(addCommas(total.toFixed(2)) + 'ដុល្លា');
            input('total_hidden', false).val(total);
            totalPrice();
        });


        function appendData(id = '') {
            var row = `
            <tr>
                <td></td>
            <td>
                    {!! Form::select('product_unit_id[]', [], null, ['class' => 'form-control search_product','placeholder'=>__('administrator.please_select')]) !!}
            </td>
            <td>
                <input name="qty[]" class="form-control numeric updateData" autocomplete="off" placeholder="{{ __('administrator.qty') }}"/>
                </td>
            <td>
                <input name="cost[]" class="form-control numeric updateData" autocomplete="off" placeholder="{{ __('administrator.cost') }}"/>
                </td>
                @if($if_not_member)
            <td>
            {!! Form::select('shelf[]', getProductShelf(), null, ['class' => 'form-control select2','placeholder'=>__('administrator.please_select')]) !!}
            </td>
            @endif
            <td>
                <input type="hidden" name="total_hidden[]" value="0"/>
                <input name="total[]" class="form-control numeric" autocomplete="off" readonly placeholder="{{ __('administrator.total') }}"/>
                </td>
            <td>
                <i class="fa fa-times text-white btn btn-danger" title="Remove"></i>
            </td>
        </tr>
`;
            $('tbody').append(row).find('tr:last-child select[name="product[]"]').val(id).trigger('change');
            looplength();
            $('tbody').find('tr:last .select2').select2();
            search_product();
            date_picker();
        }

        function looplength() {
            $('table  tbody   tr  td:first-child').each(function (i) {
                $(this).text(i + 1);
            });
        }

        function totalPrice() {
            let total = 0;
            let total_discount = $('input[name="discount"]').val();
            total_discount = total_discount ? parseFloat(total_discount) : 0;
            $('input[name="total_hidden[]"]').each(function () {
                total += parseFloat($(this).val()) ? parseFloat($(this).val()) : 0;
            });
            total = total - (total * (total_discount / 100));
            $('#total_as_dollar').val((parseFloat(total).toFixed(2)) + 'ដុល្លា');
            $('input[name="total_as_dollar"]').val(parseFloat(total).toFixed(2));
        }

    </script>
    @include('js-function.payment-method')
@endsection
