@extends(branchMenu()) @section('content')
    <?php Fun::lang()?>
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <fieldset>
            <legend>{{__('administrator.adjustment')}}</legend>
            {!! Form::open(array('route' => 'adjustment.store','method'=>'POST','class'=>'jform')) !!}
            <div class="col-sm-12 col-xs-12">
            <div class="col-md-offset-2 col-lg-offset-2 col-sm-12 col-xs-12 col-md-6 col-lg-6">
                <div class="col-sm-12 col-xs-12 col-lg-12 col-md-12 form-group">
                    <div class="col-sm-4 col-xs-12 col-lg-3 col-md-3">
                        {{__('administrator.date')}}
                    </div>
                    <div class="col-sm-8 col-xs-12 col-lg-9 col-md-9">
                        {!! Form::text('adjustment_date',date('d-m-Y'), ['class' => 'form-control date_picker']) !!}
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 col-lg-12 col-md-12 form-group">
                    <div class="col-sm-4 col-xs-12 col-lg-3 col-md-3">
                        {{__('administrator.user')}}
                    </div>
                    <div class="col-sm-8 col-xs-12 col-lg-9 col-md-9">
                        {!! Form::text('user',Auth::user()->name, ['class' => 'form-control','readonly']) !!}
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 col-lg-12 col-md-12 form-group">
                    <div class="col-sm-4 col-xs-12 col-lg-3 col-md-3">
                        {{__('administrator.note')}}
                    </div>
                    <div class="col-sm-8 col-xs-12 col-lg-9 col-md-9">
                        {!! Form::textarea('note',null, ['class' => 'form-control','rows'=>'3']) !!}
                    </div>
                </div>
            </div>
            </div>
            <div class="col-sm-12 col-xs-12">
                <table class="table-responsive table table-striped">
                    <thead>
                    <th>#</th>
                    <th width="20%">{{__('administrator.item')}} *</th>
                    <th>{{__('administrator.shelf')}}</th>
                    <th>{{__('administrator.stock')}}</th>
                    <th>{{__('administrator.operator')}}</th>
                    <th>{{__('administrator.qty')}} *</th>
                    <th>{{__('administrator.balance')}}</th>
                    <th><span class="btn btn-info fa fa-plus" onclick="addRow()"></span></th>
                    </thead>
                    <tbody class="tbody"></tbody>
                </table>
            </div>
            <div class="col-sm-12 text-right">
                @include('component.form-btn')
            </div>
            {!! Form::close() !!}
        </fieldset>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        let count = 1;
        $(document).ready(function () {
            addRow();
            $(document).on('change', '.search_product,.shelf', function () {
                changeProUnit($(this));
            });

            $(document).on('change', 'select[name="operator[]"], .stock_qty', function () {
                operator($(this));
            });
            $(document).on('keyup', 'input[name="qty[]"]', function () {
                let _this = $(this);
                operator(_this);
            });
        });

        function operator(_this) {
            let qty = _this.closest('tr').find('input[name="qty[]"]').val();
            let stock_qty = _this.closest('tr').find('.stock_qty').val();
            let operator = _this.closest('tr').find('select[name="operator[]"]').val();
            qty = qty ? parseFloat(qty) : 0;
            stock_qty = stock_qty ? parseFloat(stock_qty) : 0;
            let balance = eval(stock_qty + operator + qty);
            if (balance < 0) {
                balance = stock_qty;
                _this.closest('tr').find('input[name="qty[]"]').val(stock_qty);
            }
            _this.closest('tr').find('input[name="balance[]"]').val(balance)
        }

        function changeProUnit(_this) {
            let product_unit_id = _this.closest('tr').find('.search_product').val();
            let shelf = _this.closest('tr').find('.shelf').val();
            $.ajax({
                url: '{{route('adjustment.create')}}',
                dataType: 'json',
                method: 'get',
                data: {
                    product_unit_id, shelf
                },
                success: function (data) {
                    _this.closest('tr').find('.stock_qty').val(data.qty);
                },
                error(xhr) {
                    alertErrorFormController(xhr);
                }
            });
        }

        function addRow() {
            let html = `
                <tr>
                <td>${count++}</td>
                <td>
                        {!! Form::select('product_unit_id[]',[],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_product']) !!}
                </td>
                <td>
                    {!! Form::select('shelf[]',getProductShelf(),null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control shelf select2']) !!}
                </td>
                <td>
                    {!! Form::text('stock[]',0, ['placeholder'=>__('administrator.stock'),'class' => 'form-control stock_qty','readonly']) !!}
                </td>
                <td>
                    {!! Form::select('operator[]',['+'=>__('administrator.+'),'-'=>__('administrator.-')],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                </td>
                <td>
                    {!! Form::text('qty[]',null, ['placeholder'=>__('administrator.qty'),'class' => 'form-control number-only']) !!}
                </td>
                <td>
                    {!! Form::text('balance[]',0, ['placeholder'=>__('administrator.balance'),'class' => 'form-control','readonly']) !!}
                </td>
                <td>
                <span class="btn btn-danger fa fa-times" onclick="$(this).closest('tr').remove()"></span>
                </td>
                </tr>
`;
            $('.tbody').append(html).find('tr:last .select2').select2();
            search_product();
        }
    </script>
@endsection
