@extends(branchMenu())

@section('content')

    <?php Fun::lang();


    ?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <h3>{{__('administrator.create_role')}}</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="form-wrapper">
                        {!! Form::open(array('route' => 'roles.store','method'=>'POST','id'=>'form_validate')) !!}
                        <div class="form-group col-sm-4 col-xs-12">
                            <label class="required" for="name">{{__('administrator.title')}}</label>
                            {!! Form::text('name', null, array('placeholder' => 'Title','class' => 'form-control','required')) !!}
                            <span class="focus-border"></span>
                        </div>
                        <div class="form-group col-sm-12 col-xs-12">
                            <strong>{{__('administrator.permission')}} <span class="required"></span></strong>
                        </div>
                        <div class="col-sm-12">
                            <div class="vertical-tabs">
                                <ul class="nav nav-tabs" role="tablist">
                                    @foreach($group_permission as $key=>$row)
                                        <li class="nav-item {{$key===0?'active':''}}">
                                            <a class="nav-link  {{$key===0?'active':''}}" data-toggle="tab" href="#page{{$key}}" role="tab"
                                               aria-controls="home">{{$row->group_name}}</a>
                                        </li>
                                    @endforeach
                                </ul>
                                <div class="tab-content">
                                    @foreach($group_permission as $key=>$row)
                                        <div class="tab-pane {{$key==0?'active':''}}" id="page{{$key}}" role="tabpanel">
                                            <div class="sv-tab-panel app-height">
                                                @php
                                                    $items = \Spatie\Permission\Models\Permission::where('group_name',$row->group_name)->get();
                                                    $string = preg_replace('/\s+/', '', $row->group_name);
                                                @endphp
                                                <div class="col-sm-12">
                                                    <label>
                                                        {{ Form::checkbox('check_all_area1[]',  $string, false, array('class' =>'check_all' )) }}
                                                        {{__('administrator.check_all')}}
                                                    </label>
                                                </div>
                                                @php
                                                    $permission = \Spatie\Permission\Models\Permission::where('group_name',$row->group_name)->get();
                                                @endphp
                                                @foreach($permission as $value)
                                                    <div class="col-sm-3">
                                                        <label>
                                                            {{ Form::checkbox('permission[]', $value->id, false, array('class' =>$string)) }}
                                                            {{ $value->name }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <br>&nbsp;
                        <br>&nbsp;
                        <br>&nbsp;
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group text-right">
                            <button type="button" onClick="history.go(-1)" class=" btn btn-warning  "><span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            <button type="submit" class=" btn bg-primary"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>

        </div>
    </div>

@endsection
@section('script')
    <script>
        $(".check_all").change(function () {
            let this_ = $(this);
            let check = $(this).prop("checked");
            let val = '.' + this_.val();
            $(val + `:checkbox`).prop('checked', check);
        });

    </script>
@endsection

