@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>
    <div class="container-fluid">
        <div class="">
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.product')}} </h3>
                            </div>
                            <div class="pull-right">
                                @can('Item Create')
                                    <a href="{{route('product.create')}}" class="btn btn-primary fa fa-plus set_menu_name"></a>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="datatable_products" class="table  table-striped table-hover">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.image')}}</th>
                        <th>{{__('administrator.item_name')}}</th>
                        <th>{{__('administrator.brands')}}</th>
                        <th>{{__('administrator.category')}}</th>
                        <th>{{__('administrator.description')}}</th>
                        <th>{{__('administrator.created_at')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        let tb =  $('#datatable_products');
        $(document).ready(function () {
            getTable();
        });
        function getTable(){
            tb.DataTable().destroy();
            tb.DataTable({
                ordering: true,
                serverSide: true,
                lengthMenu: tbLength,
                ajax: "{{ route('product.index') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false, "orderable": "false"},
                        {data: 'image', name: 'images', searchable: false},
                        {data: 'product_name', 'name': 'nso007_products.product_name'},
                        {data: 'brand_id', 'name': 'nso007_products.brand', searchable: false},
                        {data: 'category_id', searchable: false},
                        {data: 'description'},
                        {data: 'created_at', 'searchable': false},
                        {data: 'action'},
                    ],
            });
        }
    </script>
@endsection
