@extends(branchMenu())
@section('content')
    <?php Fun::lang()?>

    <div class="page box box-primary">
        <div class="container-fluid">
            <div class="wrapper-table">
                <div class="row">
                    <div class="form-group col-sm-12 col-xs-12">
                        <br>
                        <h4>{{__('administrator.upcoming_customer_care')}}</h4>
                        <br>
                    </div>
                    <form class="form_data">
                        <div class="form-group col-sm-3 col-md-3 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="" for="name">{{__('administrator.bach_number')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::text('bach_number',null, array('placeholder' => __('administrator.bach_number'),'class' => 'form-control')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-3 col-md-3 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="" for="name">{{__('administrator.user')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('agent_id',getAllSomeUser(),null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2')) !!}
                            </div>
                        </div>
                        <div class="form-group  col-sm-3 col-md-3 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="" for="name">{{__('administrator.customer')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('customer',[],null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control search_customer']) !!}
                            </div>
                        </div>
                        <div class="form-group  col-sm-3 col-md-3 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="" for="name">{{__('administrator.customer_status')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('customer_status',$status,null, ['placeholder'=>__('administrator.please_select'),'class' => 'form-control select2']) !!}
                            </div>
                        </div>
                        <div class="form-group  col-sm-3 col-md-3 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="" for="name">{{__('administrator.from_date')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::text('from_date',null, array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker')) !!}
                            </div>
                        </div>
                        <div class="form-group  col-sm-3 col-md-3 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="" for="name">{{__('administrator.to_date')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::text('to_date',null, array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker')) !!}
                            </div>
                        </div>
                        <div class="form-group  col-sm-3 col-md-3 col-xs-12">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="" for="name">{{__('administrator.reason')}}</label>
                            </div>
                            <div class="col-sm-9 col-xs-12">
                                {!! Form::select('reason_id', pluckReason(),null, ['class' => 'form-control select2','placeholder'=>__('administrator.please_select')]) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-12 col-md-12 col-xs-12 text-right ">
                            <button type="button" class="btn btn-info btn_search">{{__('administrator.search')}}</button>
                        </div>
                    </form>

                </div>

                <div class="">
                    <div class="tableScroll table-responsive">
                        <table id="data_table" class="table table-striped table-hover ">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th width="8%">{{__('administrator.date')}}</th>
                                <th width="13%">{{__('administrator.user')}}</th>
                                <th>{{__('administrator.bach_number')}}</th>
                                <th>{{__('administrator.customer_name')}}</th>
                                <th>{{__('administrator.customer_phone')}}</th>
                                <th>{{__('administrator.sex')}}</th>
                                <th>{{__('administrator.age')}}</th>
                                <th>{{__('administrator.type_of_illness')}}</th>
                                <th>{{__('administrator.doctor')}}</th>
                                <th>{{__('administrator.status')}}</th>
                                <th>{{__('administrator.reason')}}</th>
                                <th width="25%">{{__('administrator.note')}}</th>
                                <th>{{__('administrator.action')}}</th>
                            </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $('#data_table').on('click', '.edit_customer', function () {
                let width = $(this).data('width');
                let title = $(this).attr('title');
                getHtmlForm($(this).data('href') + '?member_type={{request()->segment(2)}}',title, width?width:'1000px', '{{__('administrator.update')}}');
            });
        })
        function getTable() {
            let data = $('.form_data').serialize();
            $('#data_table').DataTable().destroy();
            $('#data_table').DataTable({
                ordering: false,
                processing: false,
                serverSide: true,
                autoWidth: false,
                searching: false,
                lengthMenu:  tbLength,
                ajax: {
                    url: '{!! route("upcoming-customer-care") !!}?' + data,
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'next_meeting'},
                        {data: 'user_created'},
                        {data: 'bach_number'},
                        {data: 'customer_name'},
                        {data: 'customer_phone'},
                        {data: 'sex'},
                        {data: 'age'},
                        {data: 'illness'},
                        {data: 'reviewed_by'},
                        {data: 'customer_status_id'},
                        {data: 'reason_id'},
                        {data: 'note_next_meeting'},
                        {data: 'action'},

                    ],
                "initComplete": function (settings, json) {

                }
            });
        }

        getTable();
        $('.btn_search').on('click', function () {
            getTable()
        });

    </script>
@endsection






