@extends('layouts.app')
@section('content')
    <?php Fun::lang()?>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.currency')}} </h3>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="{{route('currency.create')}}"
                               class="btn bg-olive btn-flat margin">{{__('administrator.add_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped table-hover  ">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('administrator.name')}}</th>
                    <th>{{__('administrator.symbol')}}</th>
                    <th>{{__('administrator.code')}}</th>
                    <th>{{__('administrator.rate')}}</th>
                    <th>{{ __('administrator.action') }}</th>
                </tr>
                </thead>
                <tbody>
                    @foreach($currency as $key => $row)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$row->name}}</td>
                            <td>{{$row->symbol}}</td>
                            <td>{{$row->code}}</td>
                            <td>{{$row->rate}}</td>
                            <td>
                                <a href="{{route('currency.edit',$row->id)}}" class="button_warning"><span class="fa fa-pencil-square-o"></span></a>
                                <a herf="#" class="{{$row->default==1?'button_info disabled':'btn bg-olive btn-flat margin'}}"

                                @if($row->default==0) onclick="set_default('{{$row->id}}')" @endif>
                                    @if($row->default==1)
                                        {{__('administrator.default')}}
                                    @else
                                        {{__('administrator.set')}}
                                    @endif
                                </a>
                           </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable();
        });
        function set_default(id) {
            $.confirm({
                title: '<strong style="color:darkcyan;">{{__('administrator.change_status')}}</strong>',
                content: "<b>Want to Change default currency? "
                + " </b>Then Click OK",

                buttons: {
                    '{{__('administrator.cancel')}}': {
                        btnClass: 'btn-red',
                        action: function () {

                        }

                    },
                    '{{__('administrator.ok')}}':{
                        btnClass: 'btn-blue',
                        action: function () {
                            $.ajax({
                                type: "GET",
                                dataType: "json",
                                url: '{{route("currency-changeStatus")}}',
                                data: {'id': id},
                                success: function (data) {
                                    location.reload();
                                }
                            });
                        }
                    }
                }
            });
        }
    </script>
@endsection
