@extends(branchMenu())
@section('content')
<link rel="stylesheet" href="{{ asset('assets/js/switch_button.css')}}">
<style>
    .image-list-small {
        font-family: Arial, Helvetica, sans-serif;
        margin: 0 auto;
        text-align: left;
        /* max-width: 640px; */
        padding: 0;
    }

    .image-list-small li {
        display: inline-block;
        width: 130px;
        margin: 14px 3px;
    }

        /* Photo */

    .image-list-small li > a {
        display: block;
        text-decoration: none;
        background-size: cover;
        background-repeat: no-repeat;
        height: 137px;
        margin: 0;
        padding: 0;
        border: 4px solid #ffffff;
        outline: 1px solid #d0d0d0;
        box-shadow: 0 2px 1px #ddd;
        }

    .image-list-small .details {
        margin-top: 3px;
        background: #3c8dbc;
    }

        /* Title */

    .image-list-small .details h3 {
        display: block;
        font-size: 12px;
        margin: 0 0 3px 0;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .image-list-small .details h3 a {
        color: white;
        text-decoration: none;
    }

    .image-list-small .details .image-author {
        display: block;
        color: white;
        font-size: 11px;
        font-weight: normal;
        margin: 0;
    }

    /* detail */
    .details{
        text-align: center;
    }

    .item-list-tb thead th{
        vertical-align: middle !important;
    }
    .button.raised{
        transition: box-shadow 0.2s cubic-bezier(0.4, 0, 0.2, 1);
        transition-delay: 0.2s;
        box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
    }
    .button {
        display: inline-block;
        position: relative;
        width: 100px;
        height: 27px;
        line-height: 28px;
        border-radius: 2px;
        font-size: 0.9em;
        background-color: #fff;
        color: #646464;
        margin: 5px;
    }
    .switch-wrapper {
        display: inline-block;
        position: relative;
        top: 3px;
    }

    .select2{
        width: 100% !important;
    }
</style>
<?php Fun::lang() ?>
<div class="row">
    <div class="col-xs-12">
        <div class="box box-primary">
            <div class="box-header with-border">
              <h3 class="box-title">{{__('administrator.new_request')}}</h3>
            </div>
            {!! Form::open(array('route' => ['seller-request-product.update', $id], 'method'=>'PUT', 'enctype'=>'multipart/form-data', 'class'=>'form-horizontal')) !!}
                <div class="box-body">
                    <div class="col-xs-12">
                        <div class="row">
                            <div class="col-xs-4">
                                {{-- <div class="col-xs-12">
                                    {!! Form::text('barcode', null, array('placeholder' => __('administrator.barcode') ,'class' => 'form-control typeahead', "autocomplete" => "on")) !!}
                                </div> --}}
                                <div class="col-xs-12 image-list">
                                    @include('administrator.SellerRequestProduct.product',['stock_item'=>$stock_item])
                                </div>
                            </div>
                            <div class="col-xs-8" style="background: #8080801a;">
                                <div class="check-bill">
                                    <div class="row" style="height:500px; overflow-x:auto;">
                                        <div class="check-bill-table">
                                            <div class="product-view-table">
                                                <div class="parent-box-pos">
                                                    <table class="table table-hover item-list-tb">
                                                        <thead class="text-center" style="background: #3c8dbc; color: white;">
                                                            <tr style="height: 47px;">
                                                                <th width="2%">#</th>
                                                                <th valign="middle" width="15%">{{__('administrator.item_name')}}</th>
                                                                <th width="10%">{{__('administrator.qty')}} <span class="red">*</span></th>
                                                                <th width="10%">{{__('administrator.unit')}}<span class="red">*</span></th>
                                                                <th width="10%">{{__('administrator.price')}}<span class="red">*</span></th>
                                                                <th width="10%">{{__('administrator.discount')}}</th>
                                                                <th width="10%">{{__('administrator.total')}}</th>
                                                                <th width="3%">{{__('administrator.action')}}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="append_product">

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <hr style="border-top: 1px solid #337ab73d;">
                                    <div class="col-xs-7">
                                        <div class="form-group row">
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.total')}} ( រៀល ):</label>
                                                <input type="text" class="sub_total_kh form-control input-sm"
                                                    value="{{number_format(0,2)}} ៛"
                                                    readonly="">
                                            </div>
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.total')}} ( ដុល្លា ):</label>
                                                <input type="text" name="subtotal" class="sub_total_usd form-control input-sm"
                                                    value="{{number_format(0,2)}} $"
                                                    readonly="">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.grand_total')}} ( រៀល ):</label>
                                                <input type="text" class="g_total_kh form-control input-sm" value="{{number_format(0,2)}} ៛"
                                                    readonly="">
                                            </div>
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.grand_total')}} ( ដុល្លា ):</label>
                                                <input type="text" class="g_total_usd form-control input-sm"
                                                    value="{{number_format(0,2)}} $" readonly="">
                                                <input type="hidden" class="g_total_usd_hidden" name="g_total_usd_hidden"
                                                    value="0">
                                            </div>
                                        </div>
                                        <div class="form-group row hide">
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.paid')}} ( រៀល ) :</label>
                                                <input type="text"
                                                    class="form-control input-sm numeric border bg-transparent paid_kh"
                                                    name="paid_kh" value="" placeholder="0.00">
                                            </div>
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.paid')}} ( ដុល្លា ):</label>
                                                <input type="text"
                                                    class="form-control input-sm numeric border bg-transparent paid_usd"
                                                    name="paid_usd" ​​ placeholder="0.00" value="">
                                            </div>
                                        </div>
                                        <div class="form-group row hide">
                                            <div class="col-xs-6">
                                                <label class="change">{{__('administrator.delivery_fee')}} ( រៀល )</label>
                                                <input data-status="0" type="text"
                                                    class="bg-transparent border-none form-control numeric"
                                                    name="deliery-kh" placeholder="0.00៛">
                                            </div>
                                            <div class="col-xs-6">
                                                <label class="change">{{__('administrator.delivery_fee')}} ( ដុល្លា )</label>
                                                <input data-status="0" type="text"
                                                    class="bg-transparent border-none form-control numeric"
                                                    name="deliery-usd" placeholder="0.00$">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-xs-6">
                                                <label class="change">{{__('administrator.owed_amount')}} ( រៀល )</label>
                                                <input data-status="0" type="text"
                                                    class="bg-transparent border-none form-control input-sm"
                                                    name="change-amount-kh" readonly placeholder="0.00៛">
                                            </div>
                                            <div class="col-xs-6">
                                                <label class="change">{{__('administrator.owed_amount')}} ( ដុល្លា )</label>
                                                <input data-status="0" type="text"
                                                    class="bg-transparent border-none form-control input-sm"
                                                    name="change-amount-usd" readonly placeholder="0.00$">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-xs-6">
                                                <label class="change">{{__('administrator.change')}} ( រៀល )</label>
                                                <input data-status="0" type="text"
                                                    class="bg-transparent border-none form-control input-sm"
                                                    name="change-kh" readonly placeholder="0.00៛">
                                            </div>
                                            <div class="col-xs-6">
                                                <label class="change">{{__('administrator.change')}} ( ដុល្លា )</label>
                                                <input data-status="0" type="text"
                                                    class="bg-transparent border-none form-control input-sm"
                                                    name="change-usd" readonly placeholder="0.00$">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-5">
                                        <div class="form-group row">
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.customer')}}<span class="text-danger">*</span>:</label>
                                                {!! Form::select('customer', getCustomer(), $customer_id, ['class' => 'type form-control select2', 'required' ,'placeholder' => '-- '.__("administrator.select").''.__("administrator.customer").' --'])  !!}
                                            </div>
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.request_to_branch')}}<span class="text-danger">*</span>:</label>
                                                {!! Form::select('member', $branches, $brand_id, ['class' => 'type form-control select2', 'required', 'placeholder' => '-- '.__("administrator.select").''.__("administrator.branch").' --'])  !!}
                                            </div>
                                        </div>
                                        {{-- <div class="form-group row">
                                            <div class="col-xs-12">
                                                <label>{{__('administrator.discount')}} (%):</label>
                                                {!! Form::text('discount',null, array('placeholder' =>__('administrator.discount'),'class' => 'form-control input-sm number-only total-discount')) !!}
                                            </div>
                                        </div> --}}
                                        <div class="form-group row hide">
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.payment_type')}}<span class="text-danger">*</span>:</label>
                                                {!! Form::select('payment_type', getPaymentType(), '', array('placeholder' =>__('administrator.payment_type'),'class' => 'form-control input-sm')) !!}
                                            </div>
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.reference')}} :</label>
                                                <input type="file" name="reference" class="form-control">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.date')}} :</label>
                                                <input type="text" value="{{date('d-m-Y')}}"
                                                    class="date_picker form-control input-sm" name="date">
                                            </div>
                                            <div class="col-xs-6">
                                                <label>{{__('administrator.cashier')}} :</label>
                                                <input type="text" name="cashier_name" class="form-control input-sm" readonly=""
                                                    value="{{Auth::user()->name}}">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-xs-12">
                                                <label>{{__('administrator.note')}} :</label>
                                                <div class="switch-wrapper pull-right">
                                                    <input type="checkbox" class="checkPaid" value="1" name="full_paid">
                                                </div>
                                                <textarea name="note" class="form-control" rows="4" placeholder="Note"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 text-right">
                                        <button type="submit" class="btn btn-info btn-sm">{{__('administrator.submit')}}</button>
                                        <button type="button" class="btn btn-danger btn-sm pos_clothes_remove_session">{{__('administrator.remove')}}</button>
                                        <button type="button" class="btn btn-warning btn-sm" onclick="history.back(1)">{{__('administrator.back')}}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            {!! Form::close() !!}
          </div>
    </div>
</div>
@endsection
@section('script')
<script src="{{ asset('assets/js/switch_button.js') }}"></script>
<script type="text/javascript">
    exchange = '{!! currencyExchange() !!}';
    $(document).ready(function(){
        $(".checkPaid").switchButton({
            on_label: 'Full Paid',
            off_label: ''
        });
        $(".checkBox").switchButton({
            on_label: 'Wholesale',
            off_label: 'Retail'
        });
        $('.checkBox').change(function(){
            if($(this).prop('checked')){
                location.href = '{!! route("wholesale.create") !!}';
            }else{
                location.href = '{!! route("pos-retail.create") !!}';
            };
        });
        getProduct();
    });

    $(document).on('click', '.product_unit', function(){
        var id = $(this).data('id');
        var url = $(this).data('url');
        $.get(url+"?type=id", function(data){
            if(data.message == "warning"){
                 toastDemo(data.data,'{{__('administrator.warning')}}');
            }else{
                getProduct();
            }
        });
    });

    function getProduct(){
        var search = $('input[name="search"]').val();
        $.ajax({
            type: 'GET',
            url:'{!! url("seller-request-product-get-product") !!}',
            data:{
                search
            },
            sync: false,
            success :function(data){
                var data_html = data.html;
                $('#append_product').empty();
                $('#append_product').append(data_html);
                total_price();
                $('select').select2();
            }
        });
    }

    $(document).on('click', '.fa.fa-times.text-red', function(){
        var id = $(this).closest('tr').find('input[name="id[]"]').val();
        $.get('{!! url("seller-request-product-delete-product/'+id+'") !!}', function(data){
            getProduct();
        });
    });

    $(document).on('blur', '.updateProduct', function(){
        updateProduct(this);
    });
    $(document).on('change', 'select[name="unit[]"]', function(){
        updateProduct(this);
    });

    function updateProduct(e)
    {
        var id = $(e).closest('tr').find('input[name="id[]"]').val();
        var qty = $(e).closest('tr').find('input[name="qty[]"]').val();
        var cost = $(e).closest('tr').find('input[name="cost[]"]').val();
        var discount = $(e).closest('tr').find('input[name="discount[]"]').val();
        var unit = $(e).closest('tr').find('[name="unit[]"]').val();
        $.get('{!! url("seller-request-product-update-product/'+id+'") !!}',
            {
                id,
                qty,
                cost,
                discount,
                unit
            },
            function(data){
            if(data.data == ''){
                showWarningToast('{{__('administrator.Product_is_out_of_stock')}}.');
            }
            getProduct();
        });
    }

    $(document).on('click', '.pos_clothes_remove_session', function(){
        if($('#append_product tr').length > 0){
            $.confirm({
                title: '{{__('administrator.confirm')}}',
                content: '{{__('administrator.are_you_sure')}}?',
                buttons: {
                    {{__('administrator.confirm')}}: {
                        btnClass: 'btn-red',
                        action : function () {
                            $.get('{!! url("seller-request-product-delete-product") !!}', function(){
                                getProduct();
                                showSuccessToast('Product remove successfully.');
                            });
                        }
                    },
                    {{__('administrator.cancel')}}: function () {
                    }
                }
            });
        }
    });

    $(document).ready(function () {
        $(document).on('click', 'a.page-link', function (e) {
            e.preventDefault();
            let url = $(this).attr('href');
            $.get(url, function(data){
                $('.image-list').html(data.html);
            });
        });
    });

    $(document).on('blur', 'input[name="paid_kh"], input[name="paid_usd"]', function(){
        getOwe();
        getChange();
    });

    function getOwe(){
        var paid_riel = $('input[name="paid_kh"]').val()?$('input[name="paid_kh"]').val():0;
        var paid_usd = $('input[name="paid_usd"]').val()?$('input[name="paid_usd"]').val():0;
        var total_paid = (parseFloat(paid_riel)?parseFloat(paid_riel)/exchange:0) + parseFloat(paid_usd);
        var total = grand_total();
        if(total > total_paid){
            var owe = total - total_paid;
            $('input[name="change-amount-usd"]').val(addCommas(owe.toFixed(2))+'$');
            $('input[name="change-amount-kh"]').val(addCommas((owe*exchange).toFixed(2))+'៛');
        }else{
            $('input[name="change-amount-usd"]').val(addCommas(0.00)+'$');
            $('input[name="change-amount-kh"]').val(addCommas(0.00)+'៛');
        }
    }

    function getChange(){
        var paid_riel = $('input[name="paid_kh"]').val()?$('input[name="paid_kh"]').val():0;
        var paid_usd = $('input[name="paid_usd"]').val()?$('input[name="paid_usd"]').val():0;
        var total_paid = (parseFloat(paid_riel)?parseFloat(paid_riel)/exchange:0) + parseFloat(paid_usd);
        var total = grand_total();
        if(total < total_paid){
            var owe = total_paid - total;
            $('input[name="change-usd"]').val(addCommas(owe.toFixed(2))+'$');
            $('input[name="change-kh"]').val(addCommas((owe*exchange).toFixed(2))+'៛');
        }else{
            $('input[name="change-usd"]').val(addCommas(0.00)+'$');
            $('input[name="change-kh"]').val(addCommas(0.00)+'៛');
        }
    }

    function grand_total(){
        // var dis = $('.total-discount').val();
        var dis = 0;
        var total = getTotal();
        $('.g_total_usd').val(addCommas((total - total*(dis/100)).toFixed(2))+'$');
        $('.g_total_kh').val(addCommas(((total - total*(dis/100))*exchange).toFixed(2))+'៛');
        return (total - total*(dis/100));
    }

    function getTotal(){
        var total_discount = $('input[name="discount"]').val();
        var total = 0;
        $('input[name="grand_total_usd[]"]').each(function(){
            total += parseFloat($(this).val());

        });
        return total;
    }

    function total_price(){
        var total = getTotal();
        $('input[name="subtotal"]').val(addCommas(total.toFixed(2))+'$');
        $('.sub_total_kh').val(addCommas((total*parseFloat(exchange)).toFixed(2))+'៛');
        grand_total();
        getOwe();
        getChange();
    }
</script>
@endsection
