<?php

namespace App\Providers;

use App\CurrencyModel;
use App\Model\Accounting\AccountChartModel;
use App\Model\CustomeCaseModel;
use App\Model\ItemRequestModel;
use App\Model\nest_bird_target\StaffTargetModel;
use App\Model\SaleModel;
use App\Observers\AccChartObserver;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Auth;
use View;
use DB;

class AppServiceProvider extends ServiceProvider
{

    public function register()
    {
        //
    }

    public function boot()
    {
//        AccountChartModel::observe(AccChartObserver::class);

        Schema::defaultStringLength(191);
        View::composer('layouts.app', function($view)
        {
            $sale_request = 0;
            $purchase_order = 0;

            $view->with(compact('sale_request','purchase_order'));
        });
        View::composer('layouts.app-branch', function($view)
        {
            $sale_request = 0;
            $purchase_order = 0;
            if(Auth::check()){
                $sale_request = SaleModel::where('status',0)->where('branch_id',Auth::user()->branch_id)->where('is_role','out_shop')->get()->count();

                $request_stock = ItemRequestModel::where('seen_at', null)->where('user_id', Auth::user()->id)->where('status', '!=', 0)->get()->count();
            }
            $view->with(compact('sale_request','request_stock'));
        });
        View::composer('layouts.app-seller', function($view)
        {
            $sale_request = 0;
            $staff = '';
            if(Auth::check()){
                $sale_request = SaleModel::where('status','!=',0)
                    ->where('is_role','out_shop')
                    ->where('user_id',Auth::user()->id)
                    ->where('seen_at',null)
                    ->get()->count();
                $staff = StaffTargetModel::where('staff_id',Auth::user()->id)->first();
            }

            $view->with(compact('sale_request','staff'));
        });


        View::composer('layouts.frontend', function($view)
        {

        });

        View::composer('layouts.adminlte.header', function($view)
        {
            $to_date        =  date('Y-m-d', strtotime("day",strtotime(date('Y-m-d')) ));
            $alert_cust_case = CustomeCaseModel::whereDate("next_meeting",(date('Y-m-d')))
                                ->join('nso007_customers','nso007_customer_case.customer_id','nso007_customers.id')
                                ->where(function ($query) {
                                    if (\Auth::user()->is_role != 'Administrator') {
                                        $query->Where('nso007_customers.agent_id', \Auth::user()->id);
                                    }
                                })
                                ->where('nso007_customers.branch_id',FindBranchID())
                                ->get();
            $alert_cust_case_count = $alert_cust_case->count();
            $view->with(compact('alert_cust_case','alert_cust_case_count'));
        });


    }
}
