<?php

namespace App\Observers;

use App\Model\Accounting\AccountChartModel;
use App\Model\ActionLogModel;
use Auth;

class AccChartObserver
{
    public function created(AccountChartModel $acc)
    {
        ActionLogModel::create([
            'user_id' => Auth::user()->id,
            'model'=>$acc->getTable(),
            'model_id'=>$acc->id,
            'action' => 'create acc chart '.$acc->acc_name,
            'description'=>'create acc chart '.$acc->acc_name,

        ]);
    }

    public function updated(AccountChartModel $acc)
    {
        ActionLogModel::create([
            'user_id' => Auth::user()->id,
            'model'=>$acc->getTable(),
            'model_id'=>$acc->id,
            'action' => 'Updated acc chart '.$acc->acc_name,
            'description'=>'Updated acc chart '.$acc->acc_name,

        ]);
    }

    public function deleted(AccountChartModel $acc)
    {
        if($acc->id) {
            ActionLogModel::create([
                'user_id' => Auth::user()->id,
                'model'=>$acc->getTable(),
                'model_id'=>$acc->id,
                'action' => 'Deleted acc chart '.$acc->acc_name,
                'description'=>'Deleted acc chart '.$acc->acc_name,

            ]);
        }
    }

    public function restored(AccountChartModel $stock)
    {
        //
    }

    public function forceDeleted(AccountChartModel $stock)
    {
        //
    }
}
