<?php

    namespace App\Model\product;

    use Illuminate\Database\Eloquent\Model;

    class CategoryModel extends Model
    {
        /**
         * The attributes that are mass assignable.
         *
         * @var array
         */
        protected $table = "nso007_category";

        protected $fillable = [
            'id',
            'parent_id',
            'category_name',
            'note',
            'status',
            'created_at',
            'updated_at',

        ];

        function parent()
        {
            return $this->belongsTo(CategoryModel::class, 'parent_id');
        }

        public function children()
        {
            return $this->hasMany(CategoryModel::class, 'parent_id');
        }

        public function products()
        {
            return $this->hasMany(ProductModel::class, 'category_id');
        }

    }
