<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use App\Model\product\SizeModel;

class TransferStockDetailModel extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table = "nso007_transfer_stock_detail";
    public function getItem()
    {
        $barcode = $this->barcode;
        $product_unit = findProductUnitByCode($barcode);
        return getProductById($product_unit->product_id);
    }
    public function getSizeName()
    {
        $barcode = $this->barcode;
        $product_unit = findProductUnitByCode($barcode);
        return findSize($product_unit->size_id);
    }
    public function getUnitName()
    {
        $barcode = $this->barcode;
        $product_unit = findProductUnitByCode($barcode);
        return findUnit($product_unit->unit_id);
    }
   
}
