<?php

namespace App\Model\Accounting;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
class AccountChartModel extends Authenticatable
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table = "nso007_account_chart";
    protected $fillable= [
        'id',
        'branch_id',
        'user_id',
        'acc_name',
        'acc_namekh',
        'acctype',
        'acc_des',
        'acc_delete',
        'sub_acc',
        'acc_status',
        'payment_method',
    ];
    public function get_account_type()
    {
		return $this->hasMany('App\AccountTypeModel','id','acctype');
    }
    public function account_type()
    {
        return $this->belongsTo(AccountTypeModel::class,'acctype');
    }

}
