<?php


namespace App\Http\Controllers\setup;


use App\Fun\Fun;
use App\Http\Controllers\Controller;
use App\Model\setup\CustomerStatusModel;
use App\Model\UserGroupModel;
use App\User;
use Auth;
use DataTables;
use DB;
use GuzzleHttp\Client;
use Hash;
use Illuminate\Http\Request;
use Image;
use session;
use Spatie\Permission\Models\Role;

class CustomerStatusController extends Controller

{

    function __construct()

    {
//           $this->middleware('permission:Employees', ['only' => ['show','index','create','store']]);
    }

    public function index()
    {
        $customer_status = CustomerStatusModel::paginate(20);
        return view('setup.customer-status.index', compact('customer_status'));
    }

    public function create(Request $request)
    {
        return view('setup.customer-status.create');
    }

    public function store(Request $request)

    {
        $this->update($request,null);
        return response()->json(['status'=>'ok','reload'=>1]);
    }
    public function edit($id)
    {
        $customer_status = CustomerStatusModel::find($id);
        return view('setup.customer-status.edit', compact('customer_status'));

    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:nso007_customer_status,name,'.$id,
        ]);
        CustomerStatusModel::updateOrCreate(['id'=>$id],$request->all());
        return response()->json(['status'=>'ok','reload'=>1]);
    }
    public function destroy($id)

    {
        CustomerStatusModel::find($id)->delete();
        return response()->json(['status'=>'ok','reload'=>1]);
    }
}
