<?php


    namespace App\Http\Controllers\pos;

    use App\Fun\Fun;
    use App\Http\Controllers\Controller;
    use App\Model\Accounting\AccountChartModel;
    use App\Model\Accounting\JournalModel;
    use App\Model\CostOfSoldModel;
    use App\Model\CustomerModel;
    use App\Model\PaymentDetailModel;
    use App\Model\PaymentModel;
    use App\Model\product\ShelfModel;
    use App\Model\product_return\ProductReturnDetailModel;
    use App\Model\product_return\ProductReturnModel;
    use App\Model\ProductUnitModel;
    use App\Model\SaleDetailsModel;
    use App\Model\SaleModel;
    use App\Model\StockModel;
    use App\Model\WarehouseModel;
    use Auth;
    use Carbon\Carbon;
    use DataTables;
    use DB;
    use Illuminate\Http\Request;
    use Illuminate\Validation\ValidationException;


    class ProductReturnController extends Controller
    {

        function __construct()
        {
//        $this->middleware('permission:Product Return', ['only' => ['create', 'store']]);

        }

        public function index(Request $request)
        {
            if ($request->ajax()) {
                $data = ProductReturnModel::where('status', 1)
                    ->where('user_id',Auth::id())
                    ->latest();
                $count_filter = $data->count();

                return DataTables::of($data->take(25))
                    ->with([
                        "recordsTotal" => $count_filter,
                        "recordsFiltered" => $count_filter,
                    ])
                    ->editColumn('return_date', function ($action) {
                        return date('d-m-Y', strtotime($action->return_date));
                    })
                    ->editColumn('user_id', function ($action) {
                        $user = findUser($action->user_id);
                        return $user ? $user->name : '';
                    })
                    ->editColumn('customer_id', function ($action) {
                        $customer = findCustomer($action->customer_id);
                        return $customer ? $customer->customer_name : '';
                    })
                    ->editColumn('paid', function ($action) {
                        return '$' . number_format($action->paid_en, 2);
                    })
                    ->addColumn('total', function ($action) {
                        $detail = ProductReturnDetailModel::where(['return_id' => $action->id, 'type' => 'out'])->selectRaw('SUM(qty*price) as total')->first();
                        $total = $detail ? $detail->total : 0;
                        $point = $action->using_point / 2;
                        $total = $total - $point;
                        return '$' . number_format($total, 2);
                    })
                    ->addColumn('action', function ($action) {
                        Fun::lang();
                        $btn = '<a data-href="' . route('product-return.show', $action->id) . '" class="btn btn-info show_return">' . __('administrator.show') . '</a>';
//                    $btn .= ' <a data-href="' . route('product-return-delete', $action->id) . '" class="btn btn-danger btn_delete">' . __('administrator.delete') . '</a>';
                        return $btn;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'payment_status', 'punishment', 'total'])
                    ->make(true);
            }
            return view('pos.product-return.index');
        }

        public function create(Request $request)
        {
            if ($request->product_unit_id) {
                $stock = StockModel::where(['product_unit_id' => $request['product_unit_id'], 'type' => 'member', 'member_id' => Auth::id()])->first()->stock_qty ?? 0;
                $price = ProductUnitModel::find($request['product_unit_id'])->retail_price ?? 0;
                return response()->json(['price' => $price, 'stock' => $stock]);
            }
            $acc_chart = getPaymentType();
            return view('pos.product-return.create', compact('acc_chart'));
        }

        public function show($id)
        {
            $master = ProductReturnModel::find($id);
            $in = ProductReturnDetailModel::where('return_id', $id)->where('type', 'in')->get();
            $out = ProductReturnDetailModel::where('return_id', $id)->where('type', 'out')->get();
            return view('pos.product-return.show', compact('master', 'in', 'out'));
        }

        public function store(Request $request)
        {
            $this->validate($request, [
                'reference_number' => 'required|unique:nso007_product_return,invoice_number|unique:nso007_sales,reference_number',
                'customer' => 'required',
                'date' => 'required',
                'c_product' => 'required',
                'r_product' => 'required',

                'r_product.*' => 'required',
                'r_qty.*' => 'required',
                'r_price.*' => 'required',

                'c_product.*' => 'required',
                'c_qty.*' => 'required',
                'c_price.*' => 'required',
            ]);

            $customer_id = $request->customer;
            $check_customer = findCustomer($customer_id);
            if (!$check_customer) {
                throw ValidationException::withMessages(['customer' => 'មិនមានអតិថិជន១នេះទេ']);
            }
            $r_qty = $request['r_qty'];
            $r_price = $request['r_price'];

            $c_qty = $request['c_qty'];
            $c_price = $request['c_price'];

            $user_id = Auth::id();
            $gtotal = $request->sub_total_en;
            //check stock
            $arr_check = [];
            foreach ($request['c_product'] as $key => $item) {
                $check_stock = checkStockMember(Auth::id(), $item, $c_qty[$key]);
                if ($check_stock) {
                    $arr_check[$item] = $check_stock;
                }
            }
            if (count($arr_check)) {
                throw ValidationException::withMessages($arr_check);
            }
            $check_sale = SaleModel::where('reference_number', $request->reference_number)->first();
            if ($check_sale) {
                throw ValidationException::withMessages(['re' => 'លេខវិក័យបត្រមានរួចហើយ !!!']);
            }
            $product_return = new ProductReturnModel();
            $reference = null;
            if (@$request['reference']) {
                $files = $request['reference'];
                $original_name = date('ymdhis') . $request['reference']->getClientOriginalName();
                $destinationPath = 'images/purchase';
                $files->move($destinationPath, $original_name);
                $reference = $destinationPath . '/' . $original_name;
            }

            $product_return->reference = $reference;
            $product_return->user_id = $user_id;
            $product_return->customer_id = $customer_id;
            $product_return->invoice_number = $request->reference_number;
            $product_return->return_date = Carbon::parse($request->date)->format('Y-m-d');
            $product_return->rate = currencyExchange();
            $product_return->status = 1;
            $product_return->note = $request['note'];
            $product_return->payment_type = $request->payment_type;
            $product_return->paid_en = $request->paid;
            $product_return->role = Auth::user()->is_role;
            $product_return->save();

            $pos = new SaleModel;
            $pos->return_id = $product_return->id;
            $pos->invoice_reference = $reference;
            $pos->reference_number = $product_return->invoice_number;
            $pos->user_id = $user_id;
            $pos->customer_id = $request->customer;
            $pos->payment_type = $request->payment_type;
            $pos->payment_status = 'paid';
            $pos->year = date('Y');
            $pos->rate = currencyExchange();
            $pos->sale_type = 'retail';
            $pos->is_role = Auth::user()->user_type;
            $pos->paid_amount_usd = $request->paid;
            $pos->grand_total = $gtotal;
            $pos->sale_date = $product_return->return_date;
            $pos->status = 1;
            $pos->note = $request['note'];
            $pos->type = 'return';
            $pos->save();
            $branch_id = 0;
            $j = JournalModel::selectRaw("Max(journal_tran_id) as last_num")->first();
            $last_id_pos_clothes = $product_return->id;

            foreach ($request['r_product'] as $key => $item) {
                $product_unit = ProductUnitModel::find($item);
                $product_return_detail = new ProductReturnDetailModel();
                $product_return_detail->return_id = $product_return->id;
                $product_return_detail->product_unit_id = $item;
                $product_return_detail->qty = $r_qty[$key];
                $product_return_detail->price = $r_price[$key];
                $product_return_detail->type = 'in';
                $product_return_detail->save();

                $pos_detail = new SaleDetailsModel();
                $pos_detail->sale_id = $pos->id;
                $pos_detail->product_unit_id = $item;
                $pos_detail->qty = $r_qty[$key];
                $pos_detail->currency_id = 2;
                $pos_detail->sale_price = $r_price[$key];
                $pos_detail->type = 'in';
                $pos_detail->total = $request['r_total'][$key];
                $pos_detail->save();

                adjStockMember(Auth::id(),$item,$r_qty[$key]);

                //===================================== Account ========================================================
                $cog = CostOfSoldModel::where(['product_unit_id' => $pos_detail->product_unit_id])->first();
                $product = getProductById($product_unit->product_id);
                $cost = $cog->cost ?? $product_unit->cost;
                if ((int)$pos_detail->unit_id !== (int)$product_unit->unit_id) {
                    $cost /= $product_unit->qty_per_unit;
                }
                if ($key === 0) {
                    $last_id = 0;
                } else {
                    $last_id = JournalModel::selectRaw("Max(journal_parentid) as last_num")->first();
                    $last_id = $last_id->last_num ?? 0;
                }

                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $last_id;
                $journal->journal_type = 5;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_cost_of_good_sold;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Expense cost of goods sold ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $cost * $pos_detail->qty;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = 'return';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $product_return->invoice_number;

                $journal->save();

                $jj = JournalModel::select(\Illuminate\Support\Facades\DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 4;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_sale_revenue;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Sale Revenue ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = $pos_detail->sale_price * $pos_detail->qty;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = 'return';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $product_return->invoice_number;
                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 1;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_inventory;
                $journal->voucher_ref = "V-" . generate_voucher_number(($jj->last_num + 1), 8);
                $journal->journal_des = 'Inventory  ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = $cost * $pos_detail->qty;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $jj->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = 'return';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $product_return->invoice_number;
                $journal->save();
            }

            foreach ($request['c_product'] as $key => $item) {
                $product_unit = ProductUnitModel::find($item);

                $product_return_detail = new ProductReturnDetailModel();
                $product_return_detail->return_id = $product_return->id;
                $product_return_detail->product_unit_id = $item;
                $product_return_detail->qty = $c_qty[$key];
                $product_return_detail->price = $c_price[$key];
                $product_return_detail->type = 'out';
                $product_return_detail->save();

                $pos_detail = new SaleDetailsModel;
                $pos_detail->sale_id = $pos->id;
                $pos_detail->product_unit_id = $item;
                $pos_detail->qty = $c_qty[$key];
                $pos_detail->currency_id = 2;
                $pos_detail->sale_price = $c_price[$key];
                $pos_detail->type = 'out';
                $pos_detail->total = $request['c_total'][$key];
                $pos_detail->save();

                adjStockMember(Auth::id(),$item,-$c_qty[$key]);


                //===================================== Account ========================================================
                $cog = CostOfSoldModel::where(['product_unit_id' => $pos_detail->product_unit_id])->first();
                $product = getProductById($product_unit->product_id);
                $cost = $cog->cost ?? $product_unit->cost;
                if ((int)$pos_detail->unit_id !== (int)$product_unit->unit_id) {
                    $cost /= $product_unit->qty_per_unit;
                }
                $last_id = JournalModel::selectRaw("Max(journal_parentid) as last_num")->first();
                $last_id = $last_id->last_num ?? 0;

                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $last_id;
                $journal->journal_type = 5;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_cost_of_good_sold;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Expense cost of goods sold ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = $cost * $pos_detail->qty;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = 'return';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $product_return->invoice_number;

                $journal->save();

                $jj = JournalModel::select(\Illuminate\Support\Facades\DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 4;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_sale_revenue;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Sale Revenue ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $pos_detail->sale_price * $pos_detail->qty;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = 'return';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $product_return->invoice_number;
                $journal->save();

                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $branch_id;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 1;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_inventory;
                $journal->voucher_ref = "V-" . generate_voucher_number(($jj->last_num + 1), 8);
                $journal->journal_des = 'Inventory  ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $cost * $pos_detail->qty;
                $journal->journal_tran_id = $jj->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;;
                $journal->journal_paydate = $pos->sale_date;;
                $journal->journal_currency = 2;
                $journal->transaction_type = 'return';
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $product_return->invoice_number;
                $journal->save();
            }


            $payment = new PaymentModel();
            $payment->invoice_id = $pos->id;
            $payment->customer_id = $product_return->customer_id;
            $payment->branch_id = $branch_id;
            $payment->user_id = $user_id;
            $payment->payment_invoice = $product_return->invoice_number;
            $payment->payment_date = $product_return->return_date;
            $payment->payment_amount = $gtotal;
            $payment->paid_amount = $gtotal;
            $payment->payment_status = 'paid';
            $payment->type = 'retail';
            $payment->year = date('Y');
            $payment->status = 1;
            $payment->save();

            $payment = new PaymentModel();
            $payment->invoice_id = $product_return->id;
            $payment->customer_id = $product_return->customer_id;
            $payment->branch_id = $branch_id;
            $payment->user_id = $user_id;
            $payment->payment_invoice = $product_return->invoice_number;
            $payment->payment_date = $product_return->return_date;
            $payment->payment_amount = $gtotal;
            $payment->paid_amount = $gtotal;
            $payment->payment_status = 'paid';
            $payment->type = 'return';
            $payment->year = date('Y');
            $payment->status = 1;
            $payment->save();

            $payment_datail = new PaymentDetailModel();
            $payment_datail->payment_id = $payment->id;
            $payment_datail->paid_amount = $gtotal;
            $payment_datail->payment_date = $product_return->return_date;
            $payment_datail->status = 1;
            $payment_datail->save();

            $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
            $journal = new JournalModel;
            $journal->branch_id = $branch_id;
            $journal->journal_parentid = $jj->last_id;
            $journal->journal_type = 1;
            $journal->journal_acccode = 41100;
            $journal->voucher_type = 1;
            $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
            $journal->journal_des = 'Less Interest income  ' . '(' . $pos->reference_number . ')';
            $journal->journal_debit = $gtotal;
            $journal->journal_credit = 0;
            $journal->journal_tran_id = $j->last_num + 1;
            $journal->journal_transactiondate = $pos->sale_date;
            $journal->journal_paydate = $pos->sale_date;
            $journal->journal_currency = 2;
            $journal->transaction_type = 'return';
            $journal->journal_referenceid = $last_id_pos_clothes;
            $journal->journal_reference_number = $pos->reference_number;
            $journal->journal_by = $user_id;
            $journal->save();

            session()->put('success', 'Record inserted successfully');
            return response()->json(['status' => 'ok', 'route' => route('product-return.index')]);
        }

        public function get_stock_qty(Request $request)
        {
            $warehouse = getWarehouse()->first();
            $unit = $request->unit;
            $warehouse = $warehouse ? $warehouse->id : 0;
            $stock = StockModel::where(['product_unit_id' => $request->product_unit, 'shelf' => $request->shelf])
                ->where(function ($q) use ($warehouse) {
                    if ($warehouse) {
                        $q->where('warehouse_id', $warehouse);
                    }
                })->first();
            $p_unit = ProductUnitModel::find($request->product_unit);
            $stock = $stock ? $stock->stock_qty : 0;
            $price = 0;
            if ($p_unit) {
                if ($p_unit->unit_id == $unit) {
                    $stock = $stock / $p_unit->qty_per_unit;
                    $stock = intval($stock);
                    $price = $p_unit->wholesale_price;
                } else {
                    $price = $p_unit->retail_price;

                }
            }
            if ($request->type) {
                return ['stock' => $stock, 'price' => $price];
            } else {
                return response()->json(['stock' => $stock, 'price' => $price]);
            }
        }

        public function destroy($id)
        {
            $product_return = ProductReturnModel::find($id);
            $branch = findBranch($product_return->branch_id);
            $product_return_detail = ProductReturnDetailModel::where('return_id', $id)->get();

            $sale = SaleModel::where('return_id', $id)->first();
            SaleDetailsModel::where('sale_id', $id)->delete();

            $payment_sale = PaymentModel::where('invoice_id', $sale->id)->first();
            if ($payment_sale) {
                PaymentDetailModel::where('payment_id', $payment_sale->id)->delete();
                $payment_sale->delete();
            }
            $payment_return = PaymentModel::where('invoice_id', $product_return->id)->first();
            if ($payment_return) {
                PaymentDetailModel::where('payment_id', $payment_return->id)->delete();
                $payment_return->delete();
            }


            JournalModel::where('journal_referenceid', $sale->id)->delete();
            JournalModel::where('journal_referenceid', $product_return->id)->delete();

            foreach ($product_return_detail as $item) {
                if ($item->type === 'in') {
                    $in = 0; //if type = in , remove in_qty from stock
                } else {
                    $in = 1; //if type = out , add out_qty to stock
                }
                cut_or_add_stock_item($branch, $product_return->warehouse_id, $item->product_unit_id, $item->unit_id, $item->shelf, $item->qty, $in);
                $item->delete();
            }


            $customerModel = CustomerModel::find($product_return->customer_id);
            $customerModel->points -= $product_return->get_point;
            $customerModel->points += $product_return->using_point;
            $customerModel->update();
            $product_return->delete();
            return response()->json(['status' => 'ok']);
        }


    }


