<?php

namespace App\Http\Controllers\HR;

use App\BranchModel;
use App\Http\Controllers\Controller;
use App\Model\Hr\HrBranch;
use App\Model\WarehouseModel;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Yajra\DataTables\Facades\DataTables;
use DB;

class HrBranchController extends Controller
{
public $type;
    function __construct()
    {
        $this->middleware('permission:Branch List', ['only' => ['index']]);
        $this->middleware('permission:Branch Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Company Profile', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Branch Set Main', ['only' => ['branch_changeStatus']]);
        $this->middleware('permission:Branch View', ['only' => ['show']]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $type = ltrim($request->type,'/');
            $branch = BranchModel::where('type',$type)
                ->where(function ($q) use ($request) {
                    if ($request->name) {
                        $q->where('name', 'like', '%' . $request->name . '%');
                    }
                    if ($request->phone) {
                        $q->where('phone', 'like', '%' . $request->phone . '%');
                    }
                    if ($request->email) {
                        $q->where('email', 'like', '%' . $request->email . '%');
                    }
                })
                ->latest()
                ->take(20);
            return DataTables::of($branch)
                ->with([
                    "recordsTotal" => $branch->count(),
                    "recordsFiltered" => $branch->count(),
                ])
                ->addColumn('action', function ($action) {
                    $btn = '';
                    if (Auth::user()->can('Branch Edit')) {
                        $btn .= '<i href="javascript:;" data-url = "' . route("branch.edit", $action->id) . '" class="fa fa-pencil btn btn-warning btn_edit" title="Edit"></i> ';
                    }
                    if (Auth::user()->can('Branch View') || 1) {
                        $btn .= '<i href="javascript:;" data-url = "' . route("branch.show", $action->id) . '" class="fa fa fa-eye btn btn-info btn_show" title="Show"></i> ';
                    }

                    if ($action->main) {
                        $btn .= '<i href="javascript:;" data-url = "' . route("branch-set-main", $action->id) . '"  class="btn btn-default">' . __('administrator.default') . '</i>';
                    } else {
                        if (Auth::user()->can('Branch Set Main') && ($action->type==='branch') && myBranch()->main) {
                            $btn .= '<i href="javascript:;" data-url = "' . route("branch-set-main", $action->id) . '"  class="btn btn-sm btn-primary btn_set">' . __('administrator.set_to_default') . '</i>';
                        }
                    }
                    return $btn;
                })
                ->editColumn('logo', function ($action) {
                    if ($action->logo) {
                        if (file_exists(public_path() . '/' . $action->logo)) {
                            return '<img src="' . asset($action->logo) . '" height="60px" class="show_logo cursor" />';
                        }
                    }
                })
                ->editColumn('user_admin', function ($action) {
                    if ($action->user_admin)
                        return findUser($action->user_admin)->name??'';

                })
                ->editColumn('parent_id', function ($action) {
                    if ($action->parent_id)
                        return findBranch($action->parent_id)->name??'';

                })
                ->addIndexColumn()
                ->rawColumns(['action', 'logo'])
                ->make(true);
        }
        return view('hr.branch.index');
    }
    public function create()
    {
        return view('hr.branch.create');
    }

    public function store(Request $request)
    {
        return $this->update(null, $request);
    }

    public function edit($id)
    {
        $master = findBranch($id);
        $user = findUser($master->user_admin);
        $role_val = DB::table('model_has_roles')->where('model_id', $master->user_admin)->first();
        if ($role_val) {
            $role_val = Role::find($role_val->role_id);
        }
        return view('hr.branch.edit', compact('master','user','role_val'));
    }

    public function update($id, Request $request)
    {
        $branch_img = BranchModel::find($id);
        $this->validate($request, [
            'name' => 'required|unique:nso007_branch,name,' . $id,
            'contact' => 'unique:nso007_branch,contact,' . $id,
        ]);

        $arr = ($request->all());
        $arr['parent_id']=$request['parent_id']??FindBranchID();
        if ($files = $request->file('logo')) {
            if ($branch_img) {
                if ($branch_img->logo) {
                    if (file_exists(public_path() . '/' . $branch_img->logo)) {
                        unlink(public_path() . '/' . $branch_img->logo);
                    }
                }
            }
            $original_name = 'F' . date('ymdhis') . '.png';
            $destinationPath = 'images/logo';
            $files->move($destinationPath, $original_name);
            $arr['logo'] = $destinationPath . '/' . $original_name;
        } else {
            $arr['logo'] = $branch_img ? $branch_img->logo : null;
        }


        BranchModel::UpdateOrCreate([
            'id' => $id
        ], $arr);
        session()->put('success', 'Update Successfully');
        return response()->json(['status' => 'ok','reload'=>1]);
    }

    public function branch_changeStatus($id)
    {
        BranchModel::where('main', 1)->update(['main' => 0]);
        BranchModel::find($id)->update(['main' => 1]);
        session()->put('success', 'Status change successfully.');
        return response()->json(['status' => 'ok','reload'=>1]);
    }

    public function destroy(Request $request, $id)
    {
        User::where('id', $id)->delete();
        return response()->json(['status' => 200, 'data' => '']);
    }

    public function show($id, Request $request)
    {
        $branch = BranchModel::find($id);
        if ($request->myAjax) {
            $user = User::where('branch_id', $id)->get();
            $html = '';
            foreach ($user as $key => $row) {
                $html .= ' <tr>
                <td>'.($key+1).'</td>
                <td>'.$row->name.'</td>
                <td>'.$row->phone.'</td>
                <td>'.$row->email.'</td>
                </tr>';
            }
            return ($html);
        }
        if($request->add){
            $user = User::find($request->user);
            $user->update(['branch_id'=>$id]);
            return 'ok';
        }
        if($request->remove){
            $user = User::find($request->user);
            $user->update(['branch_id'=>null]);
            return 'ok';
        }
        return view('hr.branch.show', compact('branch'));

    }
}
