<?php

namespace App\Http\Controllers\CRM;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\LeadSource;
use DataTables, Validator;

class LeadSourceController extends Controller
{
    public function index(Request $request)
    {
        if($request->ajax()){
            $data = LeadSource::orderBy('id', 'desc')
                            ->where(function ($q) use ($request) {
                                if($request->name){
                                    $q->where('source_name', 'like', '%' . $request->name . '%');
                                }
                                if($request->note){
                                    $q->where('note', 'like', '%' . $request->note . '%');
                                }
                            })
                            ->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));

            return DataTables::of($data->items())
                    ->with([
                        "activePage" => $request->page,
                        "records" => $request->record,
                        "recordsTotal" => $data->total(),
                        "recordsFiltered" => $data->total(),
                        'totalPage' => $data->lastPage()
                    ])
                    ->editColumn('type', function($action){
                        if($action->type){
                            return get_source_type($action->type);
                        }
                    })
                    ->addColumn('action', function($action){
                        $btn = '';
                        if(uCan('Lead Source Edit')){
                            $btn .= '<i href="javascript:;" data-href = "' . route("lead-source.edit", $action->id) . '"  class="fa fa-pencil btn btn-sm btn-warning" title="Edit"></i>';
                        }
                        if(uCan('Lead Source Edit')){
                           $btn .= ' <i href="javascript:;" data-url = "' . route("lead-source.destroy", $action->id) . '" class="fa fa-trash btn btn-sm btn-danger" title="Delete"></i>';
                        }
                        return $btn;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->make(true);
        }
        return view('crm.lead_source.index');
    }

    public function create()
    {
        return view('crm.lead_source.create');
    }

    public function store(Request $request)
    {
        return $this->update($request,null);
    }
    public function edit($id)
    {
        $leadSource  = LeadSource::find($id);
        return view('crm.lead_source.edit',compact('leadSource'));
    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'source_name' => 'required|max:25|string|unique:nso007_crm_lead_source,source_name,'.$id,
            'type' => 'required',
            'note' => 'nullable|string|max:255',
        ]);
        $leadSource  = LeadSource::updateOrCreate(['id'=>$id],$request->all());

        if($request->in_lead=="1"){
            $leadSource->set_data=1;
            return response()->json($leadSource);
        }else{
            return response()->json(['status' => 'ok','reload'=>1]);
        }
    }
    public function destroy($id)
    {
        LeadSource::find($id)->delete();
        return response()->json(['', 200]);
    }
}
