<?php

namespace App\Http\Controllers\CRM;

use App\Http\Controllers\Controller;
use App\Model\CRMLeadModel;
use App\Model\CRMTaskModel;
use App\Model\CustomerBranchModel;
use App\Model\CustomerIllnessModel;
use App\Model\CustomerModel;
use App\Model\LeadSource;
use App\Model\location\ProvinceModel;
use App\Models\TypeOfIllness;
use Auth;
use Carbon\Carbon;
use DataTables;
use DB;
use Fun;
use Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Validator;

class LeadController extends Controller
{

    public function __construct()
    {
        Fun::lang();
    }

    public function index()
    {
        $province = ProvinceModel::pluck('name_kh', 'id');
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck('name_km', 'id');
        return view('crm.lead.index', compact('province', 'illness_types'));
    }

    public function abandon_prospect()
    {
        $province = ProvinceModel::pluck('name_kh', 'id');
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck('name_km', 'id');
        $delete = 1;
        return view('crm.lead.index', compact('province', 'illness_types', 'delete'));
    }
    public function get_prospects(Request $request)
    {
        $data = CRMLeadModel::
        leftjoin('nso007_crm_task', 'nso007_crm_task.lead_id', 'nso007_crm_leads.id')
            ->join(DB::raw('(Select max(id) as id from nso007_crm_task group by lead_id,agent_id) c1'), function ($join) {
                // join to get latest record groupby
                $join->on('nso007_crm_task.id', '=', 'c1.id');
            })
            ->selectRaw('
                        nso007_crm_leads.id as lead_id,
                        nso007_crm_leads.name,
                        users.name as agent_name,
                        nso007_crm_leads.family_name,
                        nso007_crm_leads.contact,
                        nso007_crm_leads.address,
                        nso007_crm_leads.job,
                        nso007_crm_leads.note,
                        nso007_crm_leads.workplace,
                        nso007_crm_leads.sex,
                        nso007_crm_leads.branch_id,
                        nso007_crm_leads.convert_status,
                        nso007_crm_leads.email,
                        nso007_crm_leads.agent_id,
                        nso007_crm_leads.illness,
                        nso007_crm_leads.known_product_by,
                        nso007_crm_leads.delete_reason,
                        nso007_crm_leads.deleted_at,
                        nso007_crm_leads.deleted_by,
                        nso007_crm_leads.delete_status,
                        nso007_crm_task.date as date_follow_up,
                        lead_source,
                        nso007_crm_leads.date')
            ->leftjoin('users', 'users.id', 'nso007_crm_leads.agent_id')
            ->where(function ($q) use ($request) {
                if ($request['fol_from_date']) {
                    $q->whereDate('nso007_crm_task.date', '>=', date('Y-m-d', strtotime($request['fol_from_date'])));
                }
                if ($request['fol_to_date']) {
                    $q->whereDate('nso007_crm_task.date', '<', date('Y-m-d', strtotime($request['fol_to_date'])));
                }
                if ($request['from_date']) {
                    $q->whereDate('nso007_crm_leads.date', '>=', date('Y-m-d', strtotime($request['from_date'])) . ' 00:00:00');
                }
                if ($request['to_date']) {
                    $q->whereDate('nso007_crm_leads.date', '<', date('Y-m-d', strtotime($request['to_date'])) . ' 23:59:59');
                }

                if ($request->agent) {
                    $q->where('nso007_crm_leads.agent_id', $request->agent);
                }
                if ($request->last_name) {
                    $q->where('nso007_crm_leads.name', 'like', '%' . $request->last_name . '%');
                }
                if ($request->contact) {
                    $q->where('nso007_crm_leads.contact', 'like', '%' . $request->contact . '%');
                }
                if ($request->address) {
                    $q->where('nso007_crm_leads.address', 'like', '%' . $request->address . '%');
                }
                if ($request->note) {
                    $q->where('nso007_crm_leads.note', 'like', '%' . $request->note . '%');
                }
                if ($request->type_of_illness) {
                    $q->where('nso007_crm_leads.illness', 'like', '%"' . $request->type_of_illness . '"%');
                }
                if ($request->deal_status) {
                    $q->where('nso007_crm_leads.convert_status', $request->deal_status);
                }
                $q->where('nso007_crm_leads.delete_status', $request->delete_status);
            })
            ->where(function ($q) {
                $q->where('nso007_crm_leads.agent_id', Auth::id());
            })
            ->groupBy('nso007_crm_task.lead_id')
            ->orderBy('nso007_crm_leads.date', 'desc');
        $count = $data->get()->count();
        return DataTables::of($data->take(20))
            ->with([
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
            ])
            ->editColumn('date', function ($data) use ($request) {
                return myDate($data->date);
            })
            ->editColumn('date_follow_up', function ($data) use ($request) {
                return myDate($data->date_follow_up);
            })
            ->editColumn('convert_status', function ($data) {
                if ($data->convert_status != 0)
                return bgDealStatus($data->convert_status);
            })
            ->editColumn('sex', function ($data) {
                if ($data->sex)
                    return __('administrator.' . $data->sex);
            })
            ->editColumn('deleted_by', function ($data) {
                if ($data->deleted_by)
                    return findUser($data->deleted_by)->name ?? '';
            })
            ->addColumn('action', function ($lead) {
                if (!$lead->delete_status) {
                    $model = DB::table('model_has_roles')->where('model_id', Auth::user()->id)->first();
                    $can = $model->role_id === 1 || $model->role_id === 5;
                    $btn = '<a href="' . route("lead.show", $lead->lead_id) . '"><i href="javascript:;" class="fa fa-eye btn btn-sm btn-success" title="View"></i></a> ';
                    if ($lead->agent_id === Auth::user()->id || $can || $model->role_id === 10) {
                        if ($lead->convert_status != 1) {
                            $btn .= ' <i
                                 data-href = "' . route("task.create") . '?lead_id=' . $lead->lead_id . '" data-email="' . $lead->email . '"
                                class="fa fa-tasks btn btn-sm btn-primary" title="Task"></i>
                                <i data-url = "' . route("lead.edit", $lead->lead_id) . '" class="fa fa-pencil btn btn-sm btn-warning edit_lead" title="Edit"></i>';
                        } else {
                            $customer = CustomerModel::where('lead_id', $lead->lead_id)->first();
                            $customer = $customer ? $customer->id : '';
                            $btn .= ' <a href="' . route("pos-retail.create") . '?lead=1&hellowajitnomotocambo=hibbbyerequestbyeloveyou&customer=' . (Crypt::encrypt($customer)) . '"><i href="javascript:;" class="fa fa-shopping-cart btn btn-sm btn-info" title="POS"></i></a> ';
                        }
                    }
                    if ($lead->convert_status != 1) {
                        if ((Auth::user()->can('Prospect Delete') )) { //&& date('Y-m-d',strtotime($lead->date)) === date('Y-m-d')
                            $btn .= ' <i data-url = "' . route("lead.destroy", $lead->lead_id) . '" class="fa fa-trash btn btn-sm btn-danger" title="Delete"></i>';
                        }
                    }
                    return $btn;
                }
            })
            ->addColumn('illness', function ($lead) {
                if ($lead->illness) {
                    return getCustomerIllnessJson($lead->illness);
                }
            })
            ->addIndexColumn()
            ->rawColumns(['action', 'convert_status', 'illness'])
            ->make(true);
    }

    public function create()
    {
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck((if_kh() ? 'name_km' : 'name_en'), 'id');
        return view('crm.lead.create', compact( 'illness_types'));
    }

    public function edit($id)
    {
        $illness_types = TypeOfIllness::whereNull('deleted_at')->pluck((if_kh() ? 'name_km' : 'name_en'), 'id');
        $cust_ill = CustomerIllnessModel::where('lead_id', $id)->pluck('illness_id');
        $lead = CRMLeadModel::find($id);
        $customer = CustomerModel::where('lead_id', $id)->first();
        return view('crm.lead.edit', compact( 'illness_types', 'lead', 'customer', 'cust_ill'));
    }

    function translate($key)
    {
        return __('administrator.' . $key) . ' ' . __('administrator.field is required.');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'agent_id' => 'required',
            'date' => 'required',
            'source' => 'required|exists:nso007_crm_lead_source,id',
            'customer_name' => 'required',
            'customer_phone' => 'max:100',
            'sex' => 'required',
            'province' => 'required',
            'type_of_illness' => 'required',
            'address' => 'required',
            'date_follow_up' => 'required',
        ],
            [
                'agent_id.required' => $this->translate('agent'),
                'date.required' => $this->translate('date'),
                'source.required' => $this->translate('lead_source'),
                'customer_name.required' => $this->translate('customer_name'),
                'customer_phone.required' => $this->translate('customer_phone'),
                'sex.required' => $this->translate('sex'),
                'province.required' => $this->translate('province'),
                'type_of_illness.required' => $this->translate('type_of_illness'),
                'address.required' => $this->translate('address'),

            ]);
        $illness = json_encode($request->type_of_illness);

        $addlead = new CRMLeadModel;
        $addlead->branch_id = myBranch() ? myBranch()->id : '';
        $addlead->agent_id = $request->agent_id;
        $addlead->lead_source = $request->source;
        $addlead->known_product_by = $request->known_product_by;
        $addlead->contact_by = $request->contact_by;
        $addlead->sex = $request->sex;
        $addlead->workplace = $request->workplace;
        $addlead->address = $request->address;
        $addlead->note = $request->note;
        $addlead->age = $request->age;
        $addlead->customer_note = $request->customer_note;
        $addlead->name = $request->customer_name;
        $addlead->contact = $request->customer_phone;
        $addlead->province = $request->province;
        $addlead->illness = $illness;
        $addlead->illness_status = $request->illness_status;
        $addlead->advice_product = $request->advice_product;
        $addlead->other = $request->other;
        $addlead->convert_status = $request->convert_status ?? 0;
        $addlead->date = date('Y-m-d', strtotime($request->date)) . ' ' . ($request->date ? date('H:i:s') : '');
        $addlead->district_or_city = $request->district_or_city;

        $addlead->save();
        $task = new CRMTaskModel;
        $task->lead_id = $addlead->id;
        $task->agent_id = $request->agent_id;
        $task->branch_id = $addlead->branch_id;
        $task->task_type = $request->task_type;
        $task->subject = $request->subject;
        $task->where = $request->place;
        $task->date = date('Y-m-d', strtotime($request->date_follow_up));
        $task->save();

        $data = new CustomerModel();
        $data->agent_id = $request->agent_id;
        $data->branch_id = $addlead->branch_id;
        $data->customer_name = $addlead->name;
        $data->lead_id = $addlead->id;
        $data->sex = $addlead->sex;
        $data->age = $addlead->age;
        $data->customer_phone = $addlead->contact;
        $data->register_date = $addlead->date;
        $data->province = $addlead->province;
        $data->customer_address = $addlead->address;
        $data->member_type_id = (int)$addlead->convert_status === 1 ? 2 : 5;
        $data->note = $addlead->note;
        $data->type_illness = $illness;
        $data->illness_status = $addlead->illness_status;
        $data->customer_note = $addlead->customer_note;
        $data->known_this_from = $addlead->lead_source;
        $data->known_product_by = $addlead->known_product_by;
        $data->contact_by = $addlead->contact_by;
        $data->district_or_city = $addlead->district_or_city;
        $data->status = 0;
        $data->save();
        if ($request->type_of_illness) {
            foreach ($request->type_of_illness as $row) {
                $ill = new CustomerIllnessModel();
                $ill->lead_id = $addlead->id;
                $ill->illness_id = $row;
                $ill->save();

                $ill_cus = new CustomerIllnessModel();
                $ill_cus->customer_id = $data->id;
                $ill_cus->illness_id = $row;
                $ill_cus->save();
            }
        }
        session()->put('success', 'Record was Create successful');
        return response()->json(['status' => 'ok', 'route' => route('lead.index')]);
    }

    public function show($id)
    {
        $lead = CRMLeadModel::find($id);
        $task = CRMTaskModel::where('lead_id', $id)->get();
        return view('crm.lead.show', compact('lead', 'task'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'agent_id' => 'required',
            'date' => 'required',
            'source' => 'required|exists:nso007_crm_lead_source,id',
            'customer_phone' => 'max:100',
            'customer_name' => 'required',
            'sex' => 'required',
            'province' => 'required',
            'type_of_illness' => 'required',
            'address' => 'required',
        ], [
            'agent_id.required' => $this->translate('agent'),
            'date.required' => $this->translate('date'),
            'source.required' => $this->translate('lead_source'),
            'customer_name.required' => $this->translate('customer_name'),
            'customer_phone.required' => $this->translate('customer_phone'),
            'sex.required' => $this->translate('sex'),
            'province.required' => $this->translate('province'),
            'type_of_illness.required' => $this->translate('type_of_illness'),
            'address.required' => $this->translate('address'),

        ]);
        $date = date('Y-m-d', strtotime($request->date));
        $illness = json_encode($request->type_of_illness);
        $addlead = CRMLeadModel::find($id);
        $addlead->agent_id = $request->agent_id;
        $addlead->lead_source = $request->source;
        $addlead->contact_by = $request->contact_by;
        $addlead->sex = $request->sex;
        $addlead->workplace = $request->workplace;
        $addlead->address = $request->address;
        $addlead->note = $request->note;
        $addlead->customer_note = $request->customer_note;
        $addlead->name = $request->customer_name;
        $addlead->contact = $request->customer_phone;
        $addlead->province = $request->province;
        $addlead->illness = $illness;
        $addlead->illness_status = $request->illness_status;
        $addlead->advice_product = $request->advice_product;
        $addlead->known_product_by = $request->known_product_by;
        $addlead->other = $request->other;
        $addlead->convert_status = $request->convert_status ?? 0;
        if ($date != date('Y-m-d', strtotime($addlead->date))) {
            $addlead->date = $date . ' ' . ($request->date ? date('H:i:s') : '');
        }
        $addlead->update();
        $data = CustomerModel::updateOrCreate(['lead_id' => $id], [
            'agent_id' => $request->agent_id,
            'branch_id' => $addlead->branch_id,
            'customer_name' => $addlead->name,
            'lead_id' => $addlead->id,
            'sex' => $addlead->sex,
            'age' => $addlead->age,
            'customer_phone' => $addlead->contact,
            'register_date' => $addlead->date,
            'province' => $addlead->province,
            'customer_address' => $addlead->address,
            'member_type_id' => $addlead->convert_status === 1 ? 2 : 5,
            'note' => $addlead->note,
            'type_illness' => $illness,
            'illness_status' => $addlead->illness_status,
            'customer_note' => $addlead->customer_note,
            'known_this_from' => $addlead->lead_source,
            'known_product_by' => $addlead->known_product_by,
            'contact_by' => $addlead->contact_by,
            'district_or_city' => $addlead->district_or_city,
            'status' => 0,
        ]);

        if ($request->type_of_illness) {
            CustomerIllnessModel::where('lead_id', $addlead->id)->delete();
            CustomerIllnessModel::where('customer_id', $data->id)->delete();
            foreach ($request->type_of_illness as $row) {
                $ill = new CustomerIllnessModel();
                $ill->lead_id = $addlead->id;
                $ill->illness_id = $row;
                $ill->save();
                $ill_cus = new CustomerIllnessModel();
                $ill_cus->customer_id = $data->id;
                $ill_cus->illness_id = $row;
                $ill_cus->save();
            }
        }

        return response()->json(['status' => 'ok', 'route' => route('lead.index')]);

    }

    public function destroy($id, Request $request)
    {
        $this->validate($request,[
            'delete_reason'=>'required|max:200'
        ]);
        CRMLeadModel::findOrFail($id)->update(['delete_status' => 1, 'delete_reason' => $request->delete_reason, 'deleted_by' => Auth::user()->id, 'deleted_at' => date('Y-m-d h:i:s')]);
        CustomerModel::where('lead_id', $id)->update(['member_type_id' => 5]);
        return response()->json(['status' => 'success']);
    }

    public function closeDeal(Request $request, $id)
    {
        $lead = CRMLeadModel::find($id);
        $lead->update(['convert_status' => $request->result, 'close_deal_note' => $request->note]);
        $customer = CustomerModel::where('lead_id', $id)->first();
        if ($customer) {
            $customer->update(['member_type_id' => (int)$request->result === 1 ? 2 : 5]);
            if ($request->result == 1) {
                CustomerBranchModel::updateOrCreate([
                    'customer_id' => $customer->id,
                    'branch_id' => $lead->branch_id,
                    'user_id' => $lead->agent_id,
                ], [
                    'customer_id' => $customer->id,
                    'branch_id' => $lead->branch_id,
                    'user_id' => $lead->agent_id,
                ]);
            }
        }

        return response()->json([200]);
    }

    public function upcoming_task(Request $request)
    {
        if ($request->ajax()) {
            $lead_id = $request->lead_id;
            $agent_id = $request->agent_id;
            $task_type = $request->task_type;
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : null;
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : null;
            $data = CRMTaskModel::join('nso007_crm_leads', 'nso007_crm_leads.id', 'nso007_crm_task.lead_id')
                ->join(DB::raw('(Select max(id) as id from nso007_crm_task group by lead_id,agent_id) c1'), function ($join) {
                    // join to get latest record groupby
                    $join->on('nso007_crm_task.id', '=', 'c1.id');
                })
                ->selectRaw('nso007_crm_task.*,nso007_crm_leads.contact,nso007_crm_leads.name,nso007_crm_leads.agent_id as user_id')
                ->where('nso007_crm_leads.convert_status', '!=', 1)
                ->where('nso007_crm_leads.convert_status', '!=', 2)
                ->where('nso007_crm_leads.delete_status', 0)
                ->where(function ($q) {
                    $q->where('nso007_crm_leads.agent_id', Auth::user()->id);
                })
                ->where(function ($q) use ($from_date, $to_date, $request) {
                    if ($from_date && $to_date) {
                        if ($from_date) {
                            $q->where('nso007_crm_task.date', '>=', $from_date);
                        }
                        if ($to_date) {
                            $q->where('nso007_crm_task.date', '<=', $to_date);
                        }
                    } else {
                        $q->where('nso007_crm_task.date', Carbon::today());
                    }
                })
                ->where(function ($q) use ($lead_id) {
                    if ($lead_id) {
                        $q->where('lead_id', $lead_id);
                    }
                })
                ->where(function ($q) use ($agent_id) {
                    if ($agent_id) {
                        $q->where('nso007_crm_leads.agent_id', $agent_id);
                    }
                })
                ->where(function ($q) use ($task_type) {
                    if ($task_type) {
                        $q->where('task_type', $task_type);
                    }
                })
                ->orderBy('id', 'desc');
            $count_filter = $data->get()->count();

            return DataTables::of($data->take(20))
                ->with([
                    "recordsTotal" => $count_filter,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('agent_id', function ($data) {
                    $user = findUser($data->user_id);
                    return $user ? $user->name : '';
                })
                ->editColumn('task_type', function ($data) {
                    if ($data->task_type)
                        return __('administrator.' . $data->task_type);
                })
                ->editColumn('subject', function ($data) {
                    return $data->subject;
                })
                ->editColumn('where', function ($data) {
                    return $data->where;
                })
                ->editColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->date));
                })
                ->editColumn('note', function ($data) {
                    return '<textarea rows="3" class="no-bg no-border">' . $data->note . '</textarea>';
                })
                ->addColumn('action', function ($lead) {
                    $btn = '<a href="' . route("lead.show", $lead->lead_id) . '"><i href="javascript:;" class="fa fa-eye btn btn-sm btn-success" title="View"></i></a>';
                    return $btn;
                })
                ->addIndexColumn()
                ->rawColumns(['lead_contact', 'action', 'note', 'convert_status'])
                ->make(true);
        }
        return view('crm.upcoming-task.index');
    }

    public function search_lead(Request $request)
    {
        $key = $request->term['term'];
        $customer = CRMLeadModel::where(function ($q) use ($key) {
            if ($key) {
                $q->where('name', 'like', '%' . $key . '%');
                $q->orwhere('contact', 'like', '%' . $key . '%');
                $q->orwhere('email', 'like', '%' . $key . '%');
            }
        })
            ->where('agent_id', Auth::id())
            ->limit(30)
            ->pluck('name', 'id')
            ->prepend('Please Select', '');
        $arr = [];

        foreach ($customer as $key => $row) {
            $arr[] = ['id' => $key, 'text' => $row];
        }
        return \Response::json($arr);

    }

    public function report(Request $request)
    {

        if ($request->ajax()) {
            $illness = $request->illness;
            $data = CRMLeadModel::
            leftjoin('nso007_crm_task', 'nso007_crm_task.lead_id', 'nso007_crm_leads.id')
                ->join(DB::raw('(Select max(id) as id from nso007_crm_task group by lead_id,agent_id) c1'), function ($join) {
                    // join to get latest record groupby
                    $join->on('nso007_crm_task.id', '=', 'c1.id');
                })
                ->where(function ($q) {
                    $q->where('nso007_crm_task.agent_id', Auth::user()->id);
                })
                ->where('nso007_crm_leads.delete_status', 0)
                ->where(function ($q) use ($request, $illness) {
                    if ($request->lead_id) {
                        $q->where('nso007_crm_leads.id', $request->lead_id);
                    }
                    if ($request->agent_id) {
                        $q->where('nso007_crm_leads.agent_id', $request->agent_id);
                    }
                    if ($request->sex) {
                        $q->where('nso007_crm_leads.sex', $request->sex);
                    }
                    if ($request->convert_status) {
                        $q->where('nso007_crm_leads.convert_status', $request->convert_status);
                    }
                    if ($request->province) {
                        $q->where('nso007_crm_leads.province', $request->province);
                    }
                    if ($request->lead_source) {
                        $q->where('nso007_crm_leads.lead_source', $request->lead_source);
                    }
                    if ($request->type) {
                        $q->where('task_type', $request->type);
                    }

                    if ($request->search_contact) {
                        $q->where('nso007_crm_leads.contact', 'like', '%' . $request->search_contact . '%');
                    }
                    if ($request->search_address) {
                        $q->where('nso007_crm_leads.address', 'like', '%' . $request->search_address . '%');
                    }
                    if ($request->note) {
                        $q->where('nso007_crm_leads.note', 'like', '%' . $request->note . '%');
                    }
                    if ($illness) {
                        $q->where('illness', 'like', '%"' . $illness . '"%');
                    }
                })
                ->where(function ($q) use ($request) {
                    if ($request->r_start_date) {
                        $q->whereDate('nso007_crm_leads.date', '>=', date('Y-m-d', strtotime($request->r_start_date)));
                    }
                    if ($request->r_end_date) {
                        $q->whereDate('nso007_crm_leads.date', '<=', date('Y-m-d', strtotime($request->r_end_date)));
                    }
                })
                ->where(function ($q) use ($request) {
                    if ($request->f_start_date) {
                        $q->whereDate('nso007_crm_task.date', '>=', date('Y-m-d', strtotime($request->f_start_date)));
                    }
                    if ($request->f_end_date) {
                        $q->whereDate('nso007_crm_task.date', '<=', date('Y-m-d', strtotime($request->f_end_date)));
                    }
                })
                ->selectRaw('
                            nso007_crm_leads.name,
                            nso007_crm_leads.family_name,
                            nso007_crm_leads.contact,
                            nso007_crm_leads.address,
                            nso007_crm_leads.job,
                            nso007_crm_leads.workplace,
                            nso007_crm_leads.sex,
                            nso007_crm_leads.date as register_date,
                            nso007_crm_leads.convert_status,
                            nso007_crm_leads.email,
                            nso007_crm_leads.agent_id,
                            nso007_crm_leads.illness,
                            nso007_crm_leads.province,
                            nso007_crm_task.date as followup_date,
                            nso007_crm_task.complete_status,
                            nso007_crm_task.lead_id,
                            nso007_crm_leads.id,
                            nso007_crm_leads.note,
                            nso007_crm_task.task_type,
                            lead_source')
                ->groupBy('nso007_crm_task.lead_id')
                ->orderBy('nso007_crm_leads.id', 'desc');
            $count = $data->get()->count();
            return DataTables::of($data->take(20))
                ->with([
                    "recordsTotal" => $count,
                    "recordsFiltered" => $count,
                ])
                ->editColumn('followup_date', function ($data) {
                    $task = CRMTaskModel::where('lead_id', $data->lead_id)->orderBy('date', 'DESC')->first();
                    $data->task = $task;
                    if ($data->task) {
                        return myDate($task->date);
                    }
                })
                ->editColumn('register_date', function ($data) {
                    return myDate($data->register_date);
                })
                ->editColumn('sex', function ($data) {
                    return __('administrator.' . $data->sex);
                })
                ->editColumn('lead_source', function ($data) {
                    $source = LeadSource::find($data->lead_source);
                    return $source ? $source->source_name : '';
                })
                ->editColumn('convert_status', function ($data) use ($request) {
                    if ($data->convert_status == 1) {
                        $status = 'success';
                    } else {
                        if ($data->convert_status != 0) {
                            $status = 'danger';
                        } else {
                            $status = 'warning';
                        }
                    }
                    if ($data->convert_status) {
                        $deal = getDealResult($data->convert_status);
                    } else {
                        $deal = __('administrator.pending');
                    }
                    return '<span class="label label-' . $status . '">' . $deal . ' </span>';
                })
                ->editColumn('task_type', function ($data) use ($request) {
                    if ($data->task) {
                        if ($data->complete_status) {
                            $task_type = 'success';
                        } else {
                            $task_type = 'warning';
                        }
                        if($data->task->task_type)
                        return '<span class="label label-' . $task_type . '">' . __('administrator.' . $data->task->task_type) . ' </span>';
                    }
                })
                ->editColumn('province', function ($data) use ($request) {
                    $province = ProvinceModel::find($data->province);
                    if ($province) {
                        if (if_kh()) {
                            $province = $province->name_kh;
                        } else {
                            $province = $province->name_en;
                        }
                    } else {
                        $province = '';
                    }

                    return $province;
                })
                ->addColumn('agent_name', function ($data) use ($request) {
                    $user = findUser($data->agent_id);
                    return $user->name??'';
                })
                ->addColumn('illness', function ($data) {
                    if ($data->illness) {
                        return getCustomerIllnessJson($data->illness);
                    }
                })
                ->addIndexColumn()
                ->rawColumns(['action', 'convert_status', 'task_type', 'agent_name', 'illness'])
                ->make(true);
        }
        return view('crm.lead.report');
    }
}
