<?php

namespace App\Http\Controllers\Branch;

use App\Model\CustomerModel;
use App\Model\SaleDetailsModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\CurrencyModel;
use App\Model\PaymentDetailModel;
use App\Model\PaymentModel;
use App\Model\product\ColorModel;
use App\Model\product\SizeModel;
use Illuminate\Support\Facades\Session;
use DB;
use Auth;
use App\JournalModel;
use App\Model\StockModel;
use App\Model\SaleModel;
use App\Fun\Fun;
use App\Model\ProductUnitModel;
use App\Model\stock_return\ProductReturnModel;
use App\Model\stock_return\ProductReturnDetailModel;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\ValidationException;

class SaleReturnController extends Controller
{
    // function __construct()
    // {
    //   $this->middleware('permission:POS Wholesale Create', ['only' => ['create', 'store']]);
    //   $this->middleware('permission:POS Wholesale List', ['only' => ['index']]);
    // }

    public function index(Request $request)
    {
        Fun::lang();
        $customer = SaleModel::where('is_role','!=','out_shop')->pluck('customer_id');
        $customer = CustomerModel::whereIn('id',$customer)->pluck('customer_name','id');
        $type = SaleModel::pluck('sale_type', 'sale_type');
        if ($request->ajax()) {
            $search = $request->input('search.value');
            $customer = $request->customer_id;
            $type =  $request->type;
            $from_date = $request->start_date;
            $to_date = $request->end_date;
            $count_total = SaleModel::
          where('is_role','!=','out_shop')
                ->where('status', 1)
                ->count();

            $data = SaleModel::where('is_role','!=','out_shop')
                ->where('status', 1)
                ->where(function ($query) use ($from_date, $to_date) {
                    if ($from_date) {
                        $query->whereDate('nso007_sales.sale_date', '>=', date('Y-m-d', strtotime($from_date)));
                    }
                    if ($to_date) {
                        $query->whereDate('nso007_sales.sale_date', '<=', date('Y-m-d', strtotime($to_date)));
                    }

                })
                ->where(function ($query) use ($customer){
                    if($customer){
                        $query->where('nso007_sales.customer_id',$customer);
                    }
                })
                ->where(function ($query) use ($type) {
                    if ($type) {
                        $query->where('nso007_sales.sale_type', $type);
                    }
                })
                ->orderBy('nso007_sales.id', 'DESC');
            $count_filter = $data->count();
            if ($request->ajax()) {
                return DataTables::of($data->take(20))
                    ->with([
                        "recordsTotal" => $count_total,
                        "recordsFiltered" => $count_filter,
                    ])
                    ->editColumn('customer_phone', function ($data) {
                        $customer = findCustomer($data->customer_id);
                        return $customer != null ? $customer->customer_phone : '';
                    })

                    ->editColumn('customer_id', function ($data) {
                        $customer = findCustomer($data->customer_id);
                        return $customer != null ? $customer->customer_name : '';
                    })
                    ->editColumn('return_status', function ($data) {
                        $status = '';
                        if ($data->return_status==1) {
                            $status = '<span class="label label-danger">' . __('administrator.returned') . '</span>';
                        }else{
                            $status ='';
                        }
                        return $status;
                    })
                    ->editColumn('sale_date', function ($data) {
                        return date('d-m-Y', strtotime($data->sale_date));
                    })
                    ->addColumn('action', function ($data) {

                        $btn = '';
                        $btn_status='';
                        if (Gate::check('Products Show')) {
                            $btn .= '<button title="' . __('administrator.show') . '" class="btn bg-olive btn-flat margin show_invoice" data-url = "' .route("get-wholesale-invoice",$data->id). '"  >' . __('administrator.invoice') . '</button>';
                        }
                        if($data->return_status==0){
                            if (Gate::check('Products Edit')) {
                                $btn_status .= '<button title="' . __('administrator.return_stock') . '" class="button_danger return" data-url = "' .route("get-sale-return-stock-invoice",$data->id). '">' . __('administrator.return_stock') . '</button>';
                            }
                        }else{
                            $btn_status ='';
                        }

                    return $btn.$btn_status;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action' => 'action','return_status'=>'return_status','customer_id' => 'customer_id', 'payment_status' => 'payment_status', 'customer_phone' => 'customer_phone',])
                    ->make(true);
            }
        }
        return view('pos.sale-return-stock.index',compact('type','customer'));
    }

    public function create(){}

    function get_salereturninvoice($id){
        $master = SaleModel::find($id);
        $detail = SaleDetailsModel::where('sale_id',$id)->get();
        return view('pos.sale-return-stock.create',compact('master','detail'))->render();
    }

    public function store(Request $request)
    {

        $this->validate($request, [
            'return_qty.*' =>'required' ,
            'sale_detail_id.*' =>'required' ,
        ]);
        $return_qty = $request->return_qty;
        $total_qty = 0;
        foreach($return_qty as $key=>$row){
            $total_qty+=$row;
        }

        if($total_qty===0){
            throw ValidationException::withMessages(['error' => 'no return qty']);
        }

        $sale_name = findSale($request->sale_id);
        $sale_detail = $request->sale_detail_id;
        $inv = generate_inv('nso007_stock_return','SRT');
        $sale_return = new ProductReturnModel();
        $sale_return->user_id = Auth::user()->id;
        $sale_return->sale_id = $request->sale_id;
        $sale_return->warehouse_id = $sale_name->warehouse_id;
        $sale_return->invoice_number = $inv;
        $sale_return->year = date('Y');
        $sale_return->return_date = date('Y-m-d');
        $sale_return->status =1;

        $sale_return->save();
        $sale_return_detail = $sale_return->id;


        $check = 0;
        $message = [];
        $count_message = 0;
        foreach ($sale_detail as $key => $detail_id) {
            $sale_detail_data = SaleDetailsModel::find($detail_id);
            if($sale_detail_data->qty >=$return_qty[$key]){
                $check++;
            }else{
                $count_message++;
                $message[$key]= ($sale_detail_data->barcode) . ' return qty is invalid.';
            }
        }
        if(count($sale_detail) == $check){
            foreach ($sale_detail as $key => $detail_id) {
                $sale_detail_data = SaleDetailsModel::find($detail_id);
                if($sale_detail_data->qty >=$return_qty[$key]){
                    if($return_qty[$key]>0){
                        $st_detail =array(
                            'stock_return_id' => $sale_return_detail,
                            'qty' => $return_qty[$key],
                            'barcode' => $sale_detail_data->barcode,
                            'created_at' => date('Y-m-d h:i:s'),
                            'updated_at' => date('Y-m-d h:i:s'),
                        );
                        ProductReturnDetailModel::insert($st_detail);
                        $stock = StockModel::where([
                            'warehouse_id' => $sale_name->warehouse_id,
                            'product_id' => $sale_detail_data->product_id,
                            'barcode' => $sale_detail_data->barcode,
                            ])->first();

                        if ($stock->stock_qty >= $return_qty[$key]) {
                            $stock->stock_qty +=$return_qty[$key];
                            $stock->save();
                        }
                    }
                }
            }
        }

        if($count_message==0){
            $sale = $sale_name->update(['return_status'=>1]);
            PaymentModel::where('invoice_id',$sale)
            ->where('type','pos')
            ->orwhere('type','wholesale')
            ->update(['return_status'=>1]);
            session()->put('success', 'Record was added successfully');
            return response()->json(['status'=>'success']);
        }else{
            throw ValidationException::withMessages($message);
        }


    }

}

