<?php

    namespace App\Http\Controllers\Branch;

    use App\BranchModel;
    use App\Http\Controllers\Controller;
    use App\Model\product\ShelfModel;
    use App\Model\ProductUnitModel;
    use App\Model\PurchaseDetailsModel;
    use App\Model\SaleDetailsModel;
    use App\Model\stock_inventory\ItemRequestDetailModel;
    use App\Model\stock_inventory\ItemRequestModel;
    use App\Model\StockByDateModel;
    use App\Model\StockModel;
    use App\Model\TransferStockDetailModel;
    use App\User;
    use Auth;
    use Illuminate\Http\Request;
    use Yajra\DataTables\DataTables;

    class ReportStockController extends Controller
    {
        public function index(Request $request)
        {
            $shelf = StockModel::pluck('shelf');
            $shelf = ShelfModel::whereIn('id', $shelf)->pluck('name', 'id');
            $type = 'admin';
            return view('branch.stock_report.index', compact('shelf', 'type'));
        }

        public function member_stock()
        {
            $shelf = StockModel::pluck('shelf');
            $shelf = ShelfModel::whereIn('id', $shelf)->pluck('name', 'id');
            $type = 'member';
            return view('branch.stock_report.index', compact('shelf', 'type'));
        }
        public function get_stock(Request $request)
        {
            if ($request->ajax()) {
                $branch_id = $request['branch_id'];
                $product_unit_id = $request['product_unit_id'];
                $shelf_id = $request['shelf_id'];
                $type = $request['type'];
                $ifMember = ifMember();
                $child_member = User::where('leader_id',Auth::id())->pluck('id');
                $show_c = $request['show'];
                $stocks = StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                    ->join('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                    ->leftjoin('nso007_shelf', 'nso007_stocks.shelf', 'nso007_shelf.id')
                    ->selectRaw('
                        SUM(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit) as parent_qty,
                        nso007_product_unit.id,
                        nso007_stocks.shelf,
                        nso007_stocks.branch_id,
                        nso007_stocks.member_id,
                        product_name,
                        nso007_product_unit.item_code,
                        nso007_product_unit.qty_per_unit,
                        nso007_shelf.name as shelf_name,
                        nso007_unit.unit,
                        nso007_unit.id as unit_id
                        ')
                    ->where(function ($query) use ($type) {
                        if ($type === 'member') {
                            $query->where('nso007_shelf.member_id', '!=', null);
                        } else {
                            $query->where(['nso007_shelf.member_id' => null]);
                        }
                    })
                    ->where(function ($query) use ($ifMember,$type,$show_c,$child_member) {
                        if ($ifMember) {
                            if ($type === 'member') {
                                $query->where('nso007_shelf.member_id', Auth::id());
                            }else{
                                if($show_c){
                                    $query->whereIn('nso007_stocks.member_id', $child_member);
                                }else{
                                    $query->where('nso007_stocks.member_id', Auth::id());
                                }
                            }
                        } else {
                            $query->where('nso007_stocks.branch_id', FindBranchID());
                        }
                    })
                    ->where(function ($query) use ($branch_id) {
                        if ($branch_id) {
                            $query->where('nso007_stocks.branch_id', $branch_id);
                        }
                    })
                    ->where(function ($query) use ($product_unit_id) {
                        if ($product_unit_id) {
                            $query->where('nso007_stocks.product_unit_id', $product_unit_id);
                        }
                    })
                    ->where(function ($query) use ($shelf_id) {
                        if ($shelf_id) {
                            $query->where('nso007_stocks.shelf', $shelf_id);
                        }
                    })
                    ->groupby(['nso007_stocks.product_unit_id', 'nso007_stocks.shelf', 'nso007_stocks.member_id']);
                $count = $stocks->get()->count();
                return DataTables::of($stocks->take(20))
                    ->with([
                        "recordsTotal" => $count,
                        "recordsFiltered" => $count
                    ])
                    ->editColumn('product_name', function ($stock) {
                        return $stock->product_name;
                    })
                    ->editColumn('member_id', function ($stock) {
                        return findUser($stock->member_id)->name??'';
                    })
                    ->addColumn('balance', function ($stock) {
                        $stock->unit = findUnit(ProductUnitModel::find($stock->id)->unit_id ?? 0);
                        $stock->unit = $stock->unit->unit ?? '';
                        return $stock->parent_qty . ' ' . $stock->unit;
                    })
                    ->addColumn('stock_in', function ($stock) use ($type, $ifMember) {
                        if ($type === 'member') {
                            $stock_in = SaleDetailsModel::join('nso007_sales', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                                ->where(['product_unit_id' => $stock->id, 'nso007_sales.member_shelf' => $stock->shelf, 'branch_id' => $stock->branch_id])
                                ->sum('store_qty');
                            return $stock_in . ' ' . $stock->unit;
                        }
                        if ($ifMember) {
                            $stock_in = ItemRequestDetailModel::join('nso007_item_request', 'nso007_item_request_detail.request_id', 'nso007_item_request.id')
                                ->where(['product_unit_id' => $stock->id, 'delivery_to_member' => $stock->member_id, 'confirm_status' => 'received'])
                                ->sum('qty');
                            $stock_in += SaleDetailsModel::join('nso007_sales', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                                ->where(['product_unit_id' => $stock->id, 'delivery_to_member' => $stock->member_id, 'confirm_receive' => 'received'])
                                ->sum('deliver_qty');
                        } else {
                                $stock_in = PurchaseDetailsModel::join('nso007_purchases', 'nso007_purchases.id', 'nso007_purchase_details.purchase_id')
                                    ->where(['product_unit_id' => $stock->id, 'shelf' => $stock->shelf, 'branch_id' => $stock->branch_id,'confirm_receive'=>'received'])
                                    ->sum('qty');
                        }
                        return $stock_in . ' ' . $stock->unit;
                    })
                    ->addColumn('stock_out', function ($stock) use ($type, $ifMember) {
                        if ($type === 'member') {
                            $stock_out = ItemRequestDetailModel::join('nso007_item_request', 'nso007_item_request_detail.request_id', 'nso007_item_request.id')
                                ->where(['product_unit_id' => $stock->id, 'shelf' => $stock->shelf, 'branch_id' => $stock->branch_id, 'status' => 'approved'])
                                ->sum('qty');
                            return $stock_out . ' ' . $stock->unit;
                        }


                        if ($ifMember) {
                            $stock_out = SaleDetailsModel::join('nso007_sales', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                                ->where(['product_unit_id' => $stock->id, 'user_id' => $stock->member_id])
                                ->sum('qty');
                        } else {
                            $stock_out = SaleDetailsModel::join('nso007_sales', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                                ->where(['product_unit_id' => $stock->id, 'shelf' => $stock->shelf, 'branch_id' => $stock->branch_id])
                                ->sum('qty');
                        }
                        return $stock_out . ' ' . $stock->unit;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['image', 'balance', 'branch', 'stock_in', 'stock_out'])
                    ->make(true);
            }
        }


    }
