<?php


namespace App\Http\Controllers\Branch;

use App\CurrencyModel;
use App\Model\PaymentDetailModel;
use App\Model\PaymentModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use DB;
use Auth;
use DataTables;
use App\Model\SupplierTypeModel;
use App\Model\SupplierModel;
use App\Model\ProductModel;
use App\Model\PurchaseDetailsModel;
use App\Model\PurchaseModel;
use App\Model\StockModel;
use App\Fun\Fun;
use App\Model\JournalModel;
use App\Model\NextPaymentModel;
use App\Model\WarehouseModel;
use App\Model\ProductUnitModel;


class PurchaseController extends Controller

{

    function __construct()

    {
        $this->middleware('permission:Purchase', ['only' => ['show', 'index', 'create', 'store']]);
        Fun::lang();
    }


    public function index()

    {

        return view('branch.pos.purchases.index');

    }

    public function datatable_purchases_list(Request $request)
    {
        Fun::lang();
        $search         = $request->input('search.value');
        $type           = $request->type;
        $supplier       = $request->supplier;
        $count_total    = PurchaseModel::where(['nso007_purchases.status' => 1])->count();
        $data           = PurchaseModel::where(['nso007_purchases.status' => 1])
                        ->where(function ($query) use ($type) {
                            if($type){
                                $query->Where('nso007_purchases.type',  $type);
                            }

                        })
                        ->where(function ($query) use ($supplier) {
                            if($supplier){
                                $query->Where('nso007_purchases.supplier_id',  $supplier);
                            }
                        })
                        ->where(function ($query) use ($search) {
                            $query->orWhere('nso007_purchases.invoice_number', 'LIKE', '%' . $search . '%');
                            $query->orWhere('nso007_purchases.transaction_code', 'LIKE', '%' . $search . '%');
                        })
                        ->orderBy('nso007_purchases.id', 'DESC');
        $count_filter = $data->count();
        if ($request->isMethod('get')) {

            return Datatables::of($data->take(20))
                ->with([
                    "recordsTotal"      => $count_total,
                    "recordsFiltered"   => $count_filter,
                ])
                ->addColumn('supplier_name', function ($purchase) {
                    return findSupplier($purchase->supplier_id)->supplier_name;
                })
                ->addColumn('supplier_phone', function ($purchase) {
                    return findSupplier($purchase->supplier_id)->supplier_phone;
                })
                ->addColumn('paid', function ($purchase) {
                    $paid_kh        = $purchase->paid_kh > 0 ? $purchase->paid_kh : 0;
                    $paid_usd       = $purchase->paid_usd > 0 ? $purchase->paid_usd : 0;
                    $paid_baht      = $purchase->paid_baht > 0 ? $purchase->paid_baht : 0;
                    $total_paid     = ($paid_kh > 0 ? ($paid_kh / $purchase->rate) : 0) + $paid_usd + ($paid_baht > 0 ? ($paid_baht / $purchase->rate_baht) : 0) ;
                    return '$' . number_format($total_paid, 2);
                })
                ->addColumn('remain', function ($purchase) {
                    $paid_kh        = $purchase->paid_kh > 0 ? $purchase->paid_kh : 0;
                    $paid_usd       = $purchase->paid_usd > 0 ? $purchase->paid_usd : 0;
                    $paid_baht      = $purchase->paid_baht > 0 ? $purchase->paid_baht : 0;
                    $total_paid     = ($paid_kh > 0 ? ($paid_kh / $purchase->rate) : 0) + $paid_usd + ($paid_baht > 0 ? ($paid_baht / $purchase->rate_baht) : 0) ;
                    $total          = getPurchaseTotal($purchase);
                    $remain         = $total - $total_paid;
                    return '$' . number_format(($remain > 0 ? $remain : 0), 2);
                })
                ->addColumn('total', function ($purchase) {
                    return '$' . number_format(getPurchaseTotal($purchase), 2);
                })
                ->addColumn('purchase_date', function ($purchase) {

                    return date('d-m-Y', strtotime($purchase->purchase_date));

                })
                ->addColumn('invoice_number', function ($purchase) {
                    return '<a href="' . route("purchases.show", $purchase->id) . '" title="Edit" class="button_info">' . $purchase->invoice_number . '</a>';
                })
                ->editColumn('payment_status', function ($sales) {
                    $status = '';
                    if ($sales->payment_status == 'due') {
                        $status = '<span class="label label-danger">' . __('administrator.due') . '</span>';
                    }
                    if ($sales->payment_status == 'paid') {
                        $status = '<span class="label label-success">' . __('administrator.paid') . '</span>';
                    }
                    if ($sales->payment_status == 'partial') {
                        $status = '<span class="label label-info">' . __('administrator.partial') . '</span>';
                    }

                    return $status;

                })
                ->addColumn('action', function ($purchase) {
                    $check_language = Fun::lang();
                    if ($check_language == 'km') {
                        $show = 'មើល';
                    } else {
                        $show = 'Show';
                    }
                    return '<a href="' . route("purchases.show", $purchase->id) . '" title="Edit" class="button_warning">' . $show . '</a>';
                })
                ->addIndexColumn()
                ->rawColumns(['invoice_number' => 'invoice_number', 'action' => 'action', 'paid' => 'paid', 'remain' => 'remain', 'payment_status' => 'payment_status', 'total' => 'total', 'supplier_name' => 'supplier_name', 'supplier_phone' => 'supplier_phone'])
                ->make(true);
        }
    }

    public function show($id)
    {
        // Purchases
        $purchases = PurchaseModel::find($id);
        $supplier_id = $purchases->supplier_id;
        // Find Supplier Type
        $supplier_type = SupplierModel::join('nso007_supplier_type', 'nso007_supplier_type.id', '=', 'nso007_suppliers.supplier_type_id')
            ->where('nso007_suppliers.id', $supplier_id)
            ->first();
        // Purchase Details
        $purchase_details = PurchaseDetailsModel::select('nso007_suppliers.*', 'nso007_purchase_details.*', 'nso007_products.product_name', 'nso007_unit.unit')
            ->join('nso007_purchases', 'nso007_purchases.id', '=', 'nso007_purchase_details.purchase_id')
            ->join('nso007_unit', 'nso007_unit.id', '=', 'nso007_purchase_details.unit_id')
            ->join('nso007_products', 'nso007_products.id', '=', 'nso007_purchase_details.product_id')
            ->join('nso007_suppliers', 'nso007_suppliers.id', '=', 'nso007_purchases.supplier_id')
            ->where(['nso007_purchase_details.status' => 1])
            ->where(['nso007_purchase_details.purchase_id' => $id])
            ->get();
        return view('branch.pos.purchases.show', compact('purchase_details', 'purchases', 'supplier_type'));

    }

}

