<?php

    namespace App\Http\Controllers\Branch;

    use App\Fun\Fun;
    use App\Http\Controllers\Controller;
    use App\Model\Accounting\AccountChartModel;
    use App\Model\Accounting\JournalModel;
    use App\Model\CostOfSoldModel;
    use App\Model\PaymentDetailModel;
    use App\Model\PaymentModel;
    use App\Model\product\ShelfModel;
    use App\Model\ProductModel;
    use App\Model\ProductUnitModel;
    use App\Model\PurchaseDetailsModel;
    use App\Model\PurchaseModel;
    use App\Model\SaleDetailsModel;
    use App\Model\SaleModel;
    use App\Model\setup\MemberTypeModel;
    use App\Model\StockModel;
    use Auth;
    use Carbon\Carbon;
    use DB;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Http\Request;
    use Illuminate\Validation\ValidationException;
    use Yajra\DataTables\DataTables;

    class POSWholesaleController extends Controller
    {
        function __construct()
        {
            Fun::lang();
//        $this->middleware('permission:POS Wholesale Create', ['only' => ['create', 'store']]);
//        $this->middleware('permission:POS Wholesale List', ['only' => ['index']]);
        }

        public function index(Request $request)
        {
            return view('pos.pos-wholesale.index');
        }

        public function reciept()
        {
            return view('pos.pos-wholesale.reciept');
        }

        public function history()
        {
            return view('pos.pos-wholesale.history');
        }

        public function datatables(Request $request)
        {
            if ($request->ajax()) {
                $payment_status = $request->payment_status;
                $from_date = $request->from_date;
                $to_date = $request->to_date;
                $user = $request->user_id;
                $reference_invoice = $request->reference_invoice;
                $payment_type = $request->payment_type;

                $data = SaleModel::
                join('users as seller', 'nso007_sales.user_id', 'seller.id')
                    ->join('users as member', 'nso007_sales.member_id', 'member.id')
                    ->where(function ($q) {
                        if (ifMember()) {
                            $q->where('nso007_sales.user_id', Auth::id());
                        }else{
                            $q->where('nso007_sales.branch_id', FindBranchID());
                        }
                    })
                    ->where(function ($q) {
                        $q->where('nso007_sales.sale_type', 'wholesale');
                    })
                    ->where(function ($q) use ($request, $payment_status) {
                        if ($request->pos_history) {
                            if ($payment_status) {
                                $q->where('nso007_sales.payment_status', $payment_status);
                            }
                        } else {
                            if ($request->type === 'paid') {
                                $q->where('nso007_sales.payment_status', 'paid');
                            } else {
                                $q->where('nso007_sales.payment_status', '!=', 'paid');
                            }
                        }
                    })
                    ->where(function ($query) use ($payment_type) {
                        if ($payment_type) {
                            $query->where('nso007_sales.payment_type', $payment_type);
                        }
                    })
                    ->when($request['payment_status'],function ($q) use ($request) {
                        $q->where('nso007_sales.payment_status',$request['payment_status']);
                    })
                    ->where(function ($query) use ($user) {
                        if ($user) {
                            $query->where('nso007_sales.user_id', $user);
                        }
                    })
                    ->where(function ($query) use ($reference_invoice) {
                        if ($reference_invoice) {
                            $query->where('nso007_sales.invoice_number', 'like', '%' . $reference_invoice . '%');
                            $query->orwhere('nso007_sales.reference_number', 'like', '%' . $reference_invoice . '%');
                        }
                    })
                    ->where(function ($query) use ($from_date, $to_date) {
                        if ($from_date) {
                            $query->where('nso007_sales.sale_date', '>=', date('Y-m-d', strtotime($from_date)));
                        }
                        if ($to_date) {
                            $query->where('nso007_sales.sale_date', '<=', date('Y-m-d', strtotime($to_date)));
                        }
                    })
                    ->selectRaw('
                            seller.name as seller,
                            member.name as member,
                            nso007_sales.*
                            ')
                    ->orderBy('nso007_sales.sale_date', 'DESC');
                $count = $data->count();
                return DataTables::of($data->take(20))
                    ->with([
                        "recordsTotal" => $count,
                        "recordsFiltered" => $count,
                    ])
                    ->addColumn('action', function ($action) use ($request) {
                        $btn = '';
                        $payment = PaymentModel::where(['invoice_id' => $action->id, 'type' => $action->sale_type])->first();
                        $p_id = $payment->id ?? 0;
                        $action->check_status = $action->payment_status;

                        if (!$action->status == 1 || !$action->status == 0) {
                            $btn .= '<i href="javascript:;"
                            data-href="' . route('get-wholesale-invoice', $action->id) . '?payment_status=' . $action->payment_status . '"
                            data-status="' . $action->check_status . '"
                            class="fa fa-eye btn btn-sm btn-info showDetail"
                            data-id="' . $action->id . '"
                            data-get_payment_url = "' . route("payment.edit", $p_id) . '"
                            data-payment_id= "' . $p_id . '",
                            title="View Detail"></i>
                            <a href="' . route('get-wholesale-invoice', $action->id) . '?payment_status=' . $action->payment_status . '&print_ex=1"
                            class="fa fa-external-link btn btn-sm btn-success"
                            title="View Detail" target="_blank"></a>';
                        }
                        if (1==2) {
                            $btn .= ' <a type="button" class="fa fa-edit btn btn-sm btn-warning btn_edit" href="' . route('wholesale.edit', $action->id) . '" title="Edit"></a>';
                            $btn .= ' <button type="button" class="fa fa-trash btn btn-sm btn-danger btn_delete" data-href="' . route('delete-whole-sale', $action->id) . '" title="Delete"></button>';
                        }

                        return $btn;
                    })
                    ->editColumn('sale_date', function ($action) {
                        return date('d-m-Y', strtotime($action->sale_date));
                    })
                    ->editColumn('payment_status', function ($action) {
                        return getPaymentStatus($action->payment_status);
                    })
                    ->addColumn('paid_amount_usd', function ($action) {
                        return number_format($action->paid_amount_usd, 2) . '$';
                    })
                    ->addColumn('grand_total', function ($action) {
                        return number_format($action->grand_total, 2) . '$';
                    })
                    ->addColumn('remain', function ($action) {
                        return number_format(($action->grand_total - $action->paid_amount_usd), 2) . '$';
                    })
                    ->editColumn('payment_method', function ($action) {
                        $acc = AccountChartModel::find($action->payment_method);
                        return $acc->acc_name ?? '';
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'payment_status', 'status'])
                    ->make(true);
            }
        }

        public function create(Request $request)
        {
            //Select Item Code (product_unit_id)
            if ($request->product_unit_id) {
                $shelf = StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                    ->join('nso007_shelf', 'nso007_shelf.id', 'nso007_stocks.shelf')
                    ->join('nso007_unit', 'nso007_unit.id', 'nso007_product_unit.unit_id')
                    ->selectRaw('CONCAT(nso007_shelf.name," | ",round(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit),nso007_unit.unit) as name,nso007_shelf.id,round(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit) as stock_qty')
                    ->where(['nso007_stocks.product_unit_id' => $request['product_unit_id'], 'nso007_stocks.branch_id' => FindBranchID()])
                    ->where('nso007_shelf.member_id',null)
                    ->groupBy('shelf')
                    ->get();
                $product_unit = ProductUnitModel::find($request['product_unit_id']);
                $product = getProductById($product_unit->product_id);
                return response()->json(['shelf' => $shelf, 'price' => $product_unit->retail_price, 'default_shelf' => $product->shelf]);
            }

            //Select Product
            if ($request->select_product) {
                $product = getProductById($request->select_product);
                $item_code = StockModel::where('nso007_stocks.product_id', $request->select_product)
                    ->join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                    ->leftjoin('nso007_shelf', 'nso007_shelf.id', 'nso007_stocks.shelf')
                    ->join('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                    ->where(function ($q) {
                        if (ifMember()) {
                            $q->where('nso007_stocks.member_id', Auth::id());
                        } else {
                            $q->where('nso007_stocks.branch_id', FindBranchID());
                            $q->where('nso007_shelf.member_id',null);
                        }
                    })
                    ->selectRaw((ifMember()?'CONCAT(nso007_stocks.item_code," | ",nso007_stocks.stock_qty,nso007_unit.unit)':'nso007_stocks.item_code').' as text,nso007_stocks.product_unit_id,nso007_stocks.item_code,nso007_stocks.stock_qty,nso007_stocks.member_id')
                    ->get();
                return response()->json(['product_name' => $product->product_name, 'item_code' => $item_code]);
            }
            //on change member or member_type
            if ($request->getDis) {
                if ($request->member_type) {
                    $member_type = MemberTypeModel::find($request->member_type);
                    return response()->json(['discount' => $member_type->discount]);
                }
                if ($request->member) {
                    $member = findUser($request->member);
                    $member_type = MemberTypeModel::find($member->member_type_id);
                    return response()->json(['discount' => $member_type->discount, 'member_type_id' => $member->member_type_id]);
                }
                return response()->json(['member_type_id' => $member->member_type_id??'']);
            }

            if ($request->ajax()) {
                $search = $request->search;
                $stock_item = StockModel::join('nso007_product_unit', 'nso007_product_unit.id', 'nso007_stocks.product_unit_id')
                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                    ->leftjoin('nso007_shelf', 'nso007_shelf.id', 'nso007_stocks.shelf')
                    ->where(function ($q){
                        if(ifMember()){
                            $q->where('nso007_stocks.member_id', Auth::id());
                        }else{
                            $q->where('nso007_stocks.branch_id', FindBranchID());
                        }
                    })
                    ->where('nso007_products.delete', 0)
                    ->where(function ($q) use ($search) {
                        if ($search) {
                            $q->where('nso007_products.product_name', 'like', '%' . $search . '%');
                        }
                    })
                    ->where('nso007_shelf.member_id',null)
                    ->selectRaw('sum(nso007_stocks.stock_qty/nso007_product_unit.qty_per_unit) as total_stock,
                                        nso007_product_unit.qty_per_unit,
                                        nso007_products.image,
                                        nso007_products.product_name,
                                        nso007_products.id,
                                        nso007_product_unit.barcode
                                        ')
                    ->groupBy('nso007_products.id')
                    ->paginate(20);
                $html = view('pos.pos-wholesale.result-create', compact('stock_item'))->render();
                return response()->json(['html' => $html]);
            }

            session()->put('if_wholesale_edit', 0);
            $acc_chart = AccountChartModel::whereIn('id', ['11001', '11002'])->pluck((if_kh() ? 'acc_namekh' : 'acc_name'), 'id');
            if ($request['poreq']) {
                $master = PurchaseModel::find(decrypt($request['poreq']));
            } else {
                $master = null;
            }
            return view('pos.pos-wholesale.create', compact('acc_chart', 'master'));
        }

        public function edit($id)
        {
            $master = SaleModel::find($id);
            $acc_chart = AccountChartModel::whereIn('id', ['11001', '11002'])->pluck((if_kh() ? 'acc_namekh' : 'acc_name'), 'id');

            return view('pos.pos-wholesale.edit', compact('master',  'acc_chart'));
        }

        public function update($id, Request $request)
        {
            $sale = findSale($id);
            $this->store($request, $sale);
            $this->destroy($sale->id, 1);
            return response()->json(['route' => route('wholesale.history'), 'status' => 'ok']);
        }

        public function show($id)
        {
            $saleProduct = session()->forget('showProduct');
            $data = SaleModel::leftJoin('nso007_warehouse', 'nso007_sales.warehouse_id', 'nso007_warehouse.id')
                ->leftJoin('nso007_member', 'nso007_sales.customer_id', 'nso007_member.id')
                ->leftJoin('users', 'nso007_member.user_id', 'users.id')
                ->leftJoin('nso007_hr_branch', 'users.branch_id', 'nso007_hr_branch.id')
                ->leftJoin('users as seller', 'nso007_sales.user_id', 'seller.id')
                ->leftJoin('nso007_payment', 'nso007_sales.id', 'nso007_payment.invoice_id')
                ->join('nso007_sale_details', 'nso007_sale_details.sale_id', 'nso007_sales.id')
                ->orderBy('id', 'desc')
                ->selectRaw('package_id, paid_amount, nso007_sale_details.status as sale_detail_status, nso007_sales.status as sale_status, nso007_sales.discount, nso007_sale_details.id as sale_detail_id, nso007_sale_details.qty, nso007_sale_details.dis, nso007_sale_details.sale_price, nso007_sales.discount, invoice_number, nso007_sale_details.product_id, warehouse_name, nso007_hr_branch.name as branch_name, users.name as member, seller.name as seller, nso007_sales.id, nso007_sales.status, nso007_sales.payment_status, paid_amount_kh, paid_amount_usd')
                ->where('nso007_sales.id', $id)
                ->where('nso007_payment.type', '!=', 'purchase')
                ->get();

            foreach ($data as $item) {
                $product_unit = \DB::table('nso007_product_unit')
                    ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                    ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                    ->selectRaw('nso007_product_unit.cur, image, product_name, unit, nso007_product_unit.id, nso007_product_unit.barcode, wholesale_price')
                    ->where('nso007_product_unit.id', $item['product_unit_id'])
                    ->first();

                $saleProduct[$item['product_unit_id']] = [
                    "id" => $item['product_unit_id'],
                    "unit" => $product_unit->unit,
                    "name" => $product_unit->product_name . '(' . $product_unit->barcode . ')',
                    "qty" => $item['qty'],
                    "paid_usd" => $item['paid_amount'],
                    "paid_kh" => $item['paid_amount_kh'],
                    "cur" => $product_unit->cur,
                    "cost" => $item['sale_price'],
                    "discount" => $item['dis'],
                    "total" => 0,
                    "dis" => $item['discount'],
                    "sale_detail_status" => $item['sale_detail_status'],
                    "sale_status" => $item['sale_status'],
                    "package_id" => $item['package_id'],
                ];
                session()->put('showProduct', $saleProduct);
            }
            $saleProduct = session()->get('showProduct');
            $view = view('pos.pos-wholesale.show', compact('saleProduct'))->render();
            $show_report = view('pos.pos-wholesale.show_report', compact('saleProduct'))->render();
            return response()->json(['html' => $view, 'show_report' => $show_report]);
        }

        public function store(Request $request, $edit = null)
        {
            $check1 = $request['payment_type'] === 'pay_now' ? 'required' : 'nullable';
            $this->validate($request, [
                'member_id' => 'required|exists:users,id',
                'member_type_id' => 'required|exists:nso007_member_type,id',
                'date' => 'required',
                'payment_type' => 'required',
                'payment_method' => $check1,
                'paid_usd' => $check1,
                'grand_total' => 'required',
                'product_unit_id' => 'required',
                'product_unit_id.*' => 'required',
                'shelf.*' => ifMember()?'nullable':'required|exists:nso007_shelf,id',
                'qty.*' => 'required',
                'price.*' => 'required',
            ], [
                'shelf.*.required' => __('administrator.shelf') . ' ' . __('administrator.field is required.'),
                'price.*.required' => __('administrator.price') . ' ' . __('administrator.field is required.'),
                'qty.*.required' => __('administrator.qty') . ' ' . __('administrator.field is required.'),
                'product_unit_id.*.required' => __('administrator.item_code') . ' ' . __('administrator.field is required.'),
            ]);
            foreach ($request['product_unit_id'] as $key => $item) {
                if(ifMember()){
                    $stock = StockModel::where(['member_id'=>Auth::id(),'product_unit_id'=>$item])->first();
                }else{
                    $stock = StockModel::where(['shelf'=>$request['shelf'][$key],'product_unit_id'=>$item,'type'=>'admin'])->first();
                }

                $punit = ProductUnitModel::find($item);
                $product = getProductById($punit->product_id)->product_name??'';
                if(!$stock){
                    throw ValidationException::withMessages(['field_name' => $product.' | '.$punit->item_code.' don\'t have stock']);
                }
                if($stock->stock_qty<$request['qty'][$key]){
                    throw ValidationException::withMessages(['field_name' => $product.' | '.$punit->item_code.' not enough qty']);
                }
            }
            $member_id = $request['member_id'];
            $member_shelf = ShelfModel::where('member_id', $member_id)->first()->id ?? '';
            if(!$member_shelf){
                throw ValidationException::withMessages(['field_name' => 'Member don\'t have shelf']);
            }
            $member_type_id = $request['member_type_id'];
            $mybranch = $edit->branch_id ?? FindBranchID();
            $user_id = $edit->user_id ?? Auth::id();

            $discount = $request['discount'];
            $grand_total = $request['grand_total'];
            $paid = $request['paid_usd'];

            if ($paid >= $grand_total) {
                $payment_status = 'paid';
            } else {
                if ($paid > 0) {
                    $payment_status = 'partial';
                } else {
                    $payment_status = 'due';
                }
            }
            if ($request['payment_type'] === 'pay_later') {
                $payment_method = '11003';
            } else {
                $payment_method = $request['sub_payment_method'] ?? $request['payment_method'];
            }
            $purchase = PurchaseModel::find($request['purchase_id']);
            $if_pay_later = $request['payment_type'] === 'pay_later';
            $pos = new SaleModel;
            $pos->user_id = $user_id;
            $pos->purchase_request_id = $request['purchase_id'];
            $pos->branch_id = $mybranch;
            $pos->member_id = $member_id;
            $pos->delivery_to_member = $purchase->delivery_to_member??$member_id;
            $pos->member_shelf = $member_shelf;
            $pos->member_type_id = $member_type_id;
            $pos->payment_status = $payment_status;
            $pos->reference_number = refNumber(Auth::id(),'ref','REF');
            $pos->invoice_number = $if_pay_later?refNumber(Auth::id(),'inv','INV'):'';
            $pos->receipt_number = !$if_pay_later?refNumber(Auth::id(),'receipt','REC'):'';
            $pos->year = date('Y');
            $pos->rate = currencyExchange();
            $pos->sale_type = 'wholesale';
            $pos->paid_amount_usd = $paid;
            $pos->discount = $discount;
            $pos->subtotal = $request['subtotal'];
            $pos->grand_total = $request['grand_total'];
            $pos->remain = $request['grand_total'] - $paid;
            $pos->sale_date = sDate($request->date);
            $pos->status = 1;
            $pos->note = $request['note'];
            $pos->payment_type = $request['payment_type'];
            $pos->payment_method = $payment_method;
            $pos->type = 'branch';
            $pos->confirm_receive = $purchase?'pending':'received';
            $pos->save();
            $member = findUser($pos->member_id);

            //if purchase request
            if ($purchase) {
                PurchaseDetailsModel::where('purchase_id', $purchase->id)->delete();

                $purchase->status = 'approved';
                $purchase->confirm_receive = 'pending';
                $purchase->paid_usd = $pos->paid_amount_usd;
                $purchase->payment_status = $paid >= $grand_total ? 'paid' : 'owe';
                $purchase->update();
                // payment for last request
                $payment = new PaymentModel();
                $payment->user_id = Auth::id();
                $payment->payment_invoice = $purchase->invoice_number;
                $payment->invoice_id = $purchase->id;
                $payment->payment_date = date('Y-m-d');
                $payment->payment_amount = $purchase->grand_total;
                $payment->paid_amount = $purchase->paid_usd;
                $payment->payment_status = $purchase->payment_status;
                $payment->year = date('Y');
                $payment->status = 1;
                $payment->type = 'purchase';
                $payment->save();
                if($purchase->member_purchase_id){
                    PurchaseModel::where('member_purchase_id',$purchase->member_purchase_id)->update(['confirm_receive'=>'received','status'=>'approved']);
                    PurchaseModel::where('id',$purchase->member_purchase_id)->update(['status'=>'approved','confirm_receive'=>'pending']);

                    $purchase_process = PurchaseModel::where('member_purchase_id',$purchase->member_purchase_id)->pluck('id');
                    PurchaseDetailsModel::where('purchase_id', $purchase->member_purchase_id)->delete();//old first purchase
                    PurchaseDetailsModel::whereIn('purchase_id', $purchase_process)->delete();//old purchase process
                }

            }
            //==========================
            $j = JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
            foreach ($request['product_unit_id'] as $key => $item) {
                if(ifMember()){
                    $deliver_qty = $request['qty'][$key];
                    $store_qty = 0;
                }else{
                    $deliver_qty = $request['deliver_qty'][$key];
                    $store_qty = $request['store_qty'][$key];
                }
                $pos_detail = new SaleDetailsModel;
                $pos_detail->sale_id = $pos->id;
                $pos_detail->product_unit_id = $item;
                $pos_detail->shelf = $request['shelf'][$key];
                $pos_detail->qty = $request['qty'][$key];
                $pos_detail->deliver_qty = $deliver_qty;
                $pos_detail->store_qty = $store_qty;
                $pos_detail->currency_id = 2;
                $pos_detail->sale_price = $request['price'][$key];
                $pos_detail->total = $request['total_price'][$key];
                $pos_detail->save();

                $product_unit = ProductUnitModel::find($pos_detail->product_unit_id);

                // Member PO to admin => minus stock admin and delivery to member wait for member confirm received
                // admin sale to member => cut stock admin and add stock to member
                if(ifMember()){
                    adjStockMember(Auth::id(), $item, -$pos_detail->qty); // cut stock from Member
                }else {
                    adjStockAdmin(mainBranch()->id, $pos_detail->shelf, $item, -$pos_detail->qty); //cut stock from TL
                }
                if ($store_qty) {
                    adjStockAdmin(mainBranch()->id, $pos->member_shelf, $item, $store_qty); // add stock member to shelf
                }
                if($deliver_qty){
                    if(!$pos->purchase_request_id){
                        adjStockMember($pos->member_id, $item, $deliver_qty); // deliver item to Member
                    }
                }
                if ($pos->purchase_request_id) { //if request order
                    $purchase_array = [];
                    if($purchase){
                        $purchase_array['purchase_id'] = $purchase->id;
                        $purchase_array['product_unit_id'] = $pos_detail->product_unit_id;
                        $purchase_array['qty'] = $pos_detail->qty;
                        $purchase_array['deliver_qty'] = $deliver_qty;
                        $purchase_array['store_qty'] = $store_qty;
                        $purchase_array['cost'] = $pos_detail->sale_price;
                        $purchase_array['shelf'] = $pos_detail->shelf;
                        PurchaseDetailsModel::create($purchase_array);
                        if($purchase->member_purchase_id){
                            foreach($purchase_process as $item){
                                $purchase_array['purchase_id'] = $item;
                                PurchaseDetailsModel::create($purchase_array);
                            }
                            $purchase_array['purchase_id'] = $purchase->member_purchase_id;
                            PurchaseDetailsModel::create($purchase_array);
                        }
                    }
                }
                //===================================== Account ========================================================

                //find cost of goods sold
                $cog = CostOfSoldModel::where(['member_id' => $pos->member_id, 'product_unit_id' => $pos_detail->product_unit_id])->first();
                $product = getProductById($product_unit->product_id);
                $cost = $cog->cost ?? $product_unit->cost;
                if ((int)$pos_detail->unit_id !== (int)$product_unit->unit_id) {
                    $cost /= $product_unit->qty_per_unit;
                }
                if ($key === 0) {
                    $last_id = 0;
                } else {
                    $last_id = JournalModel::selectRaw("Max(journal_parentid) as last_num")->first();
                    $last_id = $last_id->last_num ?? 0;
                }

                // create account chat if doesn't existed

                createProductAccountChart($product);
                $product = getProductById($product_unit->product_id);
                $journal = new JournalModel;
                $journal->branch_id = $mybranch;
                $journal->journal_parentid = $last_id;
                $journal->journal_type = 5;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_cost_of_good_sold;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Expense cost of goods sold ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = $cost * $pos_detail->qty;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->reference_number;
                $journal->save();

                $journal = new JournalModel;
                $journal->branch_id = $mybranch;
                $journal->journal_parentid = maxJournalId();
                $journal->journal_type = 4;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_sale_revenue;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Sale Revenue ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $pos_detail->sale_price * $pos_detail->qty;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->reference_number;
                $journal->save();

                $journal = new JournalModel;
                $journal->branch_id = $mybranch;
                $journal->journal_parentid = maxJournalId();
                $journal->journal_type = 1;
                $journal->voucher_type = 1;
                $journal->journal_acccode = $product->acc_inventory;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Inventory  ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                $journal->journal_debit = 0;
                $journal->journal_credit = $cost * $pos_detail->qty;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = date("Y-m-d");
                $journal->journal_paydate = date("Y-m-d");
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_reference_number = $pos->reference_number;
                $journal->journal_by = \Auth::id();
                $journal->save();

                if (!$pos->purchase_request_id) { //add account inventory to customer
                    $journal = new JournalModel;
                    $journal->member_id = $pos->member_id;
                    $journal->journal_parentid = maxJournalId();
                    $journal->journal_type = 1;
                    $journal->voucher_type = 2;
                    $journal->journal_acccode = $product->acc_inventory;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Inventory ' . ($product->product_name ?? '') . '(' . ($product->item_code ?? '') . ')';
                    $journal->journal_debit = $pos_detail->sale_price * $pos_detail->qty;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = date("Y-m-d");
                    $journal->journal_paydate = date("Y-m-d");
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->journal_by = \Auth::id();
                    $journal->save();
                }
                // Have discount
                $dis = $pos_detail->sale_price * ($pos_detail->dis / 100);
                if ($pos_detail->dis) {
                    $journal = new JournalModel;
                    $journal->branch_id = $mybranch;
                    $journal->journal_parentid = maxJournalId();
                    $journal->journal_type = 4;
                    $journal->voucher_type = 1;
                    $journal->journal_acccode = '42000';
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Discount ' . $product->product_name . ' ( ' . $pos_detail->dis . '% )';
                    $journal->journal_debit = $dis;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $pos->id;
                    $journal->journal_by = \Auth::id();
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->save();
                }
            }
            $payment = new PaymentModel;
            $payment->invoice_id = $pos->id;
            $payment->branch_id = $pos->member_id;
            $payment->member_id = $pos->member_id;
            $payment->user_id = $user_id;
            $payment->payment_invoice = $pos->reference_number;
            $payment->payment_date = $pos->sale_date;
            $payment->payment_amount = $grand_total;
            $payment->paid_amount = $pos->paid_amount_usd;
            $payment->payment_status = $payment_status;
            $payment->type = $pos->sale_type;
            $payment->year = date('Y');
            $payment->status = 1;
            $payment->save();

            $payment_detail = new PaymentDetailModel;
            $payment_detail->payment_id = $payment->id;
            $payment_detail->paid_amount = $pos->paid_amount_usd;
            $payment_detail->payment_date = $pos->sale_date;
            $payment_detail->note = $pos->sale_type;
            $payment_detail->status = 1;
            $payment_detail->save();


            CreateMemberAccountChart($member);
            $member = findUser($pos->member_id);
            /* ====== Accounting ====== */
            $last_id_pos_clothes = $pos->id;
            if ($pos->paid_amount_usd >= $grand_total) {
                $journal = new JournalModel;
                $journal->branch_id = $mybranch;
                $journal->journal_parentid = 0;
                $journal->journal_type = 1;
                $journal->journal_acccode = $payment_method;
                $journal->voucher_type = 1;
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'POS Wholesale ' . '(' . $pos->reference_number . ')';
                $journal->journal_debit = $grand_total;
                $journal->journal_credit = 0;
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_transactiondate = $pos->sale_date;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $last_id_pos_clothes;
                $journal->journal_reference_number = $pos->reference_number;
                $journal->journal_by = $user_id;
                $journal->save();
            }
            else {
                if ($payment_status === 'partial') {
                    $journal = new JournalModel;
                    $journal->branch_id = $mybranch;
                    $journal->journal_parentid = 0;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = $payment_method;
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'POS Wholesale ' . '(' . $pos->reference_number . ')';
                    $journal->journal_debit = $pos->paid_amount_usd;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->journal_by = $user_id;
                    $journal->save();


                    $journal = new JournalModel;
                    $journal->branch_id = $mybranch;
                    $journal->journal_parentid = maxJournalId();
                    $journal->journal_type = 1;
                    $journal->journal_acccode = $member->acc_account_receivable ?? '11003';
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Account Receivable POS Wholesale ' . '(' . $pos->reference_number . ')';
                    $journal->journal_debit = $grand_total - $pos->paid_amount_usd;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->journal_by = $user_id;
                    $journal->save();

                    if (!$pos->purchase_request_id) { //add account payable
                        $journal = new JournalModel;
                        $journal->member_id = $member->id;
                        $journal->journal_parentid = maxJournalId();
                        $journal->journal_type = 2;
                        $journal->voucher_type = 2;
                        $journal->journal_acccode = $member->acc_account_payable ?? '21001';
                        $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                        $journal->journal_des = 'Account Payable (' . $pos->reference_number . ')';
                        $journal->journal_debit = 0;
                        $journal->journal_credit = $grand_total - $pos->paid_amount_usd;
                        $journal->journal_tran_id = $j->last_num + 1;
                        $journal->journal_transactiondate = $pos->sale_date;
                        $journal->journal_paydate = $pos->sale_date;
                        $journal->journal_currency = 2;
                        $journal->transaction_type = $pos->sale_type;
                        $journal->journal_referenceid = $last_id_pos_clothes;
                        $journal->journal_reference_number = $pos->reference_number;
                        $journal->journal_by = $user_id;
                        $journal->save();
                    }
                }
                else {
                    $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                    $journal = new JournalModel;
                    $journal->branch_id = $mybranch;
                    $journal->journal_parentid = $jj->last_id;
                    $journal->journal_type = 1;
                    $journal->journal_acccode = $member->acc_account_receivable ?? '11003';
                    $journal->voucher_type = 1;
                    $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                    $journal->journal_des = 'Account Receivable POS Wholesale ' . '(' . $pos->reference_number . ')';
                    $journal->journal_debit = $grand_total;
                    $journal->journal_credit = 0;
                    $journal->journal_tran_id = $j->last_num + 1;
                    $journal->journal_transactiondate = $pos->sale_date;
                    $journal->journal_paydate = $pos->sale_date;
                    $journal->journal_currency = 2;
                    $journal->transaction_type = $pos->sale_type;
                    $journal->journal_referenceid = $last_id_pos_clothes;
                    $journal->journal_reference_number = $pos->reference_number;
                    $journal->journal_by = $user_id;
                    $journal->save();

                    if (!$pos->purchase_request_id) { //add account payable
                        $journal = new JournalModel;
                        $journal->member_id = $member->id;
                        $journal->journal_parentid = maxJournalId();
                        $journal->journal_type = 2;
                        $journal->voucher_type = 2;
                        $journal->journal_acccode = $member->acc_account_payable ?? '21001';
                        $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                        $journal->journal_des = 'Account Payable (' . $pos->reference_number . ')';
                        $journal->journal_debit = 0;
                        $journal->journal_credit = $grand_total;
                        $journal->journal_tran_id = $j->last_num + 1;
                        $journal->journal_transactiondate = $pos->sale_date;
                        $journal->journal_paydate = $pos->sale_date;
                        $journal->journal_currency = 2;
                        $journal->transaction_type = $pos->sale_type;
                        $journal->journal_referenceid = $last_id_pos_clothes;
                        $journal->journal_reference_number = $pos->reference_number;
                        $journal->journal_by = $user_id;
                        $journal->save();
                    }
                }
            }
            if($pos->discount){
                $jj = JournalModel::select(DB::raw("Max(id) as last_id"))->first();
                $journal = new JournalModel;
                $journal->branch_id = $mybranch;
                $journal->journal_parentid = $jj->last_id;
                $journal->journal_type = 4;
                $journal->voucher_type = 1;
                $journal->journal_acccode = '42000';
                $journal->voucher_ref = "V-" . generate_voucher_number(($j->last_num + 1), 8);
                $journal->journal_des = 'Discount '.$pos->reference_number.' ( '.$pos->discount.'% )';
                $journal->journal_debit = 0;
                $journal->journal_credit = -($pos->grand_total-$pos->sub_total);
                $journal->journal_tran_id = $j->last_num + 1;
                $journal->journal_paydate = $pos->sale_date;
                $journal->journal_currency = 2;
                $journal->transaction_type = $pos->sale_type;
                $journal->journal_referenceid = $pos->id;
                $journal->journal_by = \Auth::id();
                $journal->journal_reference_number = $pos->reference_number;
                $journal->save();
            }
            /* ====== End Account ====== */
            session()->put('success', 'Wholesale created successfully.');
            if ($payment_status === 'paid') {
                return response()->json(['route' => route('wholesale.reciept'), 'status' => 'ok']);
            } else {
                return response()->json(['route' => route('wholesale.index'), 'status' => 'ok']);
            }
        }

        //Narak
        public function destroy($id, $delete_all = null)
        {
            try {
                return DB::transaction(function () use ($id, $delete_all) {
                    $master = SaleModel::find($id);
                    $detail = SaleDetailsModel::where('sale_id', $id)->get();
                    foreach ($detail as $key => $value) {
                        $stock = StockModel::where('warehouse_id', $master->warehouse_id)->where('product_unit_id', $value->product_id)->first();
                        $to_stock = StockModel::where('warehouse_id', $master->to_warehouse)->where('product_unit_id', $value->product_id)->first();
                        $product_unit = ProductUnitModel::find($value->product_id);
                        if ($stock) {
                            $qty = $value->qty;
                            if ($product_unit->unit_id == $value->unit_id) {
                                $qty = $value->qty * $product_unit->qty_per_unit;
                            }
                            $stock->stock_qty += $qty;
                            $stock->update();
                        }
                        if ($to_stock) {
                            $qty = $value->qty;
                            if ($product_unit->unit_id == $value->unit_id) {
                                $qty = $value->qty * $product_unit->qty_per_unit;
                            }
                            $to_stock->stock_qty -= $qty;
                            $to_stock->update();
                        }
                    }
                    $payment = PaymentModel::where('invoice_id', $id)->where('type', $master->sale_type)->first();
                    PaymentDetailModel::where('payment_id', $payment->id)->delete();
                    $payment->delete_at = date('Y-m-d H:i:s');
                    $payment->update();
                    JournalModel::where(['transaction_type' => $master->sale_type, 'journal_referenceid' => $id])->delete();
                    if ($delete_all) {
                        SaleDetailsModel::where('sale_id', $id)->delete();
                        $master->delete();
                    } else {
                        $master->delete_at = date('Y-m-d H:i:s');
                        $master->update();
                    }
                    return response()->json(['status' => 'ok']);
                });
            } catch (\Exception $e) {
                throw ValidationException::withMessages(['field_name' => $e->getMessage()]);
            }

        }
    }
