<?php

namespace App\Http\Controllers\Branch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\purchase_order\PurchaseOrderModel;
use App\Model\purchase_order\PurchaseOrderDetailModel;
use App\Model\ProductUnitModel;
use App\Model\WarehouseModel;
use App\Model\StockModel;
use Carbon\Carbon, Auth, DataTables;

class POController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()){
            $data = PurchaseOrderModel::where('nso007_purchase_order.status', '!=', 0)
                        ->leftJoin('nso007_warehouse', 'nso007_purchase_order.warehouse_id', 'nso007_warehouse.id')
                        // ->leftJoin('nso007_product_unit.', 'nso007_product_unit.product_id', 'nso007_products.id')
                        // ->where(function($q) use ($request){
                        //     if($request->size){
                        //         $q->where('size', 'like', '%' . $request->size . '%');
                        //     }
                        //     if($request->note){
                        //         $q->where('note', 'like', '%' . $request->note . '%');
                        //     }
                        //     if($request->created_at){
                        //         $q->whereDate('created_at', $request->created_at);
                        //     }
                        //     $q->where('status', 1);
                        // })
                        ->selectRaw('nso007_purchase_order.id, invoice_number, purchase_date, warehouse_name, nso007_purchase_order.status')
                        ->orderBy('nso007_purchase_order.id', 'desc')
                        ->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));

            return DataTables::of($data->items())
                    ->with([
                        "activePage" => $request->page,
                        "records" => $request->record,
                        "recordsTotal" => $data->total(),
                        "recordsFiltered" => $data->total(),
                        'totalPage' => $data->lastPage()
                    ])
                    ->addColumn('action', function($action){
                        if($action->status == 2){
                            return '<a href="' . route("branch-po.edit", $action->id) . '"><i href="javascript:;"  class="fa fa-pencil btn btn-sm btn-warning" title="Edit"></i></a>'.' '
                            . '<i href="javascript:;" data-url = "' . route("branch-po.destroy", $action->id) . '" class="fa fa-trash btn btn-sm btn-danger" title="Delete"></i>';
                        }
                    })
                    ->editColumn('purchase_date', function($action){
                        return Carbon::parse($action->purchase_date)->format('Y-m-d');
                    })
                    ->editColumn('product', function($action){
                        $products =  \DB::table('nso007_purchase_order_detail')
                                ->join('nso007_product_unit', 'nso007_purchase_order_detail.product_unit_id', 'nso007_product_unit.id')
                                ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                                ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                                ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                                ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                                ->where('nso007_purchase_order_detail.purchase_order_id', $action->id)
                                ->get();
                        $name = '';
                        foreach($products as $key => $item){
                            $name .= '<span class="label label-default">'.$item->product_name.' / Size '.$item->size. ' - Color '.$item->name .' / '.$item->qty.$item->unit.'</span>'.'  ';
                        }
                        return $name;
                    })
                    ->editColumn('status', function($action){
                        switch ($action->status) {
                            case '1':
                                return '<span class="label label-success">Approved</span>';
                                break;
                            case '2':
                                return '<span class="label label-default">Padding</span>';
                                break;
                            case '4':
                                return '<span class="label label-danger">Canceled</span>';
                                break;
                            case '3':
                                return '<span class="label label-warning">Returned</span>';
                                break;
                            default:
                                break;
                        }
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'status', 'product'])
                    ->make(true);
        }
        return view('branch.po.approval');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('branch.po.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'purchase_date' => 'required|date',
            'product.*' => 'required',
            'qty.*' => 'required',
            'cost.*' => 'required',
            'description' => 'nullable|max:255|string'
        ]);

        $warehouse = WarehouseModel::whereRaw('branch_id = ? && user_id != ?', [\Auth::user()->id, \Auth::id()])->first();
        $purchase = new PurchaseOrderModel;
        $purchase->user_id = Auth::id();
        $purchase->invoice_number = 'PO' . date('YmdHis');
        $purchase->transaction_code = 'TPO' . date('YmdHis');
        $purchase->purchase_date = Carbon::parse($request->purchase_date)->format('Y-m-d');
        $purchase->year = date('Y');
        $purchase->warehouse_id = $warehouse?$warehouse->id:0;
        $purchase->status = 2;
        $purchase->comment = $request->decription;
        $purchase->save();

        foreach($request['product'] as $key => $item){
            $purchase_detail = new PurchaseOrderDetailModel;
            $purchase_detail->purchase_order_id = $purchase->id;
            $purchase_detail->product_unit_id = $request['product'][$key];
            $purchase_detail->qty = $request['qty'][$key];
            $purchase_detail->save();
        }

        return redirect()->route('branch-po.index')->with('success', 'Purchase order created successful.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $purchaseOrderModel = PurchaseOrderModel::join('nso007_purchase_order_detail', 'nso007_purchase_order.id', 'nso007_purchase_order_detail.purchase_order_id')
                                                ->where('purchase_order_id', $id)
                                                ->selectRaw('product_unit_id, purchase_order_id, nso007_purchase_order.id, comment, nso007_purchase_order_detail.id as purchase_order_detail_id, qty')
                                                ->get();
        return view('branch.po.edit', compact('purchaseOrderModel', 'id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'purchase_date' => 'required|date',
            'product.*' => 'required',
            'qty.*' => 'required',
            'cost.*' => 'required',
            'description' => 'nullable|max:255|string'
        ]);

        $purchase = PurchaseOrderModel::find($id);
        $purchase->user_id = Auth::id();
        $purchase->purchase_date = Carbon::parse($request->purchase_date)->format('Y-m-d');
        $purchase->status = 2;
        $purchase->comment = $request->decription;
        $purchase->update();

        $a = PurchaseOrderDetailModel::where('purchase_order_id', $id)
                                ->whereNotIn('id', $request->purchase_detail_order_id)
                                ->delete();

        foreach($request['purchase_detail_order_id'] as $key => $item){
            $purchase_detail = PurchaseOrderDetailModel::find(@$request['purchase_detail_order_id'][$key]);
            if($purchase_detail){
                $purchase_detail->purchase_order_id = $purchase->id;
                $purchase_detail->product_unit_id = $request['product'][$key];
                $purchase_detail->qty = $request['qty'][$key];
                $purchase_detail->update();

            }else{

                $purchase_detail = new PurchaseOrderDetailModel;
                $purchase_detail->purchase_order_id = $purchase->id;
                $purchase_detail->product_unit_id = $request['product'][$key];
                $purchase_detail->qty = $request['qty'][$key];
                $purchase_detail->save();
            }
        }
        return redirect()->route('branch-po.index')->with('success', 'Purchase Order update successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        PurchaseOrderModel::find($id)->update(['status' => 0]);
        return response()->json('');
    }

    public function admin(Request $request)
    {
        if($request->ajax()){
            $data = PurchaseOrderModel::where('nso007_purchase_order.status', '!=', 0)
                        ->leftJoin('nso007_warehouse', 'nso007_purchase_order.warehouse_id', 'nso007_warehouse.id')
                        // ->leftJoin('nso007_product_unit.', 'nso007_product_unit.product_id', 'nso007_products.id')
                        // ->where(function($q) use ($request){
                        //     if($request->size){
                        //         $q->where('size', 'like', '%' . $request->size . '%');
                        //     }
                        //     if($request->note){
                        //         $q->where('note', 'like', '%' . $request->note . '%');
                        //     }
                        //     if($request->created_at){
                        //         $q->whereDate('created_at', $request->created_at);
                        //     }
                        //     $q->where('status', 1);
                        // })
                        ->selectRaw('nso007_purchase_order.id, invoice_number, purchase_date, warehouse_name, nso007_purchase_order.status')
                        ->orderBy('nso007_purchase_order.id', 'desc')
                        ->paginate($request->record , ['*'], 'page', str_replace(',', '', $request->page));

            return DataTables::of($data->items())
                    ->with([
                        "activePage" => $request->page,
                        "records" => $request->record,
                        "recordsTotal" => $data->total(),
                        "recordsFiltered" => $data->total(),
                        'totalPage' => $data->lastPage()
                    ])
                    ->editColumn('status', function($action){
                        switch ($action->status) {
                            case 1:
                                return '<span class="label label-success">Approved</span>';
                                break;
                            case 2:
                                return '<span class="label label-default">Padding</span>';
                                break;
                            case 4:
                                return '<span class="label label-danger">Canceled</span>';
                                break;
                            case 3:
                                return '<span class="label label-warning">Returned</span>';
                                break;
                            default:
                                break;
                        }
                    })
                    ->addColumn('action', function($action){
                        if($action->status == 2){
                            return '<a href="' . route("branch-po-approved", ['approved', $action->id]) . '"><i href="javascript:;"  class="fa fa-check btn btn-sm btn-success" title="Edit"></i></a>'.' '
                                .'<i href="javascript:;" data-url = "' . route("branch-po-approved", ['cancel', $action->id]) . '" class="fa fa-trash btn btn-sm btn-danger" title="Delete"></i>';
                        }
                    })
                    ->editColumn('purchase_date', function($action){
                        return Carbon::parse($action->purchase_date)->format('Y-m-d');
                    })
                    ->editColumn('product', function($action){
                        $products =  \DB::table('nso007_purchase_order_detail')
                                ->join('nso007_product_unit', 'nso007_purchase_order_detail.product_unit_id', 'nso007_product_unit.id')
                                ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                                ->leftJoin('nso007_unit', 'nso007_product_unit.sub_unit_id', 'nso007_unit.id')
                                ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                                ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                                ->where('nso007_purchase_order_detail.purchase_order_id', $action->id)
                                ->get();
                        $name = '';
                        foreach($products as $key => $item){
                            $name .= '<span class="label label-default">'.$item->product_name.' / Size '.$item->size. ' - Color '.$item->name .' / '.$item->qty.$item->unit.'</span>'.'  ';
                        }
                        return $name;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action', 'status', 'product'])
                    ->make(true);
        }
        return view('branch.po.admin-approve');
    }

    public function UpdatePO(Request $request, $type = '', $id)
    {
        $purchaseOrderModels = PurchaseOrderModel::join('nso007_purchase_order_detail', 'nso007_purchase_order.id', 'nso007_purchase_order_detail.purchase_order_id')
                                                ->where('purchase_order_id', $id)
                                                ->selectRaw('warehouse_id, product_unit_id, purchase_order_id, nso007_purchase_order.id, comment, nso007_purchase_order_detail.id as purchase_order_detail_id, qty')
                                                ->get();
        if($type == 'approved'){
            $stock = array();
            foreach($purchaseOrderModels as $purchaseOrderModel){
                $productUnit = ProductUnitModel::where('nso007_product_unit.id',$purchaseOrderModel->product_unit_id)
                                                ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                                                ->leftJoin('nso007_unit', 'nso007_product_unit.unit_id', 'nso007_unit.id')
                                                ->leftJoin('nso007_product_size', 'nso007_product_unit.size_id', 'nso007_product_size.id')
                                                ->leftJoin('nso007_product_color', 'nso007_product_unit.color_id', 'nso007_product_color.id')
                                                ->selectRaw('product_name, name, size, unit, qty_per_unit')
                                                ->first();

                $qty_warehouse = StockModel::where('warehouse_id', getMainWarehouse())
                                            ->where('product_unit_id', $purchaseOrderModel->product_unit_id);

                // $total_qty = $productUnit->qty_per_unit*$purchaseOrderModel->qty;
                $total_qty = $purchaseOrderModel->qty;
                if($total_qty > $qty_warehouse->sum('stock_qty')){
                    $product_detail = $productUnit->product_name.' / '.'Size:'.$productUnit->size.' - '.'Color: '.$productUnit->name.'/'.$purchaseOrderModel->qty.$productUnit->unit;
                    return \redirect()->route('branch-po-admin')->with('warning', $product_detail.' is out of stock.');
                }else{
                    $stock[] = [
                        'shelf' => $qty_warehouse->first()->shelf,
                        'warehouse_id' => $purchaseOrderModel->warehouse_id,
                        'total_qty' => $total_qty,
                        'product_unit' =>  $purchaseOrderModel->product_unit_id,
                        'qty' => $purchaseOrderModel->qty
                    ];
                }
            };
            foreach ($stock as $key => $item) {
                cutStock(getMainWarehouse(), $item['shelf'], $item['product_unit'], $item['qty']);
                $new_stock = StockModel::where('warehouse_id', $item['warehouse_id'])
                                        ->where('product_unit_id', $item['product_unit'])
                                        ->first();
                if($new_stock){
                    $new_stock->stock_qty += $item['total_qty'];
                    $new_stock->update();
                }else{
                    $new_stock = new StockModel;
                    $new_stock->warehouse_id = $item['warehouse_id'];
                    $new_stock->product_unit_id = $item['product_unit'];
                    $new_stock->stock_qty = $item['total_qty'];
                    $new_stock->save();
                }
            }
            PurchaseOrderModel::find($id)->update(['status' => 1]);
        }else{
            $purchaseOrderModel = PurchaseOrderModel::find($id)->update(['status' => 4, 'reason' => $request->reason]);
        }
        return redirect()->route('branch-po.index')->with('success', 'Purchase Order canceled successfully.');
    }
}
