<?php


    namespace App\Http\Controllers\Administrator\stock_inventory;


    use App\BranchModel;
    use App\Model\product\ShelfModel;
    use App\Model\product\SizeModel;
    use App\Model\ProductUnitModel;

    use Illuminate\Http\Request;

    use App\Http\Controllers\Controller;

    use App\Model\ProductModel;

    use App\Model\StockModel;

    use App\Model\WarehouseModel;

    use App\Model\AdjustmentModel;

    use App\Model\AdjustmentDetailModel;

    use DB;

    use DataTables;

    use Illuminate\Support\Facades\Gate;
    use Illuminate\Support\Facades\Input;

    use Auth;

    use Session;

    class AdjustmentController extends Controller

    {

        function __construct()

        {

//           $this->middleware('permission:Report Stocks', ['only' => ['index']]);

        }

        public function index(Request $request)
        {
            if ($request->ajax()) {
                $data = AdjustmentModel::latest();
                $count_filter = $data->count();
                return DataTables::of($data->take(20))
                    ->with([
                        "recordsTotal" => $count_filter,
                        "recordsFiltered" => $count_filter,
                    ])
                    ->editColumn('adjustment_date', function ($item) {
                        return myDate($item->adjustment_date);
                    })
                    ->editColumn('user_id', function ($item) {
                        return findUser($item->user_id)->name ?? '';
                    })
                    ->addColumn('action', function ($item) {
                        $show_item = '';
                        if (Gate::check('Adjustment Show')) {
                            $show_item = '<a data-href="' . route("adjustment.show", $item->id) . '" title="' . __('administrator.show') . '" class="btn btn-info btn_show">' . __('administrator.show') . '</a>';
                        }
                        return $show_item;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->make(true);
            }

            return view('administrator.stock-inventory.adjustment.index');

        }

        public function create(Request $request)
        {
            if (ifMember()) {
                return redirect()->back();
            }
            if ($request->ajax()) {
                IF($request['product_unit_id']&&$request['shelf']){
                    $product_unit = ProductUnitModel::find($request['product_unit_id']);
                    $stock = StockModel::where(['product_unit_id' => $product_unit->id, 'shelf' => $request['shelf']])->first()->stock_qty ?? 0;
                    $stock /= $product_unit->qty_per_unit;
                    return response()->json(['qty' => intval($stock)]);
                }
                return 0; // prevent return view
            }
            return view('administrator.stock-inventory.adjustment.create');

        }

        public function store(Request $request)
        {
            $this->validate($request, [
                'adjustment_date' => 'required',
                'product_unit_id' => 'required',
                'shelf.*' => 'required',
                'operator.*' => 'required',
                'qty.*' => 'required',
                'balance.*' => 'required',
            ]);
            //Insert to adjustments
            $adjustment = new AdjustmentModel();
            $adjustment->user_id = Auth::id();
            $adjustment->branch_id = mainBranch()->id;
            $adjustment->note = $request->note;
            $adjustment->adjustment_date = sDate($request->adjustment_date);
            $adjustment->invoice_number = refNumber(mainBranch()->id, 'adjustment', 'ADJ');
            $adjustment->save();
            foreach ($request['product_unit_id'] as $key => $value) {
                $balance = $request['balance'][$key];
                $shelf = $request['shelf'][$key];
                $qty = $request['qty'][$key];
                $operator = $request['operator'][$key];
                $adjustment_detail = array(
                    'adjustment_id' => $adjustment->id,
                    'product_unit_id' => $value,
                    'shelf' => $shelf,
                    'stock' => $request['stock'][$key],
                    'operator' => $operator,
                    'qty' => $qty,
                    'balance' => $balance,
                );
                AdjustmentDetailModel::insert($adjustment_detail);
                adjStockAdmin(mainBranch()->id,$shelf,$value,floatVal($operator.$qty));
            }

            return response()->json(['status' => 'ok', 'route' => route('adjustment.index')]);

        }

        public function show($id)
        {

            $adj = AdjustmentModel::find($id);
            $adj_detail = AdjustmentDetailModel::where('adjustment_id', $id)->get();

            return view('administrator.stock-inventory.adjustment.show', compact('adj', 'adj_detail'));

        }


    }

