<?php

namespace App\Http\Controllers\Administrator\people;

use App\Model\people\DriverModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;

class DriverController extends Controller
{

    function __construct()
    {
       $this->middleware('permission:Driver Create', ['only' => [ 'create', 'store']]);
       $this->middleware('permission:Driver List', ['only' => ['index']]);
       $this->middleware('permission:Driver Edit', ['only' => ['edit']]);
       
    }
    public function index()
    {
        $data = DriverModel::where('branch_id',Auth::user()->branch_id)->get();
        return view('administrator.people.driver.index', compact('data'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'phone' => 'required',
        ]);
        DriverModel::updateOrCreate(
            [
                'id'=>$request->id,
            ],
            [
                'user_id'=>Auth::user()->id,
                'branch_id'=>Auth::user()->branch_id,
                'phone'=>$request->phone,
                'name'=>$request->name,
                'note'=>$request->note,
            ]
        );
        session()->put('success', 'Driver Created/Updated successful');
        return response()->json('success');
    }

    public function edit($id)
    {
        $data = DriverModel::find($id);
        return response()->json($data);
    }
}
