<?php

namespace App\Http\Controllers\Administrator\payment;

use Auth;
use App\Fun\Fun;
use App\Model\PaymentDetailModel;
use App\Model\PaymentModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class PurchaseOrderPaymentController extends Controller
{
    function __construct()
    {
       $this->middleware('permission:Purchase Order Payment List', ['only' => ['index']]);
       $this->middleware('permission:Purchase Order Payment Show', ['only' => ['show']]);
    }
    public function index()
    {
        return view('administrator.payment.purchase-order.index');
    }

    public function getpayment(Request $request)
    {
        Fun::lang();
        if ($request->ajax()) {
            $value = $request->value;
            $supplier_id = $request->supplier_id;
            $date = $request->date;
            $type = $request->type;
            $status = $request->status;

            $count_total = PaymentModel::where('nso007_payment.type', 'purchase-order')
                ->count();
            $count_filter = PaymentModel::select('nso007_payment.id')
                ->join('nso007_purchase_order', 'nso007_purchase_order.id', 'nso007_payment.invoice_id')
                ->where('nso007_payment.status', 1)
                ->where('nso007_payment.type', 'purchase-order')
                ->where(function ($q) use ($value) {
                    if ($value) {
                        $q->where('nso007_purchase_order.invoice_number', 'like', '%' . $value . '%');
                    }
                })
                ->where(function ($q) use ($date) {
                    if ($date) {
                        $q->where('nso007_payment.payment_date', date('Y-m-d', strtotime($date)));
                    }
                })
                ->where(function ($q) use ($type) {
                    if ($type) {
                        $q->where('nso007_payment.type', $type);
                    }
                })
                ->where(function ($q) use ($status) {
                    if ($status) {
                        $q->where('nso007_payment.payment_status', $status);
                    }
                })
                ->where(function ($q) use ($supplier_id) {
                    if ($supplier_id) {
                        $q->where('nso007_payment.supplier_id', $supplier_id);
                    }
                })
                ->count();
            $data = PaymentModel::select('nso007_purchase_order.invoice_number', 'nso007_payment.*')
                ->join('nso007_purchase_order', 'nso007_purchase_order.id', 'nso007_payment.invoice_id')
                ->where('nso007_payment.status', 1)
                ->where('nso007_payment.type', 'purchase-order')
                ->where(function ($q) use ($value) {
                    if ($value) {
                        $q->where('nso007_purchase_order.invoice_number', 'like', '%' . $value . '%');
                    }
                })
                ->where(function ($q) use ($type) {
                    if ($type) {
                        $q->where('nso007_payment.type', $type);
                    }
                })
                ->where(function ($q) use ($date) {
                    if ($date) {
                        $q->where('nso007_payment.payment_date', date('Y-m-d', strtotime($date)));
                    }
                })
                ->where(function ($q) use ($status) {
                    if ($status) {
                        $q->where('nso007_payment.payment_status', $status);
                    }
                })
                ->orderBy('nso007_payment.created_at', 'DESC')
                ->take(20);
            return DataTables::of($data)
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('payment_date', function ($data) {
                    return date('d-m-Y', strtotime($data->payment_date));
                })
                ->editColumn('user_id', function ($data) {
                    return findUser($data->user_id)->name;
                })
                ->editColumn('payment_amount', function ($data) {
                    return '$' . number_format($data->payment_amount, 2);
                })
                ->editColumn('paid_amount', function ($data) {
                    return '$' . number_format($data->paid_amount, 2);
                })
                ->editColumn('remain', function ($data) {
                    return '$' . number_format($data->payment_amount - $data->paid_amount, 2);
                })
                ->editColumn('payment_status', function ($data) {
                    $bg = '';
                    if ($data->payment_status == 'due') {
                        $bg = 'danger';
                    }
                    if ($data->payment_status == 'partial') {
                        $bg = 'warning';
                    }
                    if ($data->payment_status == 'paid') {
                        $bg = 'success';
                    }
                    return '<span class="label label-' . $bg . '">' . __('administrator.' . $data->payment_status) . '</span>';
                })
                ->addColumn('action', function ($data) {
                    $pay = '';
                    if (strtolower($data->payment_status) != 'paid') {
                        $pay = ' <a  title="' . __('administrator.add_payment') . '" class="btn bg-olive btn-flat margin btn_add_payment"  data-id="' . $data->id . '">' . __('administrator.add_payment') . '</a>';
                    }
                    $view_show = '
                        <a href="' . route("payment-purchase-order.show", $data->id) . '" title="' . __('administrator.show') . '" class="button_info">' . __('administrator.show') . '</a>
                        ' . $pay;
                    if(Gate::check('Purchase Order Payment Show')){
                        $view_show;
                    }else{
                        $view_show='';
                    }
                    return $view_show;
                })
                ->addIndexColumn()
                ->rawColumns(['action' => 'action', 'payment_status' => 'payment_status', 'supplier_name' => 'supplier_name', 'supplier_phone' => 'supplier_phone', 'remain' => 'remain',])
                ->make(true);
        }
    }

    public function show($id)
    {
        $master = PaymentModel::find($id);
        $detail = PaymentDetailModel::where('payment_id', $id)->get();
        return view('administrator.payment.purchase-order.show', compact('master', 'detail'));
    }

    public function get_payment($id)
    {
        $payment = PaymentModel::find($id);
        $std = new \stdClass();
        $std->remain = number_format(($payment->payment_amount - $payment->paid_amount), 2);

        $std->invoice = findPurchaseOrder($payment->invoice_id)->invoice_number;

        $std->payment_id = $payment->id;
        return response()->json($std);
    }

    public function add_payment(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric'
        ]);
        $payment = PaymentModel::find($request->payment_id);

        $pos = findPurchaseOrder($payment->invoice_id);
        $pos->paid_amount_usd += $request->amount;

        $payment->paid_amount += $request->amount;

        $payment->payment_status = 'partial';
        if ($payment->paid_amount >= $payment->payment_amount) {
            $payment->payment_status = 'paid';
            $pos->payment_status = 'paid';
        }
        $payment->update();
        $pos->update();
        $payment_detail = new PaymentDetailModel();
        $payment_detail->payment_id = $payment->id;
        $payment_detail->paid_amount = $request->amount;
        $payment_detail->payment_date = $request->date;
        $payment_detail->note = $request->note;
        $payment_detail->status = 1;
        $payment_detail->save();
        return redirect()->route('payment-purchase-order.index')->with('success', 'Purchase Order Payment was added successful...');
    }
}
