<?php


namespace App\Http\Controllers\Administrator;


use App\Fun\Fun;
use App\Http\Controllers\Controller;
use App\Model\location\CommuneModel;
use App\Model\location\DistrictModel;
use App\Model\location\VillageModel;
use App\Model\product\ShelfModel;
use App\User;
use Auth;
use DataTables;
use DB;
use Hash;
use Illuminate\Http\Request;
use Image;
use session;
use Spatie\Permission\Models\Role;

class UserController extends Controller

{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $ifmember = Auth::user()->user_type === 'member';
            $type = $request->type;
            $leader_id = $request->leader_id;
            $data = User::where(function ($q) use ($ifmember) {
                if ($ifmember) {
                    $q->where('leader_id', Auth::id());
                }
                })
                ->where(function ($q) use ($leader_id) {
                    if ($leader_id) {
                        $q->where('leader_id', $leader_id);
                    }
                })
                ->where('user_type', $type)
                ->latest();

            return DataTables::of($data)
                ->addColumn('action', function ($action) use ($type) {
                    $btn = '';
                    if (Auth::user()->id == $action->id) {
                        $btn .= '<a href="#" class="btn btn-success">' . __('administrator.logged_in') . '</a>';
                    } else {
                        $btn .= ' <a class="btn ' . ($action->status == 1 ? 'btn-danger' : 'btn-success') . ' change_status"
                                       data-status="' . $action->status . '"
                                       data-id="' . $action->id . '"> ' . (__('administrator.' . ($action->status == 1 ? 'deactive' : 'active'))) . '</a>';
                    }
                    $btn .= ' <a data-href="' . route('users.edit', $action->id) . '?type=' . $type . '"
                                   class="btn btn-warning getHtmlForm">' . __('administrator.edit') . '</a>';
                    return $btn;
                })
                ->editColumn('leader_id', function ($action) {
                    return findUser($action->leader_id)->name ?? '';
                })
                ->editColumn('member_type_id', function ($action) {
                    $member_type = DB::table('nso007_member_type')->find($action->member_type_id);
                    return $member_type ? $member_type->name : '';
                })
                ->editColumn('gender', function ($action) {
                    return $action->gender ? __('administrator.' . $action->gender) : '';
                })
                ->editColumn('province_id', function ($action) {
                    return findProvince($action->province_id)->name_kh ?? '';
                })
                ->editColumn('status', function ($action) {
                    return '<span class="fa fa-circle text-' . ($action->status == 1 ? 'success' : 'danger') . '"></span>';
                })
                ->addIndexColumn()
                ->rawColumns(['action', 'status'])
                ->make(true);
        }
        return view('administrator.users.index');
    }

    public function user_status(Request $request)
    {
        $user = User::find($request->user_id);
        $user->status = $request->status;
        $user->save();
        return response()->json(['success' => 'Status change successfully.']);

    }

    public function create(Request $request)
    {
        return view('administrator.users.create');
    }

    public function store(Request $request)
    {
        return $this->update($request, null);
    }

    public function edit($id)
    {
        $master = User::find($id);
        $role_val = DB::table('model_has_roles')->where('model_id', $id)->first();
        if ($role_val) {
            $role_val = Role::find($role_val->role_id);
        }
        $district = DistrictModel::where('province_id', $master['province_id'])->pluck('name_kh', 'id')->prepend(__('administrator.please_select'),'');

        $commune = CommuneModel::where('district_id', $master['district_id'])->pluck('name_kh', 'id')->prepend(__('administrator.please_select'),'');

        $village = VillageModel::where('commune_id', $master['commune_id'])->pluck('name_kh', 'id')->prepend(__('administrator.please_select'),'');

        return view('administrator.users.edit', compact('master', 'role_val', 'district', 'commune', 'village'));

    }

    public function update(Request $request, $id)
    {
        $check = $request['user_type'] === 'member' ? 'required' : 'nullable';
        $this->validate($request, [
            'name' => 'required|unique:users,name,' . $id,
            'member_type_id' => $check,
            'roles' => 'required',
        ]);
        $old_user = User::find($id);
        $data = $request->all();
        if ($data['password']) {
            $data['password'] = Hash::make($data['password']);
        } else {
            unset($data['password']);
        }
        if ($files = $request->file('image')) {
            if ($old_user) {
                if ($old_user->logo) {
                    if (file_exists(public_path() . '/' . $old_user->image)) {
                        unlink(public_path() . '/' . $old_user->image);
                    }
                }
            }
            $original_name = 'U' . date('ymdhis') . '.png';
            $destinationPath = 'images/profile';
            $files->move($destinationPath, $original_name);
            $data['image'] = $destinationPath . '/' . $original_name;
        } else {
            $data['image'] = $old_user ? $old_user->logo : null;
        }


        $data['leader_id'] = $data['leader_id'] ?? Auth::id();
        $data['child_by_branch'] = !$request['leader_id'] ? FindBranchID() : '';
        if ($request['user_type'] !== 'member') {
            $data['branch_id'] = FindBranchID();
        }
        $data['status'] = 1;
        $data['user_id'] = Auth::id();
        if (@$data['date_of_birth']) {
            $data['date_of_birth'] = date('Y-m-d', strtotime($data['date_of_birth']));
        }
        $user = User::UpdateOrCreate(['id' => $id], $data);

        if($request->username){
            if ($request['user_type'] === 'member') {
                ShelfModel::updateOrCreate(['member_id' => $user->id], [
                    'member_id' => $user->id,
                    'name' => $user->name . '\'s' . ' shelf'
                ]);
            }
            DB::table('model_has_roles')->where('model_id', $id)->delete();
            $user->assignRole($request['roles']);
        }

        if ($request['input_name']) {
            return response()->json(['value_one' => $user->member_type_id, 'value' => $user->id, 'text' => $user->name, 'input_name' => $request['input_name'], 'input_name_one' => $request['input_name_one']]);
        }
        return response()->json(['status' => 'ok', 'reload' => 1]);
    }

    public function destroy($id)

    {
        User::find($id)->delete();
        return redirect()->route('users.index')->with('success', 'User deleted successfully');
    }

    public function delete_users(Request $request, $id)
    {
        $status = $request->status;
        if ($status == 0) {
            $change_status = 1;
        } else {
            $change_status = 0;
        }
        DB::table('users')
            ->where('id', $id)
            ->update(['user_status' => $change_status]);
        \LogActivity::addToLog('Disactived user successfully!');

        return redirect()->back();

    }

    public function datatable_user(Request $request)
    {

        $data = User::where('group_id', '!=', null)->get();

        if ($request->isMethod('get')) {


            return DataTables::of($data)
                ->editColumn('agent_id', function ($data) {

                    return optional($data->agent)->name;

                })
                ->editColumn('group_id', function ($data) {

                    return optional($data->group)->group_name;

                })
                ->editColumn('department_id', function ($data) {

                    return optional($data->department)->department_name;

                })
                ->editColumn('leader_id', function ($data) {

                    if ($data->leader_id) {

                        $pr = User::find($data->leader_id);

                        return $pr->name;

                    } else {

                        $pr = User::find($data->id);

                        $gr = UserGroupModel::where('leader_group_id', $pr->id)->first();

                        if ($gr) {

                            if ($gr->leader_group_id) {

                                return '<label class="label label-success">Leader</label>';

                            } else {

                                return '<label class="label label-danger">N/A</label>';

                            }

                        } else {

                            return '<label class="label label-danger">N/A</label>';

                        }


                    }


                })
                ->addColumn('action', function ($data) {

                    $check_language = Fun::lang();

                    if ($check_language == 'km') {

                        $delete = "ចាកចេញពីក្រុម";

                    } else {

                        $delete = "Leave Group";

                    }

                    return '

                            <button type="button" class="button_danger delete_products" data-toggle="modal"

                            data-id="' . $data->id . '" > ' . $delete . ' </button>



                            ';

                })
                ->addIndexColumn()
                ->rawColumns(['action' => 'action', 'leader_id' => 'leader_id'])
                ->make(true);

        }

    }

    public function getLocation(Request $request)
    {
        if (!$request['district_id']) {
            return DistrictModel::where('province_id', $request['province_id'])->pluck('name_kh', 'id');
        }
        if (!$request['commune_id']) {
            return CommuneModel::where('district_id', $request['district_id'])->pluck('name_kh', 'id');
        }
        if (!$request['village_id']) {
            return VillageModel::where('commune_id', $request['commune_id'])->pluck('name_kh', 'id');
        }
    }

    public function search_member(Request $request)

    {
        $key = $request->term['term'];
        $user = User::where(function ($q) {
            if (ifMember()) {
                $q->where('leader_id', Auth::id());
            }
        })
            ->where(function ($q) use ($key) {
                if ($key) {
                    $q->where('name', 'like', $key . '%');
                    $q->orwhere('phone', 'like', $key . '%');
                }
            })
            ->where('user_type', 'member')
            ->where(function ($q) {
                $q->where('leader_id', Auth::id());
                $q->orwhere('child_by_branch', FindBranchID());
            })
            ->limit(30)
            ->pluck('name', 'id')->prepend('Please Select', '');
        $arr = [];
        foreach ($user as $key => $row) {
            $arr[] = ['id' => $key, 'text' => $row];
        }
        return \Response::json($arr);

    }
}
