<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Yajra\DataTables\DataTables;
use DB;
use App\Model\StockModel;
use Illuminate\Support\Facades\Auth;
use App\Model\WarehouseModel;
use App\Model\Hr\HrBranch;
use App\Model\TransferStockModel;
use App\Model\TransferStockDetailModel;
use App\Model\people\DriverModel;
use App\Fun\Fun;
use Illuminate\Support\Facades\Gate;
use App\Model\ProductUnitModel;

class TransferStockController extends Controller

{

    // function __construct()
    // {
    //     $this->middleware('permission:Purchase List', ['only' => ['index']]);
    //     $this->middleware('permission:Purchase show', ['only' => ['show']]);
    //     Fun::lang();
    // }
    public function index(Request $request)
    {
        if ($request->ajax()) {
            Fun::lang();
            $search = $request->input('search.value');
            $branch_id = Auth::user()->branch_id;
            $warehouse = WarehouseModel::where('branch_id',$branch_id)->pluck('id');
            $count_total = TransferStockModel::count();
            $data = TransferStockModel::where(function ($q) use($warehouse) {
                $q->orwhere('branch_id', Auth::user()->branch_id);
                $q->orwhere('user_id', Auth::user()->id);
                $q->orwhereIn('to_warehouse_id', $warehouse);
            })
                  -> where(function ($query) use ($search) {
                    $query->orWhere('nso007_transfer_stock.invoice_number', 'LIKE', '%' . $search . '%');
                })
                ->orderBy('nso007_transfer_stock.id', 'DESC');
            $count_filter = $data->count();
            if ($request->ajax()) {
                return DataTables::of($data->take(20))
                    ->with([
                        "recordsTotal" => $count_total,
                        "recordsFiltered" => $count_filter,
                    ])
                    ->editColumn('to_branch', function ($item) {
                        return findBranch($item->to_branch)->name;
                    })
                    ->editColumn('user_id', function ($item) {
                        return findUser($item->user_id)->name;
                    })
                    ->editColumn('date', function ($item) {
                        return date('d-m-Y', strtotime($item->date));
                    })
                    ->editColumn('confirm_status', function ($item) {
                        return checkRequestStatus($item->confirm_status);
                    })
                    ->addColumn('action', function ($item) {
                        $branch_id = Auth::user()->branch_id;
                        $warehouse = WarehouseModel::find($item->to_warehouse_id);
                        $status = 0;

                        if($warehouse->branch_id==$branch_id){
                            if($item->status==1 && $item->confirm_status==0){
                                $status = 1;
                            }
                        }else{
                            $status = 0;
                        }

                        $show_item = '<a data-href="' . route("transfer-stock.show", $item->id) . '" data-id="' . $item->id . '" data-confirm_status="' . $status . '"title="' . __('administrator.show') . '" class="btn btn-info show_request">' . __('administrator.show') . '</a>';
                        return $show_item;
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action' => 'action','confirm_status'=>'confirm_status'])
                    ->make(true);
            }
        }
        return view('administrator.transfer-stock.index');
    }
    public function create()
    {
        return view('administrator.transfer-stock.create');
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'date' => 'required',
            'transfer_to' => 'required',
            'product' => 'required',
            'product.*' => 'required',
            'qty' => 'required|max:11',
            'qty.*' => 'required|max:11',
            'unit' => 'required|max:11',
            'unit.*' => 'required|max:11',
        ]);
        $product_unit_id = $request->product;
        $to_warehouse = WarehouseModel::where('branch_id',$request->transfer_to)->first();
        $mywarehouse = myWarehouse();
        $myBranch = myBranch();
        $unit = $request['unit'];
        $qty = $request['qty'];
        if($to_warehouse&&$mywarehouse){
            $arr = [];
            foreach ($product_unit_id as $key => $value) {
                $check = check_stock($myBranch->main,$mywarehouse->id,$value,$unit[$key],null,$qty[$key]);
                if($check){
                    $arr[$value]=$check;
                }
            }
            if(count($arr)){
                throw ValidationException::withMessages($arr);
            }
            $tran = new TransferStockModel();
            $tran->branch_id = $mywarehouse->branch_id ;
            $tran->user_id = Auth::user()->id;
            $tran->year = date('Y');
            $tran->note = $request->note;
            $tran->from_warehouse_id = $mywarehouse->id;
            $tran->to_warehouse_id = $to_warehouse->id;
            $tran->to_branch = $request->transfer_to;
            $tran->status =1;
            $tran->date = date('Y-m-d', strtotime($request->date));
            $tran->invoice_number = generate_inv('nso007_transfer_stock', 'TRS');
            $tran->save();
            foreach ($product_unit_id as $key => $value) {
                $add_tran = new TransferStockDetailModel();
                $add_tran->transfer_id = $tran->id;
                $add_tran->product_unit_id = $value;
                $add_tran->qty = $qty[$key];
                $add_tran->unit_id = $unit[$key];
                $add_tran->save();
                cut_or_add_stock_item($myBranch,$tran->from_warehouse_id,$value,$add_tran->unit_id,null,$add_tran->qty);
            }
            return response()->json(['status' => 'success', 'route' => route('transfer-stock.index')]);
        }else{
            if(!$mywarehouse){
                throw ValidationException::withMessages(['field_name' => 'សាខារបស់អ្នកគ្មានឃ្លាំងទេ....']);
            }else{
                throw ValidationException::withMessages(['field_name' => 'សាខាដែលត្រូវផ្ទេរស្តុកទៅគ្មានឃ្លាំងទេ....']);
            }
        }

    }
    public function show($id)
    {
        $tran = TransferStockModel::find($id);
        $tran_detail = TransferStockDetailModel::where('transfer_id', $id)->get();
        return view('administrator.transfer-stock.show', compact('tran', 'tran_detail'));
    }
    public function transfer_stock_confirm(Request $request,$status)
    {
        $id = $request->id;
        $transfer_stock = TransferStockModel::find($id);
        $transfer_stock->confirm_status = $status;
        $status = (int)$status;
        $transfer_stock_detail = TransferStockDetailModel:: where('transfer_id', $id)->get();

        $myBranch = myBranch();
        if ($status === 1) {
            foreach ($transfer_stock_detail as $key => $row){
                cut_or_add_stock_item($myBranch,$transfer_stock->to_warehouse_id,$row->product_unit_id,$row->unit_id,null,$row->qty,1);
            }
        }
        if($status === 2){
            $myBranch = findBranch($transfer_stock->branch_id);
            foreach ($transfer_stock_detail as $key => $row) {
                cut_or_add_stock_item($myBranch,$transfer_stock->from_warehouse_id,$row->product_unit_id,$row->unit_id,null,$row->qty,1);
            }
        }
        $transfer_stock->update();
        session()->put('success', 'Item has been confirm !');
        return response()->json(['status' => 'success','reload'=>1]);
    }
    public function transfer_return_stock($id){
        $request_stock_detail = getSaleDetail($id);
        foreach ($request_stock_detail as $key => $row) {
            $stock = StockModel::where([
                'warehouse_id' => $row->warehouse_id,
                'product_id' => $row->product_id,
                'size_id' => $row->size_id,
                'color_id' => $row->color_id])->first();
            $cut_qty = generateSaleCutQty($row);
            if ($stock->stock_qty >= $cut_qty) {
                $stock->stock_qty += $cut_qty;
                $stock->save();
            }
        }
        return response()->json(['status' => 'success','reload'=>1]);
    }

}

