<?php


namespace App\Http\Controllers\Administrator;

use App\Fun\Fun;
use App\Http\Controllers\Controller;
use App\Model\Accounting\AccountChartModel;
use App\Model\SaleModel;
use App\Models\TypeOfIllness;
use Auth;
use DataTables;
use DB;
use Illuminate\Http\Request;
use session;

class ReportSaleController extends Controller

{
    function __construct()
    {
        $this->middleware('permission:Report Sale', ['only' => ['index']]);
        Fun::lang();
    }

    public function index(request $request)
    {
        return view('administrator.report-sales.index');
    }

    public function crm_sale(request $request)
    {
        $crm = 1;
        return view('administrator.report-sales.index', compact('crm'));
    }

    public function retail_report(Request $request)
    {

        if ($request->isAjax) {
            $sale = SaleModel::leftJoin('nso007_customers', 'nso007_sales.customer_id', 'nso007_customers.id')
                ->leftJoin('nso007_payment', 'nso007_sales.id', 'nso007_payment.invoice_id')
                ->leftJoin('users', 'nso007_sales.user_id', 'users.id')
                ->with('detail')
                ->selectRaw('
                    nso007_sales.sale_date,
                    invoice_number,
                    nso007_sales.reference_number,
                    nso007_sales.id,
                    nso007_sales.user_id,
                    nso007_customers.customer_name,
                    nso007_customers.customer_phone,
                    nso007_customers.type_illness,
                    nso007_sales.branch_id,
                    nso007_sales.request_to,
                    nso007_sales.status,
                    nso007_sales.delete_at,
                    nso007_sales.using_point,
                    nso007_sales.points,
                    nso007_sales.customer_id,
                    nso007_sales.payment_status,
                    nso007_sales.payment_method,
                    nso007_sales.customer_type,
                    users.name as user_name,
                    paid_amount_kh, payment_amount, paid_amount')
                ->where(function ($query) {
                    if (ifMember()) {
                        $query->where('nso007_sales.user_id', Auth::id());
                    } else {
                        $query->where('nso007_sales.branch_id', FindBranchID());
                    }
                })
                ->where('nso007_sales.sale_type', 'retail')
                ->where('nso007_payment.type', 'retail')
                ->where(function ($query) use ($request) {
                    if ($request['branch_id']) {
                        $query->whereIn('nso007_sales.branch_id', $request['branch_id']);
                        $query->orwhereIn('nso007_sales.request_to', $request['branch_id']);
                    }
                })
                ->where(function ($query) use ($request) {
                    IF($request['from_date']){
                        $query->where('nso007_sales.sale_date', '>=', date('Y-m-d', strtotime($request['from_date'])));
                    }
                    if($request['to_date']){
                        $query->where('nso007_sales.sale_date', '<=', date('Y-m-d', strtotime($request['to_date'])));
                    }
                    if ($request['payment_status']) {
                        $query->where('nso007_payment.payment_status', $request['payment_status']);
                    }
                    if ($request['type_illness']) {
                        $query->where('nso007_customers.type_illness', 'LIKE', '%"' . $request['type_illness'] . '"%');
                    }
                    if ($request['user_id']) {
                        $query->where('nso007_sales.user_id', $request['user_id']);
                    }
                    if ($request['customer_id']) {
                        $query->where('nso007_sales.customer_id', $request['customer_id']);
                    }
                    if ($request['payment_type']) {
                        $query->where('nso007_sales.payment_type', $request['payment_type']);
                    }
                })
                ->orderBy('nso007_sales.reference_number','DESC')
                ->take(20);
            $count = $sale->count();
            return DataTables::of($sale)
                ->with([
                    "recordsTotal" => $count,
                    "recordsFiltered" => $count,
                ])

                ->addColumn('payment_amount', function ($action) {
                    $action->remain = $action->payment_amount + $action->punishment - $action->paid_amount;
                    return '<span class="sum_data"
                    data-paid ="'.$action->paid_amount.'"
                    data-payment_amount ="'.$action->payment_amount.'"
                    data-remain ="'.$action->remain.'"
                    data-delete_at ="'.$action->delete_at.'"

                    >$'.number_format($action->payment_amount, 2) . '</span>';
                })
                ->addColumn('paid_amount', function ($action) {
                    return '$'.number_format($action->paid_amount, 2);
                })
                ->addColumn('remain', function ($action) {
                    return '$'.number_format($action->remain, 2);
                })
                ->addColumn('sale_date', function ($action) {
                    return myDate($action->sale_date);
                })
                ->editColumn('payment_method', function ($action) {
                    $acc = AccountChartModel::find($action->payment_method);
                    return $acc->acc_name ?? '';
                })
                ->addColumn('type_of_illness', function ($action) {
                    if ($action->type_illness) {
                        $ill = TypeOfIllness::whereIn('id', json_decode($action->type_illness))->pluck(if_kh() ? 'name_km' : 'name_en');
                        $ill = $ill->implode(', ');
                        return $ill;
                    }
                })
                ->editColumn('payment_type', function ($action) {
                    if ($action->payment_type) {
                        return AccountChartModel::find($action->payment_type)->acc_name??'';
                    }
                })
                ->addColumn('branch_name', function ($action) {
                    $id = $action->request_to??$action->branch_id;
                    $branch = findBranch($id);
                    return $branch->name ?? '';
                })
                ->editColumn('request_to', function ($action) {
                    $branch = findBranch($action->request_to);
                    return $branch->name ?? '';
                })
                ->editColumn('payment_status', function ($action) {
                    if ($action->payment_status) {
                        return textStatus($action->payment_status);
                    }
                })
                ->addColumn('total_qty', function ($action) {
                    return $action->detail->sum('qty').' ឯកតា';
                })
                ->addIndexColumn()
                ->rawColumns(['action', 'payment_status', 'type_of_illness', 'remain', 'total_qty','payment_amount'])
                ->make(true);
        }

        $url = $request->url;
        return view('administrator.report-sales.retail', compact('url'));

    }

    public function wholesale_report(Request $request)
    {
        if ($request->isAjax) {
            $arr = $request->all();
            $remove = ['start', 'length', 'isAjax', 'record', 'page', '_', 'columns', 'search', 'draw'];
            foreach ($arr as $key => $row) {
                if (array_search($key, $remove)) {
                    unset($arr[$key]);
                }
                if ($row === null) {
                    unset($arr[$key]);
                }
            }
            unset($arr['start']);

            $sale = SaleModel::
                leftJoin('nso007_payment', 'nso007_sales.id', 'nso007_payment.invoice_id')
                ->with('detail')
                ->selectRaw('
                    nso007_sales.sale_date,
                    reference_number,
                    nso007_sales.id,
                    nso007_sales.user_id,
                    nso007_sales.customer_id,
                    nso007_sales.branch_id,
                    nso007_sales.status,
                    nso007_sales.payment_status,
                    nso007_sales.payment_type,
                    nso007_sales.payment_method,
                    paid_amount_kh, payment_amount, paid_amount')
                ->where('nso007_sales.sale_type', 'wholesale')
                ->where('nso007_payment.type', 'wholesale')
                ->where(function ($query) {
                    if (ifMember()) {
                        $query->where('nso007_sales.user_id', Auth::id());
                    } else {
                        $query->where('nso007_sales.branch_id', FindBranchID());
                    }
                })
                ->where(function ($query) use ($arr) {
                    foreach ($arr as $key => $row) {
                        if ($key === 'branch_id') {
                            $query->where('nso007_sales.customer_id', $row);
                        } else if ($key === 'from_date') {
                            $query->where('nso007_sales.sale_date', '>=', sDate($row));
                        } else if ($key === 'to_date') {
                            $query->where('nso007_sales.sale_date', '<=', sDate($row));
                        } else if ($key === 'payment_status') {
                            $query->where('nso007_payment.' . $key, $row);
                        } else {
                            $query->where('nso007_sales.' . $key, $row);
                        }
                    }
                })
                ->orderBy('id', 'desc')
                ->take(20);
            $count = $sale->count();
            return DataTables::of($sale)
                ->with([
                    "recordsTotal" => $count,
                    "recordsFiltered" => $count,
                ])
                ->addColumn('paid_amount', function ($action) {
                    return number_format($action->paid_amount, 2) . '$';
                })
                ->addColumn('payment_amount', function ($action) {
                    return number_format($action->payment_amount, 2) . '$';
                })
                ->addColumn('remain', function ($action) {
                    return number_format(($action->payment_amount - $action->paid_amount), 2) . '$';
                })
                ->addColumn('sale_date', function ($action) {
                    return myDate($action->sale_date);
                })
                ->addColumn('seller', function ($action) {
                    $user = findUser($action->user_id);
                    return $user ? $user->name : '';
                })

                ->editColumn('payment_method', function ($action) {
                    if ($action->payment_method) {
                        return AccountChartModel::find($action->payment_method)->acc_name??'';
                    }
                })
                ->addColumn('total_store_qty', function ($action) {
                    return $action->detail->sum('store_qty').' ឯកតា';
                })
                ->addColumn('total_deliver_qty', function ($action) {
                    return $action->detail->sum('deliver_qty').' ឯកតា';
                })
                ->addColumn('total_qty', function ($action) {
                    return $action->detail->sum('qty').' ឯកតា';
                })
                ->addColumn('action', function ($action) {
                    if (!$action->status == 1 || !$action->status == 0) {
                        return '<i href="javascript:;"
                    data-seller="' . $action->seller . '"
                    data-branch_name="' . $action->branch_name . '"
                    class="fa fa-eye btn btn-sm btn-primary showDetail"
                    data-created_at="' . date('d-m-Y', strtotime($action->sale_date)) . '"
                    data-invoice="' . $action->invoice_number . '"
                    data-id="' . $action->id . '"
                    data-url = "' . route("wholesale.show", $action->id) . '"
                    title="View Detail"></i>';
                    }
                })
                ->editColumn('payment_status', function ($action) {
                    if ($action->payment_status) {
                        return getPaymentStatus($action->payment_status);
                    }
                })
                ->addIndexColumn()
                ->rawColumns(['image', 'action', 'payment_status', 'seller', 'branch_name','total_qty'])
                ->make(true);
        }
        return view('administrator.report-sales.wholesale');

    }


}

