<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PointSettingController extends Controller
{

    public function index()
    {
        $setting = file_get_contents(base_path('resources/views/administrator/point_setting/point_setting.json'));
        $setting = json_decode($setting, true);
        return view('administrator.point_setting.index', compact('setting'));
    }

    public function create()
    {
        // return view('administrator.point_setting.create'); 
    }

    public function store(Request $request)
    {
        $setting = file_get_contents(base_path('resources/views/administrator/point_setting/point_setting.json'));
        $setting = json_decode($setting, true);

        $setting[0]['y'] = $request['y'];

        $setting[0]['value1'] = $request['value1'];
        $setting[0]['value2'] = $request['value2'];
        $setting[0]['value3'] = $request['value3'];
        $setting[0]['value4'] = $request['value4'];

        $setting[0]['x1'] = $request['x1'];
        $setting[0]['x2'] = $request['x2'];
        $setting[0]['x3'] = $request['x3'];
        $setting[0]['x4'] = $request['x4'];

        $newJsonString = json_encode($setting, JSON_PRETTY_PRINT);
        file_put_contents(base_path('resources/views/administrator/point_setting/point_setting.json'), stripslashes($newJsonString));
        return response()->json(['status'=>'ok']);
    }

    public function show($id)
    {
        $setting = file_get_contents(base_path('resources/views/administrator/point_setting/point_setting.json'));
        $setting = json_decode($setting, true);
        unset($setting[$id]);
        $newJsonString = json_encode($setting, JSON_PRETTY_PRINT);
        file_put_contents(base_path('resources/views/administrator/point_setting/point_setting.json'), stripslashes($newJsonString));
        return response()->json('done');
    }

    public function edit(Request $request, $id)
    {
        $setting = file_get_contents(base_path('resources/views/administrator/point_setting/point_setting.json'));
        $setting = json_decode($setting, true);
        if (@$setting[$id]) {
            $setting[$id]['start_price'] = $request['start_price'];
            $setting[$id]['end_price'] = $request['end_price'];
            $setting[$id]['point'] = $request['point'];
        } else {
            $setting[count($setting)] = [
                "start_price" => $request['start_price'],
                "end_price" => $request['end_price'],
                "point" => $request['point'],
                "class" => "form-control numeric",
                "max-length" => "4"
            ];
        }
        $newJsonString = json_encode($setting, JSON_PRETTY_PRINT);
        file_put_contents(base_path('resources/views/administrator/point_setting/point_setting.json'), stripslashes($newJsonString));
        return response()->json('done');
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {

    }
}
