<?php

namespace App\Http\Controllers\Administrator;


use App\Model\PermissionModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
use DataTables;

class PermissionController extends Controller
{
    function __construct()
     {

     }
    public function create()
    {
        $app = PermissionModel::groupBy('app_name')->pluck('app_name','app_name');
        $group = PermissionModel::groupBy('group_name')->pluck('group_name','group_name');
        return view('administrator.permission.create',compact('app','group'));
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'group_name' => 'required',
            'app_name' => 'required',
        ]);
        $permission = new PermissionModel();
        $permission->name =  $request->name;
        $permission->group_name =  $request->group_name;
        $permission->app_name =  $request->app_name;
        $permission->guard_name =  'web';
        $permission->save();
        return response()->json(['status'=>'success']);
    }
    public function edit($id)
    {
        $role = Role::find($id);
        $permission = Permission::get();
        $group_permission = Permission::where('app_name','app')->groupBy('group_name')->get();
        $group_app_name = Permission::where('app_name','HR')->groupBy('group_name')->get();
        $rolePermissions = DB::table("role_has_permissions")->where("role_has_permissions.role_id",$id)
            ->pluck('role_has_permissions.permission_id','role_has_permissions.permission_id')
            ->all();
        return view('administrator.roles.edit',compact('role','permission','rolePermissions','group_permission','group_app_name'));

    }
    public function update(Request $request, $id)

    {
        $this->validate($request, [
            'name' => 'required',
            'permission' => 'required',
        ]);

        $role = Role::find($id);
        $role->name = $request->input('name');
        $role->group_role =  'app';
        $role->save();

        $role->syncPermissions($request->input('permission'));

        return redirect()->back()

                        ->with('success','Role updated successfully !');
    }

}